/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.publish.actions.AbstractPublicationRequest;
import com.openexchange.ajax.publish.actions.ListPublicationsResponse;
import com.openexchange.java.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class ListPublicationsRequest
extends AbstractPublicationRequest<ListPublicationsResponse> {
    private List<String> columns;
    private Map<String, List<String>> dynamicColumns;
    private List<Integer> ids;

    public ListPublicationsRequest() {
    }

    public ListPublicationsRequest(List<Integer> ids, List<String> columns) {
        this();
        this.setIds(ids);
        this.setColumns(columns);
    }

    public ListPublicationsRequest(List<Integer> ids, List<String> columns, Map<String, List<String>> dynamicColumns) {
        this(ids, columns);
        this.setDynamicColumns(dynamicColumns);
    }

    @Override
    public Object getBody() throws JSONException {
        return new JSONArray(this.ids);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> params = new LinkedList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "list"));
        if (this.getColumns() != null) {
            params.add(new AJAXRequest.Parameter("columns", Strings.join(this.getColumns(), (String)",")));
        }
        if (this.getDynamicColumns() != null) {
            for (String plugin : this.getDynamicColumns().keySet()) {
                params.add(new AJAXRequest.Parameter(plugin, Strings.join((Collection)this.getDynamicColumns().get(plugin), (String)",")));
            }
        }
        return params.toArray(new AJAXRequest.Parameter[0]);
    }

    @Override
    public AbstractAJAXParser<? extends ListPublicationsResponse> getParser() {
        return new AbstractAJAXParser<ListPublicationsResponse>(this.isFailOnError()){

            @Override
            protected ListPublicationsResponse createResponse(Response response) throws JSONException {
                return new ListPublicationsResponse(response);
            }
        };
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setDynamicColumns(Map<String, List<String>> dynamicColumns) {
        this.dynamicColumns = dynamicColumns;
    }

    public Map<String, List<String>> getDynamicColumns() {
        return this.dynamicColumns;
    }

    public void setIds(List<Integer> ids) {
        this.ids = ids;
    }

    public List<Integer> getIds() {
        return this.ids;
    }
}

