/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;

public abstract class AbstractRedirectParser<T extends AbstractAJAXResponse>
extends AbstractAJAXParser<T> {
    private final boolean cookiesNeeded;
    private String location;
    private int statusCode;
    private String reasonPhrase;

    protected AbstractRedirectParser() {
        this(true);
    }

    protected AbstractRedirectParser(boolean cookiesNeeded) {
        super(true);
        this.cookiesNeeded = cookiesNeeded;
    }

    protected int getStatusCode() {
        return this.statusCode;
    }

    protected void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    protected String getReasonPhrase() {
        return this.reasonPhrase;
    }

    protected void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    protected void setLocation(String location) {
        this.location = location;
    }

    protected String getLocation() {
        return this.location;
    }

    @Override
    protected Response getResponse(String body) throws JSONException {
        throw new JSONException("Method not supported when parsing redirect responses.");
    }

    @Override
    public String checkResponse(HttpResponse resp) throws ParseException, IOException {
        this.statusCode = resp.getStatusLine().getStatusCode();
        this.reasonPhrase = resp.getStatusLine().getReasonPhrase();
        AbstractRedirectParser.assertEquals((String)"Response code is not okay.", (long)302L, (long)this.statusCode);
        this.parseLocationHeader(resp);
        if (this.cookiesNeeded) {
            boolean oxCookieFound = false;
            boolean jsessionIdCookieFound = false;
            BasicHeaderElementIterator iter = new BasicHeaderElementIterator(resp.headerIterator("Set-Cookie"));
            while (iter.hasNext()) {
                HeaderElement element = iter.nextElement();
                if (element.getName().startsWith(LoginServlet.SECRET_PREFIX)) {
                    oxCookieFound = true;
                    continue;
                }
                if (!"JSESSIONID".equals(element.getName())) continue;
                jsessionIdCookieFound = true;
            }
            AbstractRedirectParser.assertTrue((String)"Session cookie is missing.", (boolean)oxCookieFound);
            AbstractRedirectParser.assertTrue((String)"JSESSIONID cookie is missing.", (boolean)jsessionIdCookieFound);
        }
        return EntityUtils.toString((HttpEntity)resp.getEntity());
    }

    protected final void parseLocationHeader(HttpResponse resp) {
        Header[] headers = resp.getHeaders("Location");
        AbstractRedirectParser.assertEquals((String)"There should be exactly one Location header.", (long)1L, (long)headers.length);
        this.location = headers[0].getValue();
        AbstractRedirectParser.assertNotNull((String)"Location for redirect is missing.", (Object)this.location);
    }

    @Override
    public T parse(String body) throws JSONException {
        if (null == this.location) {
            throw new JSONException("Location for redirect is missing. Ensure to call method parseLocationHeader(HttpResponse) when overwriting checkResponse(HttpResponse).");
        }
        return this.createResponse(this.location);
    }

    @Override
    protected final T createResponse(Response response) {
        return null;
    }

    protected abstract T createResponse(String var1) throws JSONException;
}

