/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.calendar;

import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.find.calendar.CalendarFindTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.find.Module;
import com.openexchange.find.calendar.CalendarFacetType;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.common.FolderType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.DefaultFacet;
import com.openexchange.find.facet.ExclusiveFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.facet.SimpleFacet;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class QueryTest
extends CalendarFindTest {
    public QueryTest(String name) {
        super(name);
    }

    public void testFilterChaining() throws Exception {
        Appointment appointment = this.randomPrivateAppointment();
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(QueryTest.createActiveFieldFacet((FacetType)CalendarFacetType.SUBJECT, "subject", this.randomSubstring(appointment.getTitle())));
        facets.add(QueryTest.createActiveFieldFacet((FacetType)CalendarFacetType.LOCATION, "location", this.randomSubstring(appointment.getLocation())));
        facets.add(QueryTest.createActiveFieldFacet((FacetType)CalendarFacetType.DESCRIPTION, "description", this.randomSubstring(appointment.getNote())));
        facets.add(QueryTest.createActiveFacet((FacetType)CalendarFacetType.RELATIVE_DATE, "future", "date", "future"));
        facets.add(QueryTest.createActiveFacet((FacetType)CalendarFacetType.STATUS, "accepted", "status", "accepted"));
        facets.add(QueryTest.createActiveFacet((FacetType)CalendarFacetType.RECURRING_TYPE, "single", "type", "single"));
        facets.add(QueryTest.createActiveFacet((FacetType)CalendarFacetType.PARTICIPANT, String.valueOf(this.client.getValues().getUserId()), "users", String.valueOf(this.client.getValues().getUserId())));
        appointment = this.manager.insert(appointment);
        List<PropDocument> documents = this.query(facets);
        QueryTest.assertTrue((String)"no appointments found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"appointment not found", (Object)QueryTest.findByProperty(documents, "title", appointment.getTitle()));
    }

    public void testFilterSubject() throws Exception {
        Appointment appointment = this.randomPrivateAppointment();
        appointment.setTitle(QueryTest.randomUID());
        appointment = this.manager.insert(appointment);
        List<PropDocument> documents = this.query(Collections.singletonList(QueryTest.createActiveFieldFacet((FacetType)CalendarFacetType.SUBJECT, "subject", this.randomSubstring(appointment.getTitle()))));
        QueryTest.assertTrue((String)"no appointments found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"appointment not found", (Object)QueryTest.findByProperty(documents, "title", appointment.getTitle()));
    }

    public void testEmptyFilter() throws Exception {
        Appointment appointment = this.randomPrivateAppointment();
        appointment.setTitle(QueryTest.randomUID());
        appointment = this.manager.insert(appointment);
        List<PropDocument> documents = this.query(Collections.singletonList(QueryTest.createActiveFieldFacet((FacetType)CalendarFacetType.SUBJECT, "subject", "")));
        QueryTest.assertTrue((String)"no appointments found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"appointment not found", (Object)QueryTest.findByProperty(documents, "title", appointment.getTitle()));
    }

    public void testFilterLocation() throws Exception {
        Appointment appointment = this.randomPrivateAppointment();
        appointment.setLocation(QueryTest.randomUID());
        appointment = this.manager.insert(appointment);
        List<PropDocument> documents = this.query(Collections.singletonList(QueryTest.createActiveFieldFacet((FacetType)CalendarFacetType.LOCATION, "location", this.randomSubstring(appointment.getLocation()))));
        QueryTest.assertTrue((String)"no appointments found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"appointment not found", (Object)QueryTest.findByProperty(documents, "location", appointment.getLocation()));
    }

    public void testFilterDescription() throws Exception {
        Appointment appointment = this.randomPrivateAppointment();
        appointment.setNote(QueryTest.randomUID());
        appointment = this.manager.insert(appointment);
        List<PropDocument> documents = this.query(Collections.singletonList(QueryTest.createActiveFieldFacet((FacetType)CalendarFacetType.DESCRIPTION, "description", this.randomSubstring(appointment.getNote()))));
        QueryTest.assertTrue((String)"no appointments found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"appointment not found", (Object)QueryTest.findByProperty(documents, "note", appointment.getNote()));
    }

    public void testFilterRelativeDate() throws Exception {
        Appointment comingAppointment = this.randomPrivateAppointment();
        comingAppointment.setStartDate(TimeTools.D("tomorrow at noon"));
        comingAppointment.setEndDate(TimeTools.D("tomorrow at noon"));
        comingAppointment = this.manager.insert(comingAppointment);
        Appointment pastAppointment = this.randomPrivateAppointment();
        pastAppointment.setStartDate(TimeTools.D("yesterday at noon"));
        pastAppointment.setEndDate(TimeTools.D("yesterday at noon"));
        pastAppointment = this.manager.insert(pastAppointment);
        List<PropDocument> comingDocuments = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)CalendarFacetType.RELATIVE_DATE, "future", "date", "future")));
        QueryTest.assertTrue((String)"no appointments found", (0 < comingDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"coming appointment not found", (Object)QueryTest.findByProperty(comingDocuments, "title", comingAppointment.getTitle()));
        QueryTest.assertNull((String)"past appointment found", (Object)QueryTest.findByProperty(comingDocuments, "title", pastAppointment.getTitle()));
        List<PropDocument> pastDocuments = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)CalendarFacetType.RELATIVE_DATE, "past", "date", "past")));
        QueryTest.assertTrue((String)"no appointments found", (0 < pastDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"past appointment not found", (Object)QueryTest.findByProperty(pastDocuments, "title", pastAppointment.getTitle()));
        QueryTest.assertNull((String)"coming appointment found", (Object)QueryTest.findByProperty(pastDocuments, "title", comingAppointment.getTitle()));
    }

    public void testFilterStatus() throws Exception {
        Appointment acceptedAppointment = this.randomPrivateAppointment();
        acceptedAppointment = this.manager.insert(acceptedAppointment);
        this.manager.confirm(acceptedAppointment, 1, "accept");
        Appointment declinedAppointment = this.randomPrivateAppointment();
        declinedAppointment = this.manager.insert(declinedAppointment);
        this.manager.confirm(declinedAppointment, 2, "decline");
        Appointment tentativeAppointment = this.randomPrivateAppointment();
        tentativeAppointment = this.manager.insert(tentativeAppointment);
        this.manager.confirm(tentativeAppointment, 3, "tentative");
        Appointment noneAppointment = this.randomPrivateAppointment();
        noneAppointment = this.manager.insert(noneAppointment);
        this.manager.confirm(noneAppointment, 0, "none");
        List<PropDocument> acceptDocuments = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)CalendarFacetType.STATUS, "accepted", "status", "accepted")));
        QueryTest.assertTrue((String)"no appointments found", (0 < acceptDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"accepted appointment not found", (Object)QueryTest.findByProperty(acceptDocuments, "title", acceptedAppointment.getTitle()));
        QueryTest.assertNull((String)"declined appointment found", (Object)QueryTest.findByProperty(acceptDocuments, "title", declinedAppointment.getTitle()));
        QueryTest.assertNull((String)"tentative appointment found", (Object)QueryTest.findByProperty(acceptDocuments, "title", tentativeAppointment.getTitle()));
        QueryTest.assertNull((String)"no status appointment found", (Object)QueryTest.findByProperty(acceptDocuments, "title", noneAppointment.getTitle()));
        List<PropDocument> declineDocuments = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)CalendarFacetType.STATUS, "declined", "status", "declined")));
        QueryTest.assertTrue((String)"no appointments found", (0 < declineDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNull((String)"accepted appointment found", (Object)QueryTest.findByProperty(declineDocuments, "title", acceptedAppointment.getTitle()));
        QueryTest.assertNotNull((String)"declined appointment not found", (Object)QueryTest.findByProperty(declineDocuments, "title", declinedAppointment.getTitle()));
        QueryTest.assertNull((String)"tentative appointment found", (Object)QueryTest.findByProperty(declineDocuments, "title", tentativeAppointment.getTitle()));
        QueryTest.assertNull((String)"no status appointment found", (Object)QueryTest.findByProperty(declineDocuments, "title", noneAppointment.getTitle()));
        List<PropDocument> tentativeDocuments = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)CalendarFacetType.STATUS, "tentative", "status", "tentative")));
        QueryTest.assertTrue((String)"no appointments found", (0 < declineDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNull((String)"accepted appointment found", (Object)QueryTest.findByProperty(tentativeDocuments, "title", acceptedAppointment.getTitle()));
        QueryTest.assertNull((String)"declined appointment found", (Object)QueryTest.findByProperty(tentativeDocuments, "title", declinedAppointment.getTitle()));
        QueryTest.assertNotNull((String)"tentative appointment not found", (Object)QueryTest.findByProperty(tentativeDocuments, "title", tentativeAppointment.getTitle()));
        QueryTest.assertNull((String)"no status appointment found", (Object)QueryTest.findByProperty(tentativeDocuments, "title", noneAppointment.getTitle()));
        List<PropDocument> noStatusDocuments = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)CalendarFacetType.STATUS, "none", "status", "none")));
        QueryTest.assertTrue((String)"no appointments found", (0 < declineDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNull((String)"accepted appointment found", (Object)QueryTest.findByProperty(noStatusDocuments, "title", acceptedAppointment.getTitle()));
        QueryTest.assertNull((String)"declined appointment found", (Object)QueryTest.findByProperty(noStatusDocuments, "title", declinedAppointment.getTitle()));
        QueryTest.assertNull((String)"tentative appointment found", (Object)QueryTest.findByProperty(noStatusDocuments, "title", tentativeAppointment.getTitle()));
        QueryTest.assertNotNull((String)"no status appointment not found", (Object)QueryTest.findByProperty(noStatusDocuments, "title", noneAppointment.getTitle()));
    }

    public void testFilterRecurringType() throws Exception {
        Appointment appointment = this.manager.insert(this.randomPrivateAppointment());
        Appointment recurringAppointment = this.randomPrivateAppointment();
        recurringAppointment.setRecurrenceType(1);
        recurringAppointment.setInterval(1);
        recurringAppointment = this.manager.insert(recurringAppointment);
        List<PropDocument> singleDocuments = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)CalendarFacetType.RECURRING_TYPE, "single", "type", "single")));
        QueryTest.assertTrue((String)"no appointments found", (0 < singleDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"single appointment not found", (Object)QueryTest.findByProperty(singleDocuments, "title", appointment.getTitle()));
        QueryTest.assertNull((String)"recurring appointment found", (Object)QueryTest.findByProperty(singleDocuments, "title", recurringAppointment.getTitle()));
        List<PropDocument> recurringDocuments = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)CalendarFacetType.RECURRING_TYPE, "series", "type", "series")));
        QueryTest.assertTrue((String)"no appointments found", (0 < recurringDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNull((String)"single appointment found", (Object)QueryTest.findByProperty(recurringDocuments, "title", appointment.getTitle()));
        QueryTest.assertNotNull((String)"recurring appointment not found", (Object)QueryTest.findByProperty(recurringDocuments, "title", recurringAppointment.getTitle()));
    }

    public void testFilterParticipants() throws Exception {
        ExternalUserParticipant participant = new ExternalUserParticipant(QueryTest.randomUID() + "example.com");
        Appointment appointment = this.randomPrivateAppointment();
        appointment.addParticipant((Participant)participant);
        appointment = this.manager.insert(appointment);
        List<PropDocument> documents = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)CalendarFacetType.PARTICIPANT, participant.getEmailAddress(), "participants", participant.getEmailAddress())));
        QueryTest.assertTrue((String)"no appointments found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"appointment not found", (Object)QueryTest.findByProperty(documents, "title", appointment.getTitle()));
    }

    public void testFilterUsers() throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId = client2.getValues().getUserId();
        client2.logout();
        UserParticipant userParticipant = new UserParticipant(userId);
        Appointment appointment = this.randomPrivateAppointment();
        appointment.addParticipant((Participant)userParticipant);
        appointment = this.manager.insert(appointment);
        List<PropDocument> documents = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)CalendarFacetType.PARTICIPANT, String.valueOf(userParticipant.getIdentifier()), "users", String.valueOf(userParticipant.getIdentifier()))));
        QueryTest.assertTrue((String)"no appointments found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"appointment not found", (Object)QueryTest.findByProperty(documents, "title", appointment.getTitle()));
    }

    public void testCorrectTimeZone() throws Exception {
        TimeZone userTimeZone = this.client.getValues().getTimeZone();
        TimeZone responseTimeZone = TimeZone.getTimeZone("America/New York");
        if (responseTimeZone.getRawOffset() == userTimeZone.getRawOffset()) {
            responseTimeZone = TimeZone.getTimeZone("Europe/Berlin");
        }
        Calendar originStartDate = TimeTools.createCalendar(userTimeZone);
        Calendar originEndDate = (Calendar)originStartDate.clone();
        originEndDate.add(11, 1);
        Calendar expectedStartDate = TimeTools.createCalendar(responseTimeZone);
        Appointment appointment = this.randomPrivateAppointment();
        appointment.setStartDate(originStartDate.getTime());
        appointment.setEndDate(originEndDate.getTime());
        appointment.setTitle(QueryTest.randomUID());
        appointment = this.manager.insert(appointment);
        List<PropDocument> documents = this.query(Collections.singletonList(QueryTest.createActiveFieldFacet((FacetType)CalendarFacetType.SUBJECT, "subject", this.randomSubstring(appointment.getTitle()))), Collections.singletonMap("timezone", responseTimeZone.getID()));
        QueryTest.assertTrue((String)"no appointments found", (0 < documents.size() ? 1 : 0) != 0);
        PropDocument document = QueryTest.findByProperty(documents, "title", appointment.getTitle());
        QueryTest.assertNotNull((String)"appointment not found", (Object)document);
        Date d = new Date(Long.parseLong(document.getProps().get("start_date").toString()));
        Calendar responseStartDate = Calendar.getInstance(responseTimeZone);
        responseStartDate.setTime(d);
        QueryTest.assertEquals((Object)expectedStartDate, (Object)responseStartDate);
    }

    public void testTokenizedQuery() throws Exception {
        Appointment appointment = this.randomPrivateAppointment();
        String t1 = QueryTest.randomUID();
        String t2 = QueryTest.randomUID();
        String t3 = QueryTest.randomUID();
        appointment.setTitle(t1 + " " + t2 + " " + t3);
        appointment = this.manager.insert(appointment);
        SimpleFacet globalFacet = (SimpleFacet)QueryTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.CALENDAR, t1 + " " + t3));
        List<PropDocument> documents = this.query(Collections.singletonList(QueryTest.createActiveFacet(globalFacet)));
        QueryTest.assertTrue((String)"no appointments found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"appointment not found", (Object)QueryTest.findByProperty(documents, "title", appointment.getTitle()));
        globalFacet = (SimpleFacet)QueryTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.CALENDAR, "\"" + t1 + " " + t2 + "\""));
        documents = this.query(Collections.singletonList(QueryTest.createActiveFacet(globalFacet)));
        QueryTest.assertTrue((String)"no appointments found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"appointment not found", (Object)QueryTest.findByProperty(documents, "title", appointment.getTitle()));
        globalFacet = (SimpleFacet)QueryTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.CALENDAR, "\"" + t1 + " " + t3 + "\""));
        documents = this.query(Collections.singletonList(QueryTest.createActiveFacet(globalFacet)));
        QueryTest.assertTrue((String)"appointments found", (0 == documents.size() ? 1 : 0) != 0);
    }

    public void testFolderTypeFacet() throws Exception {
        FolderType[] typesInOrder = new FolderType[]{FolderType.PRIVATE, FolderType.PUBLIC, FolderType.SHARED};
        FolderObject[] folders = new FolderObject[]{this.folderManager.insertFolderOnServer(this.folderManager.generatePrivateFolder(QueryTest.randomUID(), 2, this.client.getValues().getPrivateAppointmentFolder(), this.client.getValues().getUserId())), this.folderManager.insertFolderOnServer(this.folderManager.generatePublicFolder(QueryTest.randomUID(), 2, 2, this.client.getValues().getUserId())), this.folderManager2.insertFolderOnServer(this.folderManager.generateSharedFolder(QueryTest.randomUID(), 2, this.client2.getValues().getPrivateAppointmentFolder(), this.client2.getValues().getUserId(), this.client.getValues().getUserId()))};
        Appointment[] appointments = new Appointment[]{this.manager.insert(this.randomAppointment(folders[0].getObjectID())), this.manager.insert(this.randomAppointment(folders[1].getObjectID())), this.manager2.insert(this.randomAppointment(folders[2].getObjectID()))};
        block5: for (int i = 0; i < 3; ++i) {
            FolderType folderType = typesInOrder[i];
            List<Facet> facets = this.autocomplete(Module.CALENDAR, "");
            ExclusiveFacet folderTypeFacet = (ExclusiveFacet)QueryTest.findByType((FacetType)CommonFacetType.FOLDER_TYPE, facets);
            FacetValue typeValue = QueryTest.findByValueId(folderType.getIdentifier(), (DefaultFacet)folderTypeFacet);
            List<PropDocument> docs = this.query(Collections.singletonList(QueryTest.createActiveFacet((DefaultFacet)folderTypeFacet, typeValue)));
            PropDocument[] foundDocs = new PropDocument[3];
            for (PropDocument doc : docs) {
                Map<String, Object> props = doc.getProps();
                if (appointments[0].getTitle().equals(props.get("title"))) {
                    foundDocs[0] = doc;
                    continue;
                }
                if (appointments[1].getTitle().equals(props.get("title"))) {
                    foundDocs[1] = doc;
                    continue;
                }
                if (!appointments[2].getTitle().equals(props.get("title"))) continue;
                foundDocs[2] = doc;
            }
            switch (folderType) {
                case PRIVATE: {
                    QueryTest.assertNotNull((String)"Private appointment not found", (Object)foundDocs[0]);
                    QueryTest.assertNull((String)"Public appointment found but should not", (Object)foundDocs[1]);
                    QueryTest.assertNull((String)"Shared appointment found but should not", (Object)foundDocs[2]);
                    continue block5;
                }
                case PUBLIC: {
                    QueryTest.assertNull((String)"Private appointment found but should not", (Object)foundDocs[0]);
                    QueryTest.assertNotNull((String)"Public appointment not found", (Object)foundDocs[1]);
                    QueryTest.assertNull((String)"Shared appointment found but should not", (Object)foundDocs[2]);
                    continue block5;
                }
                case SHARED: {
                    QueryTest.assertNull((String)"Private appointment found but should not", (Object)foundDocs[0]);
                    QueryTest.assertNull((String)"Public appointment found but should not", (Object)foundDocs[1]);
                    QueryTest.assertNotNull((String)"Shared appointment not found", (Object)foundDocs[2]);
                }
            }
        }
    }
}

