/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;

public class DistListTest
extends AbstractManagedContactTest {
    public DistListTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testCreateWithoutMembers() throws OXException {
        Contact distributionList = super.generateContact("List");
        distributionList.setDistributionList(new DistributionListEntryObject[0]);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
    }

    public void testCreateWithContactWithoutEMail() throws OXException {
        Contact referencedContact = super.generateContact("Test");
        referencedContact = this.manager.newAction(referencedContact);
        Contact distributionList = super.generateContact("List");
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{new DistributionListEntryObject()};
        members[0].setEntryID(referencedContact.getObjectID());
        members[0].setFolderID(referencedContact.getParentFolderID());
        members[0].setDisplayname(referencedContact.getDisplayName());
        members[0].setEmailfield(1);
        distributionList.setDistributionList(members);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListTest.assertMatches(distributionList.getDistributionList(), referencedContact);
    }

    public void testCreateWithOneOffWithoutEMail() throws OXException {
        Contact distributionList = super.generateContact("List");
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{new DistributionListEntryObject()};
        members[0].setDisplayname("Test no mail");
        members[0].setEmailfield(0);
        distributionList.setDistributionList(members);
        distributionList = this.manager.newAction(distributionList);
        AbstractAJAXResponse lastResponse = this.manager.getLastResponse();
        DistListTest.assertNotNull((String)"no error message", (Object)lastResponse.getErrorMessage());
        DistListTest.assertTrue((String)"wrong exception", (boolean)ContactExceptionCodes.EMAIL_MANDATORY_FOR_EXTERNAL_MEMBERS.equals(lastResponse.getException()));
        members[0].setEmailaddress("");
        distributionList = this.manager.newAction(distributionList);
        lastResponse = this.manager.getLastResponse();
        DistListTest.assertNotNull((String)"no error message", (Object)lastResponse.getErrorMessage());
        DistListTest.assertTrue((String)"wrong exception", (boolean)ContactExceptionCodes.EMAIL_MANDATORY_FOR_EXTERNAL_MEMBERS.equals(lastResponse.getException()));
    }

    public void testRemoveEMailFromOneOff() throws OXException {
        Contact distributionList = super.generateContact("List");
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{new DistributionListEntryObject()};
        members[0].setDisplayname("Test OneOff");
        members[0].setEmailaddress("hallo@example.com");
        members[0].setEmailfield(0);
        distributionList.setDistributionList(members);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        distributionList.getDistributionList()[0].setEmailaddress(null);
        distributionList = this.manager.newAction(distributionList);
        AbstractAJAXResponse lastResponse = this.manager.getLastResponse();
        DistListTest.assertNotNull((String)"no error message", (Object)lastResponse.getErrorMessage());
        DistListTest.assertTrue((String)"wrong exception", (boolean)ContactExceptionCodes.EMAIL_MANDATORY_FOR_EXTERNAL_MEMBERS.equals(lastResponse.getException()));
        distributionList.getDistributionList()[0].setEmailaddress("");
        distributionList = this.manager.newAction(distributionList);
        lastResponse = this.manager.getLastResponse();
        DistListTest.assertNotNull((String)"no error message", (Object)lastResponse.getErrorMessage());
        DistListTest.assertTrue((String)"wrong exception", (boolean)ContactExceptionCodes.EMAIL_MANDATORY_FOR_EXTERNAL_MEMBERS.equals(lastResponse.getException()));
    }

    public void testDeleteReferencedContact() throws OXException {
        Contact referencedContact = super.generateContact("Test");
        referencedContact.setEmail1("mail@example.com");
        referencedContact = this.manager.newAction(referencedContact);
        Contact distributionList = super.generateContact("List");
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{new DistributionListEntryObject()};
        members[0].setEntryID(referencedContact.getObjectID());
        members[0].setFolderID(referencedContact.getParentFolderID());
        members[0].setDisplayname(referencedContact.getDisplayName());
        members[0].setEmailaddress(referencedContact.getEmail1());
        members[0].setEmailfield(1);
        distributionList.setDistributionList(members);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListTest.assertMatches(distributionList.getDistributionList(), referencedContact);
        this.manager.deleteAction(referencedContact);
        distributionList = this.manager.getAction(distributionList);
        DistListTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListTest.assertEquals((String)"member mail field wrong", (int)0, (int)distributionList.getDistributionList()[0].getEmailfield());
        DistListTest.assertEquals((String)"member email address", (String)referencedContact.getEmail1(), (String)distributionList.getDistributionList()[0].getEmailaddress());
    }

    public void testDeleteReferencedContactAfterUpdate() throws OXException {
        Contact referencedContact = super.generateContact("Test");
        referencedContact.setEmail1("mail@example.com");
        referencedContact = this.manager.newAction(referencedContact);
        Contact distributionList = super.generateContact("List");
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{new DistributionListEntryObject()};
        members[0].setEntryID(referencedContact.getObjectID());
        members[0].setFolderID(referencedContact.getParentFolderID());
        members[0].setDisplayname(referencedContact.getDisplayName());
        members[0].setEmailaddress(referencedContact.getEmail1());
        members[0].setEmailfield(1);
        distributionList.setDistributionList(members);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListTest.assertMatches(distributionList.getDistributionList(), referencedContact);
        referencedContact.setEmail1("mail_edit@example.com");
        referencedContact = this.manager.updateAction(referencedContact);
        distributionList = this.manager.getAction(distributionList);
        DistListTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListTest.assertMatches(distributionList.getDistributionList(), referencedContact);
        this.manager.deleteAction(referencedContact);
        distributionList = this.manager.getAction(distributionList);
        DistListTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListTest.assertEquals((String)"member mail field wrong", (int)0, (int)distributionList.getDistributionList()[0].getEmailfield());
        DistListTest.assertEquals((String)"member email address", (String)referencedContact.getEmail1(), (String)distributionList.getDistributionList()[0].getEmailaddress());
    }

    public void testAddReferencedContactWithoutFolderID() throws OXException {
        Contact referencedContact = super.generateContact("Test");
        referencedContact.setEmail1("mail@example.com");
        referencedContact = this.manager.newAction(referencedContact);
        Contact distributionList = super.generateContact("List");
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{new DistributionListEntryObject()};
        members[0].setEntryID(referencedContact.getObjectID());
        members[0].setDisplayname(referencedContact.getDisplayName());
        members[0].setEmailaddress(referencedContact.getEmail1());
        members[0].setEmailfield(1);
        distributionList.setDistributionList(members);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListTest.assertEquals((String)"referenced object id wrong", (int)referencedContact.getObjectID(), (int)distributionList.getDistributionList()[0].getEntryID());
        DistListTest.assertEquals((String)"referenced folder id wrong", (int)referencedContact.getParentFolderID(), (int)distributionList.getDistributionList()[0].getFolderID());
    }

    private static void assertMatches(DistributionListEntryObject[] members, Contact ... contacts) {
        for (Contact contact : contacts) {
            boolean found = false;
            for (DistributionListEntryObject member : members) {
                if (contact.getObjectID() != member.getEntryID()) continue;
                found = true;
                String referencedMail = null;
                if (1 == member.getEmailfield()) {
                    referencedMail = contact.getEmail1();
                } else if (2 == member.getEmailfield()) {
                    referencedMail = contact.getEmail2();
                } else if (3 == member.getEmailfield()) {
                    referencedMail = contact.getEmail3();
                } else {
                    DistListTest.fail((String)"wrong mailfiled set in member");
                }
                DistListTest.assertEquals((String)"referenced mail wrong", (String)member.getEmailaddress(), (String)referencedMail);
            }
            DistListTest.assertTrue((String)"contact not found in distlist members", (boolean)found);
        }
    }
}

