/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.helper;

import com.openexchange.ajax.appointment.helper.AbstractAssertion;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.test.CalendarTestManager;

public abstract class AbstractNegativeAssertion
extends AbstractAssertion {
    public AbstractNegativeAssertion(CalendarTestManager manager, int folderToWorkIn) {
        this.manager = manager;
        manager.setFailOnError(false);
        this.folder = folderToWorkIn;
    }

    public void check(Changes changes, OXException expectedError) {
        this.check(AbstractNegativeAssertion.generateDefaultAppointment(), changes, expectedError);
    }

    public abstract void check(Appointment var1, Changes var2, OXException var3);

    protected void createAndCheck(Appointment startWith, Changes changes, OXException expectedError) {
        this.approachUsedForTest = "Create directly";
        changes.update((CommonObject)startWith);
        this.create(startWith);
        this.checkForError(expectedError);
    }

    protected void updateAndCheck(Appointment startWith, Changes changes, OXException expectedError) {
        this.approachUsedForTest = "Create and update";
        this.create(startWith);
        this.update(startWith, changes);
        this.checkForError(expectedError);
    }

    private void checkForError(OXException expectedError) {
        this.methodUsedForTest = "Check lastException field";
        AbstractNegativeAssertion.assertTrue((String)(this.state() + " Expecting exception, did not get one"), (boolean)this.manager.hasLastException());
        try {
            OXException lastException = (OXException)((Object)this.manager.getLastException());
            AbstractNegativeAssertion.assertTrue((String)(this.state() + " Expected error: " + (Object)((Object)expectedError) + ", actual error: " + lastException.getErrorCode()), (boolean)expectedError.similarTo(lastException));
        }
        catch (ClassCastException e) {
            this.fail2("Should have an OXException, but could not cast it into one");
        }
    }
}

