/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;

public class Bug16441Test
extends AbstractAJAXSession {
    private Appointment appointment;

    public Bug16441Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.appointment = new Appointment();
        this.appointment.setStartDate(TimeTools.D("16.04.2010 07:00"));
        this.appointment.setEndDate(TimeTools.D("16.04.2010 08:00"));
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setTitle("bug 16441 test");
        this.appointment.setRecurrenceType(3);
        this.appointment.setInterval(1);
        this.appointment.setUntil(TimeTools.D("31.12.2010 00:00"));
        this.appointment.setDayInMonth(1);
        this.appointment.setDays(32);
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
    }

    public void testBug16441() throws Exception {
        AppointmentInsertResponse response = this.getClient().execute(new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone()));
        response.fillAppointment(this.appointment);
        this.getClient().execute(new DeleteRequest(this.appointment.getObjectID(), this.appointment.getParentFolderID(), 5, this.appointment.getLastModified()));
    }

    @Override
    protected void tearDown() throws Exception {
        this.appointment.setLastModified(new Date(Long.MAX_VALUE));
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }
}

