/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.java.Autoboxing;
import java.util.Date;
import java.util.List;

public class UserStory2173Test
extends AbstractAJAXSession {
    private AJAXClient clientA;
    private AJAXClient clientB;
    private FolderObject publicFolder;
    private Appointment appointmentPrivate;
    private Appointment appointmentPublic;

    public UserStory2173Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User3);
        SetRequest setRequest = new SetRequest(Tree.CalendarDefaultStatusPrivate, Autoboxing.I((int)1));
        this.clientB.execute(setRequest);
        setRequest = new SetRequest(Tree.CalendarDefaultStatusPublic, Autoboxing.I((int)1));
        this.clientB.execute(setRequest);
        this.publicFolder = Create.folder(2, "US2173TestFolder", 2, 2, Create.ocl(this.clientA.getValues().getUserId(), false, true, 128, 128, 128, 128), Create.ocl(this.clientB.getValues().getUserId(), false, false, 128, 128, 128, 128));
        CommonInsertResponse folderResponse = this.clientA.execute(new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_OLD, this.publicFolder));
        folderResponse.fillObject((DataObject)this.publicFolder);
        List<Participant> participants = ParticipantTools.createParticipants(this.clientA.getValues().getUserId(), this.clientB.getValues().getUserId());
        this.appointmentPrivate = new Appointment();
        this.appointmentPrivate.setParentFolderID(this.clientA.getValues().getPrivateAppointmentFolder());
        this.appointmentPrivate.setTitle("UserStory2173 Test in private folder");
        this.appointmentPrivate.setStartDate(new Date(TimeTools.getHour(13, this.clientA.getValues().getTimeZone())));
        this.appointmentPrivate.setEndDate(new Date(TimeTools.getHour(14, this.clientA.getValues().getTimeZone())));
        this.appointmentPrivate.setParticipants(participants);
        this.appointmentPrivate.setIgnoreConflicts(true);
        participants = ParticipantTools.createParticipants(this.clientA.getValues().getUserId(), this.clientB.getValues().getUserId());
        this.appointmentPublic = new Appointment();
        this.appointmentPublic.setParentFolderID(this.publicFolder.getObjectID());
        this.appointmentPublic.setTitle("UserStory2173 Test in private folder");
        this.appointmentPublic.setStartDate(new Date(TimeTools.getHour(13, this.clientA.getValues().getTimeZone())));
        this.appointmentPublic.setEndDate(new Date(TimeTools.getHour(14, this.clientA.getValues().getTimeZone())));
        this.appointmentPublic.setParticipants(participants);
        this.appointmentPublic.setIgnoreConflicts(true);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.appointmentPrivate.getObjectID() > 0) {
            this.clientA.execute(new DeleteRequest(this.appointmentPrivate));
        }
        if (this.appointmentPublic.getObjectID() > 0) {
            this.clientA.execute(new DeleteRequest(this.appointmentPublic));
        }
        this.clientA.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_OLD, this.publicFolder.getObjectID(), this.publicFolder.getLastModified()));
        SetRequest setRequest = new SetRequest(Tree.CalendarDefaultStatusPrivate, Autoboxing.I((int)0));
        this.clientB.execute(setRequest);
        setRequest = new SetRequest(Tree.CalendarDefaultStatusPublic, Autoboxing.I((int)0));
        this.clientB.execute(setRequest);
        super.tearDown();
    }

    public void testPrivate() throws Exception {
        AppointmentInsertResponse insertResponse = this.clientA.execute(new InsertRequest(this.appointmentPrivate, this.clientA.getValues().getTimeZone()));
        insertResponse.fillAppointment(this.appointmentPrivate);
        GetRequest getRequest = new GetRequest(this.clientA.getValues().getPrivateAppointmentFolder(), this.appointmentPrivate.getObjectID());
        Appointment loadedAppointment = this.clientA.execute(getRequest).getAppointment(this.clientA.getValues().getTimeZone());
        for (UserParticipant user : loadedAppointment.getUsers()) {
            if (user.getIdentifier() != this.clientB.getValues().getUserId()) continue;
            UserStory2173Test.assertEquals((String)"Wrong confirmation status", (int)1, (int)user.getConfirm());
        }
    }

    public void testPublic() throws Exception {
        AppointmentInsertResponse insertResponse = this.clientA.execute(new InsertRequest(this.appointmentPublic, this.clientA.getValues().getTimeZone()));
        insertResponse.fillAppointment(this.appointmentPublic);
        GetRequest getRequest = new GetRequest(this.publicFolder.getObjectID(), this.appointmentPublic.getObjectID());
        Appointment loadedAppointment = this.clientA.execute(getRequest).getAppointment(this.clientA.getValues().getTimeZone());
        for (UserParticipant user : loadedAppointment.getUsers()) {
            if (user.getIdentifier() != this.clientB.getValues().getUserId()) continue;
            UserStory2173Test.assertEquals((String)"Wrong confirmation status", (int)1, (int)user.getConfirm());
        }
    }
}

