/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.ContentLengthCounter;
import com.sun.mail.mbox.LineCounter;
import com.sun.mail.mbox.MboxFolder;
import com.sun.mail.mbox.NewlineOutputStream;
import com.sun.mail.mbox.SunV3BodyPart;
import com.sun.mail.mbox.SunV3Multipart;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePartDataSource;

public class MboxMessage
extends MimeMessage {
    boolean writable = false;
    Flags origFlags;
    String unix_from;
    InternetAddress unix_from_user;
    Date rcvDate;
    int lineCount = -1;
    private static OutputStream nullOutputStream = new OutputStream(){

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    };

    public MboxMessage(Session session, InputStream is) throws MessagingException, IOException {
        super(session);
        BufferedInputStream bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        bis.mark(1024);
        String line = dis.readLine();
        if (line != null && line.startsWith("From ")) {
            this.unix_from = line;
        } else {
            bis.reset();
        }
        this.parse(bis);
        this.saved = true;
    }

    public MboxMessage(MboxFolder folder, InternetHeaders hdrs, InputStream is, int msgno, String unix_from, boolean writable) throws MessagingException {
        super(folder, hdrs, null, msgno);
        this.setFlagsFromHeaders();
        this.origFlags = this.getFlags();
        this.unix_from = unix_from;
        this.writable = writable;
        this.contentStream = is;
    }

    @Override
    public Address[] getFrom() throws MessagingException {
        InternetAddress ia;
        Address[] ret = super.getFrom();
        if (ret == null && (ia = this.getUnixFrom()) != null) {
            ret = new InternetAddress[]{ia};
        }
        return ret;
    }

    public synchronized InternetAddress getUnixFrom() throws MessagingException {
        int i;
        if (this.unix_from_user == null && this.unix_from != null && (i = this.unix_from.indexOf(32, 5)) > 5) {
            try {
                this.unix_from_user = new InternetAddress(this.unix_from.substring(5, i));
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
        return this.unix_from_user != null ? (InternetAddress)this.unix_from_user.clone() : null;
    }

    @Override
    public Date getReceivedDate() throws MessagingException {
        int i;
        if (this.rcvDate == null && this.unix_from != null && (i = this.unix_from.indexOf(32, 5)) > 5) {
            try {
                this.rcvDate = new Date(this.unix_from.substring(i));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.rcvDate == null ? null : new Date(this.rcvDate.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineCount() throws MessagingException {
        if (this.lineCount < 0 && this.isMimeType("text/plain")) {
            LineCounter lc = null;
            boolean seen = this.isSet(Flags.Flag.SEEN);
            try {
                lc = new LineCounter(nullOutputStream);
                this.getDataHandler().writeTo((OutputStream)lc);
                this.lineCount = lc.getLineCount();
            }
            catch (IOException ex) {
            }
            finally {
                try {
                    if (lc != null) {
                        lc.close();
                    }
                }
                catch (IOException ex) {}
            }
            if (!seen) {
                this.setFlag(Flags.Flag.SEEN, false);
            }
        }
        return this.lineCount;
    }

    @Override
    public void setFlags(Flags newFlags, boolean set) throws MessagingException {
        Flags oldFlags = (Flags)this.flags.clone();
        super.setFlags(newFlags, set);
        if (!this.flags.equals(oldFlags)) {
            MboxMessage.setHeadersFromFlags(this);
            if (this.folder != null) {
                ((MboxFolder)this.folder).notifyMessageChangedListeners(1, this);
            }
        }
    }

    @Override
    public String getContentType() throws MessagingException {
        String ct = super.getContentType();
        if (ct.indexOf(47) < 0) {
            ct = SunV3BodyPart.MimeV3Map.toMime(ct);
        }
        return ct;
    }

    @Override
    protected InputStream getContentStream() throws MessagingException {
        if (this.folder != null) {
            ((MboxFolder)this.folder).checkOpen();
        }
        if (this.isExpunged()) {
            throw new MessageRemovedException("mbox message expunged");
        }
        if (!this.isSet(Flags.Flag.SEEN)) {
            this.setFlag(Flags.Flag.SEEN, true);
        }
        return super.getContentStream();
    }

    @Override
    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            String ct = this.getContentType();
            if (ct.equalsIgnoreCase("multipart/x-sun-attachment")) {
                this.dh = new DataHandler((Object)new SunV3Multipart(new MimePartDataSource(this)), ct);
            } else {
                return super.getDataHandler();
            }
        }
        return this.dh;
    }

    @Override
    protected void setMessageNumber(int msgno) {
        super.setMessageNumber(msgno);
    }

    @Override
    public synchronized boolean isExpunged() {
        return super.isExpunged();
    }

    @Override
    protected synchronized void setExpunged(boolean expunged) {
        super.setExpunged(expunged);
    }

    private synchronized void setFlagsFromHeaders() {
        this.flags = new Flags(Flags.Flag.RECENT);
        try {
            String s = this.getHeader("Status", null);
            if (s != null) {
                if (s.indexOf(82) >= 0) {
                    this.flags.add(Flags.Flag.SEEN);
                }
                if (s.indexOf(79) >= 0) {
                    this.flags.remove(Flags.Flag.RECENT);
                }
            }
            if ((s = this.getHeader("X-Dt-Delete-Time", null)) != null) {
                this.flags.add(Flags.Flag.DELETED);
            }
            if ((s = this.getHeader("X-Status", null)) != null) {
                if (s.indexOf(68) >= 0) {
                    this.flags.add(Flags.Flag.DELETED);
                }
                if (s.indexOf(70) >= 0) {
                    this.flags.add(Flags.Flag.FLAGGED);
                }
                if (s.indexOf(65) >= 0) {
                    this.flags.add(Flags.Flag.ANSWERED);
                }
                if (s.indexOf(84) >= 0) {
                    this.flags.add(Flags.Flag.DRAFT);
                }
            }
            if ((s = this.getHeader("X-Keywords", null)) != null) {
                StringTokenizer st = new StringTokenizer(s);
                while (st.hasMoreTokens()) {
                    this.flags.add(st.nextToken());
                }
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    static void setHeadersFromFlags(MimeMessage msg) {
        try {
            Flags flags = msg.getFlags();
            StringBuffer status = new StringBuffer();
            if (flags.contains(Flags.Flag.SEEN)) {
                status.append('R');
            }
            if (!flags.contains(Flags.Flag.RECENT)) {
                status.append('O');
            }
            if (status.length() > 0) {
                msg.setHeader("Status", status.toString());
            } else {
                msg.removeHeader("Status");
            }
            boolean sims = false;
            String s = msg.getHeader("X-Status", null);
            sims = s != null && s.length() == 4 && s.indexOf(36) >= 0;
            status.setLength(0);
            if (flags.contains(Flags.Flag.DELETED)) {
                status.append('D');
            } else if (sims) {
                status.append('$');
            }
            if (flags.contains(Flags.Flag.FLAGGED)) {
                status.append('F');
            } else if (sims) {
                status.append('$');
            }
            if (flags.contains(Flags.Flag.ANSWERED)) {
                status.append('A');
            } else if (sims) {
                status.append('$');
            }
            if (flags.contains(Flags.Flag.DRAFT)) {
                status.append('T');
            } else if (sims) {
                status.append('$');
            }
            if (status.length() > 0) {
                msg.setHeader("X-Status", status.toString());
            } else {
                msg.removeHeader("X-Status");
            }
            String[] userFlags = flags.getUserFlags();
            if (userFlags.length > 0) {
                status.setLength(0);
                for (int i = 0; i < userFlags.length; ++i) {
                    status.append(userFlags[i]).append(' ');
                }
                status.setLength(status.length() - 1);
                msg.setHeader("X-Keywords", status.toString());
            }
            if (flags.contains(Flags.Flag.DELETED) && (s = msg.getHeader("X-Dt-Delete-Time", null)) == null) {
                msg.setHeader("X-Dt-Delete-Time", "1");
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    @Override
    protected void updateHeaders() throws MessagingException {
        super.updateHeaders();
        MboxMessage.setHeadersFromFlags(this);
    }

    @Override
    public void saveChanges() throws MessagingException {
        if (this.folder != null) {
            ((MboxFolder)this.folder).checkOpen();
        }
        if (this.isExpunged()) {
            throw new MessageRemovedException("mbox message expunged");
        }
        if (!this.writable) {
            throw new MessagingException("Message is read-only");
        }
        super.saveChanges();
        try {
            ContentLengthCounter cos = new ContentLengthCounter();
            NewlineOutputStream os = new NewlineOutputStream(cos);
            super.writeTo(os);
            ((OutputStream)os).flush();
            this.setHeader("Content-Length", String.valueOf(cos.getSize()));
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException("unexpected exception " + e);
        }
    }

    boolean isModified() {
        return this.modified;
    }

    public void writeToFile(OutputStream os) throws IOException {
        try {
            if (this.getHeader("Content-Length") == null) {
                ContentLengthCounter cos = new ContentLengthCounter();
                NewlineOutputStream oos = new NewlineOutputStream(cos);
                super.writeTo(oos, null);
                ((OutputStream)oos).flush();
                this.setHeader("Content-Length", String.valueOf(cos.getSize()));
            }
            os = new NewlineOutputStream(os);
            PrintStream pos = new PrintStream(os, false, "iso-8859-1");
            pos.println(this.unix_from);
            super.writeTo(pos, null);
            pos.println();
            pos.flush();
        }
        catch (MessagingException e) {
            throw new IOException("unexpected exception " + e);
        }
    }

    @Override
    public void writeTo(OutputStream os, String[] ignoreList) throws IOException, MessagingException {
        if (!this.isSet(Flags.Flag.SEEN)) {
            this.setFlag(Flags.Flag.SEEN, true);
        }
        super.writeTo(os, ignoreList);
    }

    @Override
    public String[] getHeader(String name) throws MessagingException {
        if (this.folder != null) {
            ((MboxFolder)this.folder).checkOpen();
        }
        if (this.isExpunged()) {
            throw new MessageRemovedException("mbox message expunged");
        }
        return super.getHeader(name);
    }

    @Override
    public String getHeader(String name, String delimiter) throws MessagingException {
        if (this.folder != null) {
            ((MboxFolder)this.folder).checkOpen();
        }
        if (this.isExpunged()) {
            throw new MessageRemovedException("mbox message expunged");
        }
        return super.getHeader(name, delimiter);
    }
}

