/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.config.ConfigurationService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.webdav.action.WebdavAction;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.util.PropertySwitch;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdom2.Namespace;

public class Protocol {
    public static final int SC_LOCKED = 423;
    public static final int SC_MULTISTATUS = 207;
    public static final Namespace DAV_NS = Namespace.getNamespace((String)"D", (String)"DAV:");
    public static final String DEFAULT_NAMESPACE = "DAV:";
    public static final String COLLECTION = "<D:collection />";
    public static final int CREATIONDATE = 1;
    public static final int DISPLAYNAME = 2;
    public static final int GETCONTENTLANGUAGE = 3;
    public static final int GETCONTENTLENGTH = 4;
    public static final int GETCONTENTTYPE = 5;
    public static final int GETETAG = 6;
    public static final int GETLASTMODIFIED = 7;
    public static final int RESOURCETYPE = 8;
    public static final int LOCKDISCOVERY = 9;
    public static final int SUPPORTEDLOCK = 10;
    public static final int SOURCE = 11;
    public static final Property CREATIONDATE_LITERAL = new Property(1, "DAV:", "creationdate");
    public static final Property DISPLAYNAME_LITERAL = new Property(2, "DAV:", "displayname");
    public static final Property GETCONTENTLANGUAGE_LITERAL = new Property(3, "DAV:", "getcontentlanguage");
    public static final Property GETCONTENTLENGTH_LITERAL = new Property(4, "DAV:", "getcontentlength");
    public static final Property GETCONTENTTYPE_LITERAL = new Property(5, "DAV:", "getcontenttype");
    public static final Property GETETAG_LITERAL = new Property(6, "DAV:", "getetag");
    public static final Property GETLASTMODIFIED_LITERAL = new Property(7, "DAV:", "getlastmodified");
    public static final Property RESOURCETYPE_LITERAL = new Property(8, "DAV:", "resourcetype");
    public static final Property LOCKDISCOVERY_LITERAL = new Property(9, "DAV:", "lockdiscovery");
    public static final Property SUPPORTEDLOCK_LITERAL = new Property(10, "DAV:", "supportedlock");
    public static final Property SOURCE_LITERAL = new Property(11, "DAV:", "source");
    public Property[] VALUES_ARRAY = new Property[]{CREATIONDATE_LITERAL, DISPLAYNAME_LITERAL, GETCONTENTLANGUAGE_LITERAL, GETCONTENTLENGTH_LITERAL, GETCONTENTTYPE_LITERAL, GETETAG_LITERAL, GETLASTMODIFIED_LITERAL, RESOURCETYPE_LITERAL, LOCKDISCOVERY_LITERAL, SUPPORTEDLOCK_LITERAL, SOURCE_LITERAL};
    public List<Property> VALUES = Collections.unmodifiableList(Arrays.asList(this.VALUES_ARRAY));

    public List<Property> getKnownProperties() {
        return this.VALUES;
    }

    public Property get(int i) {
        switch (i) {
            case 1: {
                return CREATIONDATE_LITERAL;
            }
            case 2: {
                return DISPLAYNAME_LITERAL;
            }
            case 3: {
                return GETCONTENTLANGUAGE_LITERAL;
            }
            case 4: {
                return GETCONTENTLENGTH_LITERAL;
            }
            case 5: {
                return GETCONTENTTYPE_LITERAL;
            }
            case 6: {
                return GETETAG_LITERAL;
            }
            case 7: {
                return GETLASTMODIFIED_LITERAL;
            }
            case 8: {
                return RESOURCETYPE_LITERAL;
            }
            case 9: {
                return LOCKDISCOVERY_LITERAL;
            }
            case 10: {
                return SUPPORTEDLOCK_LITERAL;
            }
            case 11: {
                return SOURCE_LITERAL;
            }
        }
        return null;
    }

    public Property get(String namespace, String name) {
        if (namespace == null) {
            namespace = DEFAULT_NAMESPACE;
        }
        List<Property> known = this.getKnownProperties();
        for (Property prop : known) {
            if (!prop.getNamespace().equals(namespace) || !prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public boolean isProtected(String namespaceURI, String name) {
        Property p = this.get(namespaceURI, name);
        if (p == null) {
            return false;
        }
        switch (p.getId()) {
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public List<Namespace> getAdditionalNamespaces() {
        return Collections.emptyList();
    }

    public int getRecursiveMarshallingLimit() {
        int defaultValue = 250000;
        ConfigurationService configService = ServerServiceRegistry.getServize(ConfigurationService.class);
        return null != configService ? configService.getIntProperty("com.openexchange.webdav.recursiveMarshallingLimit", defaultValue) : defaultValue;
    }

    public WebdavAction getReportAction(String ns, String name) {
        return null;
    }

    public static final class Property {
        private final int id;
        private final String name;
        private final String namespace;

        private Property(int id, String namespace, String name) {
            this.id = id;
            this.name = name;
            this.namespace = namespace;
        }

        public Object doSwitch(PropertySwitch sw) throws WebdavProtocolException {
            switch (this.id) {
                case 1: {
                    return sw.creationDate();
                }
                case 2: {
                    return sw.displayName();
                }
                case 3: {
                    return sw.contentLanguage();
                }
                case 4: {
                    return sw.contentLength();
                }
                case 5: {
                    return sw.contentType();
                }
                case 6: {
                    return sw.etag();
                }
                case 7: {
                    return sw.lastModified();
                }
                case 8: {
                    return sw.resourceType();
                }
                case 9: {
                    return sw.lockDiscovery();
                }
                case 10: {
                    return sw.supportedLock();
                }
                case 11: {
                    return sw.source();
                }
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public WebdavProperty getWebdavProperty() {
            WebdavProperty p = new WebdavProperty();
            p.setNamespace(this.namespace);
            p.setName(this.name);
            switch (this.id) {
                case 1: 
                case 7: {
                    p.setDate(true);
                    break;
                }
                case 8: {
                    p.setXML(true);
                }
            }
            return p;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (o instanceof Property) {
                Property prop = (Property)o;
                return prop.getId() == this.id;
            }
            return false;
        }
    }

    public static enum WEBDAV_METHOD {
        GET,
        PUT,
        MKCOL,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE,
        PROPPATCH,
        PROPFIND,
        MOVE,
        COPY,
        LOCK,
        UNLOCK,
        REPORT,
        ACL,
        MKCALENDAR;

    }
}

