/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.java.Streams;
import com.openexchange.tools.io.IOTools;
import com.openexchange.webdav.action.WebdavHeadAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdavGetAction
extends WebdavHeadAction {
    private static final Logger LOG = LoggerFactory.getLogger(WebdavGetAction.class);
    private static final Pattern RANGE_PATTERN = Pattern.compile("bytes=(\\S+)");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        InputStream in;
        block14: {
            WebdavResource resource = req.getResource();
            res.setContentType(resource.getContentType());
            if (!resource.exists()) {
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 404);
            }
            List<ByteRange> ranges = this.getRanges(req, res);
            long size = 0L;
            long offset = 0L;
            for (ByteRange range : ranges) {
                long l = offset = range.startOffset < offset ? offset : range.startOffset;
                if (offset > range.endOffset) continue;
                size += range.endOffset - offset;
                ++size;
            }
            this.head(res, resource, size);
            BufferedOutputStream out = null;
            in = null;
            try {
                out = new BufferedOutputStream(res.getOutputStream());
                in = resource.getBody();
                byte[] chunk = new byte[200];
                offset = 0L;
                for (ByteRange range : ranges) {
                    if (offset < range.startOffset) {
                        IOTools.reallyBloodySkip(in, range.startOffset - offset);
                        offset = (int)range.startOffset;
                    }
                    if (offset > range.endOffset) continue;
                    int read = 0;
                    int need = (int)Math.min((long)chunk.length, range.endOffset - offset + 1L);
                    while (need > 0 && (read = in.read(chunk, 0, need)) > 0) {
                        out.write(chunk, 0, read);
                        need = (int)Math.min((long)chunk.length, range.endOffset - (offset += (long)read) + 1L);
                    }
                }
                if (out == null) break block14;
            }
            catch (IOException e) {
                try {
                    throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 503, e, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.flush();
                        }
                        catch (IOException e2) {
                            LOG.debug("", (Throwable)e2);
                        }
                    }
                    Streams.close(in);
                    throw throwable;
                }
            }
            try {
                out.flush();
            }
            catch (IOException e) {
                LOG.debug("", (Throwable)e);
            }
        }
        Streams.close((Closeable)in);
    }

    private List<ByteRange> getRanges(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        String range;
        String byteRanges = req.getHeader("Bytes");
        if (req.getResource().isCollection()) {
            return new ArrayList<ByteRange>();
        }
        long length = req.getResource().getLength();
        ArrayList<ByteRange> retVal = new ArrayList<ByteRange>();
        if (byteRanges != null) {
            for (String range2 : byteRanges.split("\\s*,\\s*")) {
                ByteRange ro = this.parseRange(range2 = range2.trim(), length, req.getUrl());
                if (ro == null) continue;
                retVal.add(ro);
            }
        }
        if ((range = req.getHeader("Range")) != null) {
            Matcher m = RANGE_PATTERN.matcher(range);
            while (m.find()) {
                String br = m.group(1);
                for (String r : br.split("\\s*,\\s*")) {
                    range = range.trim();
                    ByteRange ro = this.parseRange(r, length, req.getUrl());
                    if (ro == null) continue;
                    retVal.add(ro);
                }
            }
        }
        if (retVal.size() == 0) {
            res.setStatus(200);
            return Arrays.asList(new ByteRange(0L, req.getResource().getLength() - 1L));
        }
        res.setStatus(206);
        Collections.sort(retVal);
        return retVal;
    }

    private ByteRange parseRange(String range, long length, WebdavPath url) throws WebdavProtocolException {
        if (range.charAt(0) == '-') {
            long reqLength = Long.parseLong(range.substring(1));
            if (reqLength > length) {
                return new ByteRange(0L, length - 1L);
            }
            ByteRange br = new ByteRange(length - reqLength, length - 1L);
            return br;
        }
        if (range.charAt(range.length() - 1) == '-') {
            long startOffset = Long.parseLong(range.substring(0, range.length() - 1));
            ByteRange br = new ByteRange(startOffset, length - 1L);
            return br;
        }
        String[] startAndEnd = range.split("\\s*-\\s*");
        long startOffset = Long.parseLong(startAndEnd[0]);
        long endOffset = Long.parseLong(startAndEnd[1]);
        if (startOffset > length) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(url, 416);
        }
        ByteRange br = new ByteRange(startOffset, endOffset);
        return br;
    }

    private static final class ByteRange
    implements Comparable<ByteRange> {
        public final long startOffset;
        public final long endOffset;

        public ByteRange(long start, long end) {
            this.startOffset = start;
            this.endOffset = end;
        }

        @Override
        public int compareTo(ByteRange arg0) {
            ByteRange other = arg0;
            return Long.valueOf(this.startOffset).compareTo(other.startOffset);
        }

        public String toString() {
            return String.format("%d-%d", this.startOffset, this.endOffset);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.startOffset ^ this.startOffset >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ByteRange)) {
                return false;
            }
            ByteRange other = (ByteRange)obj;
            return this.startOffset == other.startOffset;
        }
    }
}

