/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.ratelimit;

import com.openexchange.tools.servlet.ratelimit.KeyPartProvider;
import com.openexchange.tools.servlet.ratelimit.RateLimiter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public final class Key {
    private static final String USER_AGENT = "User-Agent";
    private final int remotePort;
    private final String remoteAddr;
    private final String userAgent;
    private final List<String> parts;
    private final int hash;

    private static int hashCode(List<String> l) {
        if (l == null) {
            return 0;
        }
        int result = 1;
        for (String str : l) {
            result = 31 * result + (str == null ? 0 : str.hashCode());
        }
        return result;
    }

    public Key(HttpServletRequest servletRequest) {
        this(servletRequest, servletRequest.getHeader(USER_AGENT));
    }

    public Key(HttpServletRequest servletRequest, String userAgent) {
        ArrayList<String> parts;
        this.remotePort = RateLimiter.considerRemotePort() ? servletRequest.getRemotePort() : 0;
        this.remoteAddr = servletRequest.getRemoteAddr();
        this.userAgent = userAgent;
        List<KeyPartProvider> keyPartProviders = RateLimiter.keyPartProviders();
        if (null == keyPartProviders || keyPartProviders.isEmpty()) {
            parts = null;
        } else {
            parts = new ArrayList<String>(keyPartProviders.size());
            for (KeyPartProvider keyPartProvider : keyPartProviders) {
                parts.add(keyPartProvider.getValue(servletRequest));
            }
        }
        this.parts = parts;
        int prime = 31;
        int result = 1;
        result = prime * result + (this.remoteAddr == null ? 0 : this.remoteAddr.hashCode());
        result = prime * result + this.remotePort;
        result = prime * result + (userAgent == null ? 0 : userAgent.hashCode());
        this.hash = result = prime * result + (parts == null ? 0 : Key.hashCode(parts));
    }

    public Key(HttpServletRequest servletRequest, String userAgent, String ... parts) {
        ArrayList<String> l;
        this.remotePort = RateLimiter.considerRemotePort() ? servletRequest.getRemotePort() : 0;
        this.remoteAddr = servletRequest.getRemoteAddr();
        this.userAgent = userAgent;
        if (null == parts || 0 == parts.length) {
            l = null;
        } else {
            int length = parts.length;
            l = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                String part = parts[i];
                if (null == part) continue;
                l.add(part);
            }
        }
        this.parts = l;
        int prime = 31;
        int result = 1;
        result = prime * result + (this.remoteAddr == null ? 0 : this.remoteAddr.hashCode());
        result = prime * result + this.remotePort;
        result = prime * result + (userAgent == null ? 0 : userAgent.hashCode());
        this.hash = result = prime * result + (l == null ? 0 : Key.hashCode(l));
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Key other = (Key)obj;
        if (this.remotePort != other.remotePort) {
            return false;
        }
        if (this.remoteAddr == null ? other.remoteAddr != null : !this.remoteAddr.equals(other.remoteAddr)) {
            return false;
        }
        if (this.userAgent == null ? other.userAgent != null : !this.userAgent.equals(other.userAgent)) {
            return false;
        }
        return !(this.parts == null ? other.parts != null : !((Object)this.parts).equals(other.parts));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("Key [");
        if (this.remotePort > 0) {
            builder.append("remotePort=").append(this.remotePort).append(", ");
        }
        if (this.remoteAddr != null) {
            builder.append("remoteAddr=").append(this.remoteAddr).append(", ");
        }
        if (this.userAgent != null) {
            builder.append("userAgent=").append(this.userAgent).append(", ");
        }
        if (this.parts != null) {
            builder.append("parts=").append(this.parts).append(", ");
        }
        builder.append("hash=").append(this.hash).append("]");
        return builder.toString();
    }
}

