/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.config.ConfigurationService;
import com.openexchange.contact.ContactService;
import com.openexchange.database.IncorrectStringSQLException;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.StaticDBPoolProvider;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionConstants;
import com.openexchange.folder.FolderDeleteListenerService;
import com.openexchange.folder.internal.FolderDeleteListenerRegistry;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.facade.impl.EventFiringInfostoreFacadeImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.modules.Module;
import com.openexchange.groupware.tasks.Tasks;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.exceptions.SimpleIncorrectStringAttribute;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.oxfolder.treeconsistency.CheckPermissionOnInsert;
import com.openexchange.tools.oxfolder.treeconsistency.CheckPermissionOnRemove;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OXFolderManagerImpl
extends OXFolderManager
implements OXExceptionConstants {
    private static final Logger LOG = LoggerFactory.getLogger(OXFolderManagerImpl.class);
    static final int OPTION_NONE = 0;
    static final int OPTION_DENY_MODULE_UPDATE = 1;
    private static final int OPTION_OVERRIDE_CREATED_BY = 2;
    private static final String TABLE_OXFOLDER_TREE = "oxfolder_tree";
    private final Connection readCon;
    private final Connection writeCon;
    private final Context ctx;
    private final UserPermissionBits userPerms;
    private final User user;
    private final Session session;
    private final List<OXException> warnings;
    private OXFolderAccess oxfolderAccess;
    private AppointmentSQLInterface cSql;
    private final int[] SYSTEM_PUBLIC_FOLDERS = new int[]{2, 15};
    private static final int SPECIAL_CONTACT_COLLECT_FOLDER = 0;
    private static Map<String, Integer> fieldMapping;

    public AppointmentSQLInterface getCSql() {
        return this.cSql;
    }

    public void setCSql(AppointmentSQLInterface sql) {
        this.cSql = sql;
    }

    OXFolderManagerImpl(Session session) throws OXException {
        this(session, null, null);
    }

    OXFolderManagerImpl(Session session, OXFolderAccess oxfolderAccess) throws OXException {
        this(session, oxfolderAccess, null, null);
    }

    OXFolderManagerImpl(Session session, Connection readCon, Connection writeCon) throws OXException {
        this(session, null, readCon, writeCon);
    }

    OXFolderManagerImpl(Session session, OXFolderAccess oxfolderAccess, Connection readCon, Connection writeCon) throws OXException {
        this.session = session;
        if (session instanceof ServerSession) {
            ServerSession serverSession = (ServerSession)session;
            this.ctx = serverSession.getContext();
            this.userPerms = serverSession.getUserPermissionBits();
            this.user = serverSession.getUser();
        } else {
            this.ctx = ContextStorage.getStorageContext(session.getContextId());
            this.userPerms = UserPermissionBitsStorage.getInstance().getUserPermissionBits(session.getUserId(), this.ctx);
            this.user = UserStorage.getInstance().getUser(session.getUserId(), this.ctx);
        }
        this.readCon = readCon;
        this.writeCon = writeCon;
        this.oxfolderAccess = oxfolderAccess;
        AppointmentSqlFactoryService factory = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class);
        this.cSql = factory != null ? factory.createAppointmentSql(session) : null;
        this.warnings = new LinkedList<OXException>();
    }

    @Override
    public List<OXException> getWarnings() {
        return this.warnings;
    }

    private OXFolderAccess getOXFolderAccess() {
        if (this.oxfolderAccess != null) {
            return this.oxfolderAccess;
        }
        this.oxfolderAccess = new OXFolderAccess(this.writeCon, this.ctx);
        return this.oxfolderAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderObject createFolder(FolderObject folderObj, boolean checkPermissions, long createTime) throws OXException {
        TIntSet diff;
        if (!folderObj.containsFolderName() || folderObj.getFolderName() == null || folderObj.getFolderName().length() == 0) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("title", "", this.ctx.getContextId());
        }
        if (!folderObj.containsParentFolderID()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("folder_id", "", this.ctx.getContextId());
        }
        if (!folderObj.containsModule()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("module", "", this.ctx.getContextId());
        }
        if (!folderObj.containsType()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("type", "", this.ctx.getContextId());
        }
        if (9 == folderObj.getParentFolderID()) {
            folderObj.setType(2);
        }
        if (folderObj.getPermissions() == null || folderObj.getPermissions().size() == 0) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("permissions", "", this.ctx.getContextId());
        }
        OXFolderUtility.checkFolderStringData(folderObj);
        FolderObject parentFolder = this.getOXFolderAccess().getFolderObject(folderObj.getParentFolderID());
        if (checkPermissions) {
            try {
                EffectivePermission p = parentFolder.getEffectiveUserPermission(this.user.getId(), this.userPerms, this.readCon);
                if (!p.canCreateSubfolders()) {
                    OXException fe = OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(parentFolder), this.ctx.getContextId());
                    if (p.getUnderlyingPermission().canCreateSubfolders()) {
                        fe.setCategory(CATEGORY_PERMISSION_DENIED);
                    }
                    throw fe;
                }
                if (!this.userPerms.hasModuleAccess(folderObj.getModule())) {
                    throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(CATEGORY_PERMISSION_DENIED, OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
                }
                if (parentFolder.getType() == 2 && !this.userPerms.hasFullPublicFolderAccess() && folderObj.getModule() != 8) {
                    throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(parentFolder), this.ctx.getContextId());
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (!OXFolderUtility.checkFolderTypeAgainstParentType(parentFolder, folderObj.getType())) {
            throw OXFolderExceptionCode.INVALID_TYPE.create(OXFolderUtility.getFolderName(parentFolder), OXFolderUtility.folderType2String(folderObj.getType()), this.ctx.getContextId());
        }
        if (parentFolder.isShared(this.user.getId())) {
            OXFolderUtility.checkSharedSubfolderOwnerPermission(parentFolder, folderObj, this.user.getId(), this.ctx);
            folderObj.setCreatedBy(parentFolder.getCreatedBy());
        }
        if (!OXFolderManagerImpl.isKnownModule(folderObj.getModule())) {
            throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
        }
        if (!OXFolderUtility.checkFolderModuleAgainstParentModule(parentFolder.getObjectID(), parentFolder.getModule(), folderObj.getModule(), this.ctx.getContextId())) {
            throw OXFolderExceptionCode.INVALID_MODULE.create(OXFolderUtility.getFolderName(parentFolder), OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
        }
        OXFolderUtility.checkPermissionsAgainstSessionUserConfig(folderObj, this.userPerms, this.ctx);
        OXFolderUtility.checkFolderPermissions(folderObj, this.user.getId(), this.ctx, this.warnings);
        OXFolderUtility.checkPermissionsAgainstUserConfigs(folderObj, this.ctx);
        if (2 == folderObj.getType()) {
            new CheckPermissionOnInsert(this.session, this.writeCon, this.ctx).checkParentPermissions(parentFolder.getObjectID(), folderObj.getNonSystemPermissionsAsArray(), createTime);
        }
        try {
            boolean throwException;
            String folderName;
            int parentFolderID;
            block55: {
                block54: {
                    parentFolderID = folderObj.getParentFolderID();
                    folderName = folderObj.getFolderName();
                    throwException = false;
                    if (parentFolderID == 1) break block54;
                    if (OXFolderSQL.lookUpFolder(parentFolderID, folderName, folderObj.getModule(), this.readCon, this.ctx) == -1) break block55;
                    throwException = true;
                    break block55;
                }
                TIntList folders2 = OXFolderSQL.lookUpFolders(parentFolderID, folderName, folderObj.getModule(), this.readCon, this.ctx);
                for (int fuid : folders2.toArray()) {
                    FolderObject toCheck = this.getOXFolderAccess().getFolderObject(fuid);
                    if (toCheck.getCreatedBy() != (folderObj.containsCreatedBy() ? folderObj.getCreatedBy() : this.user.getId())) continue;
                    throwException = true;
                    break;
                }
            }
            if (throwException) {
                throw OXFolderExceptionCode.NO_DUPLICATE_FOLDER.create(OXFolderUtility.getFolderName(parentFolder), this.ctx.getContextId(), folderName);
            }
            OXFolderUtility.checki18nString(parentFolderID, folderName, this.user.getLocale(), this.ctx);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (folderObj.getType() == 1 && folderObj.getPermissions().size() > 1 && !(diff = OXFolderUtility.getShareUsers(null, folderObj.getPermissions(), this.user.getId(), this.ctx)).isEmpty()) {
            FolderObject[] allSharedFolders;
            try {
                TIntCollection fuids = OXFolderSQL.getSharedFoldersOf(this.user.getId(), this.readCon, this.ctx);
                int length = fuids.size();
                allSharedFolders = new FolderObject[length];
                TIntIterator iter = fuids.iterator();
                for (int i = 0; i < length; ++i) {
                    allSharedFolders[i] = this.getOXFolderAccess().getFolderObject(iter.next());
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
            }
            catch (IncorrectStringSQLException e) {
                throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            OXFolderUtility.checkSimilarNamedSharedFolder(diff, allSharedFolders, folderObj.getFolderName(), this.ctx);
        }
        OXFolderUtility.checkForDuplicateNonSystemPermissions(folderObj, this.ctx);
        int fuid = -1;
        try {
            fuid = OXFolderSQL.getNextSerial(this.ctx, this.writeCon);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (fuid < 20) {
            throw OXFolderExceptionCode.INVALID_SEQUENCE_ID.create(fuid, 20, this.ctx.getContextId());
        }
        boolean created = false;
        try {
            OXFolderSQL.insertFolderSQL(fuid, this.user.getId(), folderObj, createTime, this.ctx, this.writeCon);
            created = true;
            folderObj.setObjectID(fuid);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
        }
        catch (IncorrectStringSQLException e) {
            throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            if (!created) {
                FolderCacheManager manager = FolderCacheManager.getInstance();
                manager.removeFolderObject(parentFolder.getObjectID(), this.ctx);
            }
        }
        Date creatingDate = new Date(createTime);
        folderObj.setCreationDate(creatingDate);
        if (!folderObj.containsCreatedBy()) {
            folderObj.setCreatedBy(this.user.getId());
        }
        folderObj.setLastModified(creatingDate);
        folderObj.setModifiedBy(this.user.getId());
        folderObj.setSubfolderFlag(false);
        folderObj.setDefaultFolder(false);
        parentFolder.setSubfolderFlag(true);
        parentFolder.setLastModified(creatingDate);
        ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
        Connection wc = this.writeCon;
        boolean create = wc == null;
        try {
            if (create) {
                wc = DBPool.pickupWriteable(this.ctx);
            }
            if (FolderCacheManager.isInitialized()) {
                FolderCacheManager manager = FolderCacheManager.getInstance();
                manager.removeFolderObject(parentFolder.getObjectID(), this.ctx);
                manager.loadFolderObject(parentFolder.getObjectID(), this.ctx, wc);
                folderObj.fill(manager.getFolderObject(fuid, false, this.ctx, wc));
            } else {
                folderObj.fill(FolderObject.loadFolderObjectFromDB(fuid, this.ctx, wc));
            }
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            try {
                if (8 == folderObj.getModule()) {
                    new EventClient(this.session).create(folderObj, parentFolder, this.getFolderPath(folderObj, parentFolder, wc));
                } else {
                    new EventClient(this.session).create(folderObj, parentFolder);
                }
            }
            catch (OXException e) {
                LOG.warn("Create event could not be enqueued", (Throwable)e);
            }
            FolderObject folderObject = folderObj;
            return folderObject;
        }
        finally {
            if (create && wc != null) {
                DBPool.closeWriterAfterReading(this.ctx, wc);
                wc = null;
            }
        }
    }

    @Override
    public FolderObject updateFolder(FolderObject fo, boolean checkPermissions, boolean handDown, long lastModified) throws OXException {
        return this.updateFolder(fo, checkPermissions, handDown, lastModified, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FolderObject updateFolder(FolderObject fo, boolean checkPermissions, boolean handDown, long lastModified, int options) throws OXException {
        int newParentFolderID;
        if (checkPermissions) {
            if (fo.containsType() && fo.getType() == 2 && fo.getModule() != 8 && !this.userPerms.hasFullPublicFolderAccess()) {
                throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(OXFolderUtility.getUserName(this.session, this.user), OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
            }
            EffectivePermission perm = this.getOXFolderAccess().getFolderPermission(fo.getObjectID(), this.user.getId(), this.userPerms);
            if (!perm.isFolderVisible() || !perm.getUnderlyingPermission().isFolderVisible()) {
                throw OXFolderExceptionCode.NOT_VISIBLE.create(fo.getObjectID(), OXFolderUtility.getUserName(this.session, this.user), this.ctx.getContextId());
            }
            if (!perm.isFolderAdmin() || !perm.getUnderlyingPermission().isFolderAdmin()) {
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(this.session, this.user), OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
            }
            if (fo.getObjectID() == OXFolderManagerImpl.getPublishedMailAttachmentsFolder(this.session)) {
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(this.session, this.user), OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
            }
        }
        boolean performMove = fo.containsParentFolderID();
        FolderObject originalFolder = this.getFolderFromMaster(fo.getObjectID());
        int oldParentId = originalFolder.getParentFolderID();
        FolderObject storageObject = originalFolder.clone();
        if (fo.containsPermissions() || fo.containsModule() || fo.containsMeta()) {
            newParentFolderID = fo.getParentFolderID();
            if (performMove && newParentFolderID > 0 && newParentFolderID != storageObject.getParentFolderID()) {
                this.move(fo.getObjectID(), newParentFolderID, fo.getCreatedBy(), fo.getFolderName(), storageObject, lastModified);
                storageObject = this.getFolderFromMaster(fo.getObjectID());
            }
            this.update(fo, options, storageObject, lastModified, handDown);
        } else if (fo.containsFolderName()) {
            newParentFolderID = fo.getParentFolderID();
            if (performMove && newParentFolderID > 0 && newParentFolderID != storageObject.getParentFolderID()) {
                this.move(fo.getObjectID(), newParentFolderID, fo.getCreatedBy(), fo.getFolderName(), storageObject, lastModified);
            } else {
                this.rename(fo, storageObject, lastModified);
            }
        } else if (performMove) {
            this.move(fo.getObjectID(), fo.getParentFolderID(), fo.getCreatedBy(), null, storageObject, lastModified);
        }
        ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
        Connection wc = this.writeCon;
        boolean create = wc == null;
        try {
            if (create) {
                wc = DBPool.pickupWriteable(this.ctx);
            }
            if (FolderCacheManager.isEnabled()) {
                FolderCacheManager cacheManager = FolderCacheManager.getInstance();
                cacheManager.removeFolderObject(fo.getObjectID(), this.ctx);
                fo.fill(cacheManager.getFolderObject(fo.getObjectID(), false, this.ctx, wc));
                int parentFolderID = fo.getParentFolderID();
                if (parentFolderID > 0) {
                    cacheManager.removeFolderObject(parentFolderID, this.ctx);
                    cacheManager.loadFolderObject(parentFolderID, this.ctx, wc);
                }
                if (0 < oldParentId && oldParentId != parentFolderID) {
                    cacheManager.removeFolderObject(oldParentId, this.ctx);
                    cacheManager.loadFolderObject(oldParentId, this.ctx, wc);
                }
            } else {
                fo.fill(FolderObject.loadFolderObjectFromDB(fo.getObjectID(), this.ctx, wc));
            }
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            if (5 != fo.getModule()) {
                try {
                    FolderObject newParentFolder = FolderObject.loadFolderObjectFromDB(fo.getParentFolderID(), this.ctx, wc, true, false);
                    if (8 == fo.getModule()) {
                        new EventClient(this.session).modify(originalFolder, fo, newParentFolder, this.getFolderPath(fo, newParentFolder, wc));
                    } else {
                        new EventClient(this.session).modify(originalFolder, fo, newParentFolder);
                    }
                }
                catch (OXException e) {
                    LOG.warn("Update event could not be enqueued", (Throwable)e);
                }
            }
            FolderObject folderObject = fo;
            return folderObject;
        }
        finally {
            if (create && wc != null) {
                DBPool.closeWriterAfterReading(this.ctx, wc);
                wc = null;
            }
        }
    }

    protected void update(FolderObject fo, int options, FolderObject storageObj, long lastModified, boolean handDown) throws OXException {
        TIntSet diff;
        if (fo.getObjectID() <= 0) {
            throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(OXFolderUtility.getFolderName(fo));
        }
        boolean containsPermissions = fo.containsPermissions();
        if (fo.getPermissions() == null || fo.getPermissions().isEmpty()) {
            if (containsPermissions) {
                throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("permissions", OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
            }
            fo.setPermissionsAsArray(storageObj.getPermissionsAsArray());
        }
        if (fo.containsParentFolderID() && fo.getParentFolderID() > 0 && storageObj.getParentFolderID() != fo.getParentFolderID()) {
            throw OXFolderExceptionCode.NO_MOVE_THROUGH_UPDATE.create(OXFolderUtility.getFolderName(fo));
        }
        if (fo.containsFolderName()) {
            if (fo.getFolderName() == null || fo.getFolderName().trim().length() == 0) {
                throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("title", OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
            }
            if (storageObj.isDefaultFolder() && !fo.getFolderName().equals(storageObj.getFolderName())) {
                throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_RENAME.create(OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
            }
        }
        if (fo.containsModule() && fo.getModule() != storageObj.getModule() && 5 != storageObj.getModule()) {
            if (!OXFolderManagerImpl.isKnownModule(fo.getModule())) {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(fo.getModule()), this.ctx.getContextId());
            }
            if (storageObj.isDefaultFolder()) {
                throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_MODULE_UPDATE.create();
            }
            if (!this.isFolderEmpty(storageObj.getObjectID(), storageObj.getModule())) {
                throw OXFolderExceptionCode.DENY_FOLDER_MODULE_UPDATE.create();
            }
            if ((options & 1) > 0) {
                throw OXFolderExceptionCode.NO_FOLDER_MODULE_UPDATE.create();
            }
            FolderObject parent = this.getFolderFromMaster(storageObj.getParentFolderID());
            if (!OXFolderUtility.checkFolderModuleAgainstParentModule(parent.getObjectID(), parent.getModule(), fo.getModule(), this.ctx.getContextId())) {
                throw OXFolderExceptionCode.INVALID_MODULE.create(OXFolderUtility.getFolderName(parent), OXFolderUtility.folderModule2String(fo.getModule()), this.ctx.getContextId());
            }
        } else {
            fo.setModule(storageObj.getModule());
        }
        if (storageObj.isShared(this.user.getId())) {
            throw OXFolderExceptionCode.NO_SHARED_FOLDER_UPDATE.create(OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
        }
        fo.setType(storageObj.getType());
        if (options != 2) {
            fo.setCreatedBy(storageObj.getCreatedBy());
        }
        fo.setDefaultFolder(storageObj.isDefaultFolder());
        OXFolderUtility.checkPermissionsAgainstSessionUserConfig(fo, this.userPerms, this.ctx);
        OXFolderUtility.checkFolderPermissions(fo, this.user.getId(), this.ctx, this.warnings);
        OXFolderUtility.checkPermissionsAgainstUserConfigs(fo, this.ctx);
        OXFolderUtility.checkSystemFolderPermissions(fo.getObjectID(), fo.getNonSystemPermissionsAsArray(), this.user, this.ctx);
        if (2 == fo.getType()) {
            OCLPermission[] removedPerms = OXFolderUtility.getPermissionsWithoutFolderAccess(fo.getNonSystemPermissionsAsArray(), storageObj.getNonSystemPermissionsAsArray());
            if (removedPerms.length > 0) {
                new CheckPermissionOnRemove(this.session, this.writeCon, this.ctx).checkPermissionsOnUpdate(fo.getObjectID(), removedPerms, lastModified);
            }
            new CheckPermissionOnInsert(this.session, this.writeCon, this.ctx).checkParentPermissions(storageObj.getParentFolderID(), fo.getNonSystemPermissionsAsArray(), lastModified);
        }
        boolean rename = false;
        if (fo.containsFolderName() && !storageObj.getFolderName().equals(fo.getFolderName())) {
            rename = true;
            OXFolderUtility.checkFolderStringData(fo);
            try {
                String folderName = fo.getFolderName();
                int folderId = OXFolderSQL.lookUpFolderOnUpdate(fo.getObjectID(), storageObj.getParentFolderID(), folderName, fo.getModule(), this.readCon, this.ctx);
                if (folderId != -1 && folderId != fo.getObjectID()) {
                    throw OXFolderExceptionCode.NO_DUPLICATE_FOLDER.create(OXFolderUtility.getFolderName(new OXFolderAccess(this.readCon, this.ctx).getFolderObject(storageObj.getParentFolderID())), this.ctx.getContextId(), folderName);
                }
                int parentFolderId = storageObj.getParentFolderID();
                OXFolderUtility.checki18nString(parentFolderId, folderName, this.user.getLocale(), this.ctx);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (fo.getType() == 1 && fo.getPermissions().size() > 1 && !(diff = OXFolderUtility.getShareUsers(rename ? null : storageObj.getPermissions(), fo.getPermissions(), this.user.getId(), this.ctx)).isEmpty()) {
            FolderObject[] allSharedFolders;
            try {
                TIntCollection fuids = OXFolderSQL.getSharedFoldersOf(this.user.getId(), this.readCon, this.ctx);
                int size = fuids.size();
                allSharedFolders = new FolderObject[size];
                TIntIterator iter = fuids.iterator();
                for (int i = 0; i < size; ++i) {
                    int fuid = iter.next();
                    if (fuid == fo.getObjectID()) continue;
                    allSharedFolders[i] = this.getOXFolderAccess().getFolderObject(fuid);
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, fo, TABLE_OXFOLDER_TREE);
            }
            catch (IncorrectStringSQLException e) {
                throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            OXFolderUtility.checkSimilarNamedSharedFolder(diff, allSharedFolders, rename ? fo.getFolderName() : storageObj.getFolderName(), this.ctx);
        }
        OXFolderUtility.checkForDuplicateNonSystemPermissions(fo, this.ctx);
        try {
            OXFolderSQL.updateFolderSQL(this.user.getId(), fo, lastModified, this.ctx, this.writeCon);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, fo, TABLE_OXFOLDER_TREE);
        }
        catch (IncorrectStringSQLException e) {
            throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (handDown) {
            try {
                List<OCLPermission> permissions;
                if (containsPermissions && (permissions = fo.getPermissions()) != null && !permissions.isEmpty()) {
                    this.handDown(fo.getObjectID(), options, permissions, lastModified, FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance() : null);
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, fo, TABLE_OXFOLDER_TREE);
            }
            catch (IncorrectStringSQLException e) {
                throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (ProcedureFailedException e) {
                Throwable cause = e.getCause();
                if (cause instanceof OXException) {
                    throw (OXException)cause;
                }
                if (cause instanceof SQLException) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(cause, cause.getMessage());
                }
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(cause, cause.getMessage());
            }
        }
    }

    protected void handDown(int folderId, final int options, final List<OCLPermission> permissions, final long lastModified, final FolderCacheManager cacheManager) throws OXException, SQLException {
        final Context ctx = this.ctx;
        TIntList subfolders = OXFolderSQL.getSubfolderIDs(folderId, this.writeCon, ctx);
        if (!subfolders.isEmpty()) {
            final Session session = this.session;
            subfolders.forEach(new TIntProcedure(){

                public boolean execute(int subfolderId) {
                    try {
                        FolderObject tmp = new FolderObject(subfolderId);
                        tmp.setPermissions(permissions);
                        OXFolderManagerImpl.this.update(tmp, options, OXFolderManagerImpl.this.getFolderFromMaster(subfolderId), lastModified, true);
                        if (null != cacheManager) {
                            cacheManager.removeFolderObject(subfolderId, ctx);
                        }
                        CacheFolderStorage.getInstance().removeFromCache(Integer.toString(subfolderId), FolderStorage.REAL_TREE_ID, true, session);
                        OXFolderManagerImpl.this.handDown(subfolderId, options, permissions, lastModified, cacheManager);
                        return true;
                    }
                    catch (OXException e) {
                        throw new ProcedureFailedException(e);
                    }
                    catch (SQLException e) {
                        throw new ProcedureFailedException(e);
                    }
                    catch (RuntimeException e) {
                        throw new ProcedureFailedException(e);
                    }
                }
            });
        }
    }

    protected FolderObject getFolderFromMaster(int folderId) throws OXException {
        return this.getFolderFromMaster(folderId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FolderObject getFolderFromMaster(int folderId, boolean withSubfolders) throws OXException {
        Connection wc = this.writeCon;
        if (wc != null) {
            return FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, true, withSubfolders);
        }
        wc = DBPool.pickupWriteable(this.ctx);
        try {
            FolderObject folderObject = FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, true, withSubfolders);
            return folderObject;
        }
        finally {
            DBPool.closeWriterAfterReading(this.ctx, wc);
        }
    }

    private boolean isFolderEmpty(int folderId, int module) throws OXException {
        if (module == 1) {
            Tasks tasks2 = Tasks.getInstance();
            return this.readCon == null ? tasks2.isFolderEmpty(this.ctx, folderId) : tasks2.isFolderEmpty(this.ctx, this.readCon, folderId);
        }
        if (module == 2) {
            AppointmentSQLInterface calSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(this.session);
            if (this.readCon == null) {
                try {
                    return calSql.isFolderEmpty(this.user.getId(), folderId);
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
            }
            try {
                return calSql.isFolderEmpty(this.user.getId(), folderId, this.readCon);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (module == 3) {
            ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class, true);
            return contactService.isFolderEmpty(this.session, String.valueOf(folderId));
        }
        if (module == 8) {
            EventFiringInfostoreFacadeImpl db = new EventFiringInfostoreFacadeImpl(this.readCon == null ? new DBPoolProvider() : new StaticDBPoolProvider(this.readCon));
            return db.isFolderEmpty(folderId, this.ctx);
        }
        if (module == 5) {
            return true;
        }
        throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(module), this.ctx.getContextId());
    }

    private static boolean isKnownModule(int module) {
        return module == 1 || module == 2 || module == 3 || module == 8;
    }

    private void rename(FolderObject folderObj, FolderObject storageObj, long lastModified) throws OXException {
        TIntSet diff;
        if (folderObj.getObjectID() <= 0) {
            throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(OXFolderUtility.getFolderName(folderObj));
        }
        if (!folderObj.containsFolderName() || folderObj.getFolderName() == null || folderObj.getFolderName().trim().length() == 0) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("title", "", this.ctx.getContextId());
        }
        OXFolderUtility.checkFolderStringData(folderObj);
        if (storageObj.getFolderName().equals(folderObj.getFolderName())) {
            return;
        }
        if (storageObj.isDefaultFolder()) {
            throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_RENAME.create(OXFolderUtility.getFolderName(folderObj), this.ctx.getContextId());
        }
        try {
            boolean throwException;
            int parentFolderID;
            String folderName;
            block19: {
                block18: {
                    folderName = folderObj.getFolderName();
                    parentFolderID = storageObj.getParentFolderID();
                    int folderId = folderObj.getObjectID();
                    throwException = false;
                    if (parentFolderID == 1) break block18;
                    if (OXFolderSQL.lookUpFolderOnUpdate(folderId, parentFolderID, folderName, storageObj.getModule(), this.readCon, this.ctx) == -1) break block19;
                    throwException = true;
                    break block19;
                }
                TIntList folders2 = OXFolderSQL.lookUpFolders(parentFolderID, folderName, storageObj.getModule(), this.readCon, this.ctx);
                for (int fuid : folders2.toArray()) {
                    FolderObject toCheck = this.getOXFolderAccess().getFolderObject(fuid);
                    if (toCheck.getCreatedBy() != (folderObj.containsCreatedBy() ? folderObj.getCreatedBy() : this.user.getId())) continue;
                    throwException = true;
                    break;
                }
            }
            if (throwException) {
                throw OXFolderExceptionCode.NO_DUPLICATE_FOLDER.create(OXFolderUtility.getFolderName(new OXFolderAccess(this.readCon, this.ctx).getFolderObject(storageObj.getParentFolderID())), this.ctx.getContextId(), folderName);
            }
            OXFolderUtility.checki18nString(parentFolderID, folderName, this.user.getLocale(), this.ctx);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (storageObj.getType() == 1 && storageObj.getPermissions().size() > 1 && !(diff = OXFolderUtility.getShareUsers(null, storageObj.getPermissions(), this.user.getId(), this.ctx)).isEmpty()) {
            FolderObject[] allSharedFolders;
            try {
                TIntCollection fuids = OXFolderSQL.getSharedFoldersOf(this.user.getId(), this.readCon, this.ctx);
                int size = fuids.size();
                allSharedFolders = new FolderObject[size];
                TIntIterator iter = fuids.iterator();
                for (int i = 0; i < size; ++i) {
                    int fuid = iter.next();
                    if (fuid == folderObj.getObjectID()) continue;
                    allSharedFolders[i] = this.getOXFolderAccess().getFolderObject(fuid);
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
            }
            catch (IncorrectStringSQLException e) {
                throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            OXFolderUtility.checkSimilarNamedSharedFolder(diff, allSharedFolders, folderObj.getFolderName(), this.ctx);
        }
        try {
            OXFolderSQL.renameFolderSQL(this.user.getId(), folderObj, lastModified, this.ctx, this.writeCon);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
        }
        catch (IncorrectStringSQLException e) {
            throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static boolean isInArray(int key, int[] a) {
        Arrays.sort(a);
        return Arrays.binarySearch(a, key) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(int folderId, int targetFolderId, int createdBy, String newName, FolderObject storageSrc, long lastModified) throws OXException {
        if (storageSrc.getParentFolderID() == targetFolderId && (null == newName || newName.equals(storageSrc.getFolderName()))) {
            return;
        }
        if (storageSrc.isDefaultFolder()) {
            throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
        }
        FolderObject storageDest = this.getOXFolderAccess().getFolderObject(targetFolderId);
        try {
            boolean throwException;
            String folderName;
            block48: {
                int parentFolderID;
                block47: {
                    parentFolderID = storageDest.getObjectID();
                    folderName = null == newName ? storageSrc.getFolderName() : newName;
                    throwException = false;
                    if (parentFolderID == 1) break block47;
                    if (OXFolderSQL.lookUpFolderOnUpdate(folderId, parentFolderID, folderName, storageSrc.getModule(), this.readCon, this.ctx) == -1) break block48;
                    throwException = true;
                    break block48;
                }
                TIntList folders2 = OXFolderSQL.lookUpFolders(parentFolderID, folderName, storageSrc.getModule(), this.readCon, this.ctx);
                for (int fuid : folders2.toArray()) {
                    FolderObject toCheck = this.getOXFolderAccess().getFolderObject(fuid);
                    if (toCheck.getCreatedBy() != (createdBy > 0 ? createdBy : this.user.getId())) continue;
                    throwException = true;
                    break;
                }
            }
            if (throwException) {
                throw OXFolderExceptionCode.NO_DUPLICATE_FOLDER.create(OXFolderUtility.getFolderName(storageDest), this.ctx.getContextId(), folderName);
            }
            OXFolderUtility.checki18nString(targetFolderId, folderName, this.user.getLocale(), this.ctx);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            if (storageSrc.isShared(this.user.getId())) {
                throw OXFolderExceptionCode.NO_SHARED_FOLDER_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
            }
            if (storageDest.isShared(this.user.getId())) {
                throw OXFolderExceptionCode.NO_SHARED_FOLDER_TARGET.create(OXFolderUtility.getFolderName(storageDest), this.ctx.getContextId());
            }
            if (storageSrc.getType() == 5) {
                throw OXFolderExceptionCode.NO_SYSTEM_FOLDER_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
            }
            if (storageSrc.getType() == 1 && (storageDest.getType() == 2 || storageDest.getType() == 5 && targetFolderId != 1)) {
                throw OXFolderExceptionCode.ONLY_PRIVATE_TO_PRIVATE_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
            }
            if (storageSrc.getType() == 2 && (storageDest.getType() == 1 || storageDest.getType() == 5 && !OXFolderManagerImpl.isInArray(targetFolderId, this.SYSTEM_PUBLIC_FOLDERS))) {
                throw OXFolderExceptionCode.ONLY_PUBLIC_TO_PUBLIC_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
            }
            if (storageSrc.getModule() == 8 && storageDest.getModule() != 8 && targetFolderId != 9) {
                throw OXFolderExceptionCode.INCOMPATIBLE_MODULES.create(OXFolderUtility.folderModule2String(storageSrc.getModule()), OXFolderUtility.folderModule2String(storageDest.getModule()));
            }
            if (storageSrc.getModule() != 8 && storageDest.getModule() == 8) {
                throw OXFolderExceptionCode.INCOMPATIBLE_MODULES.create(OXFolderUtility.folderModule2String(storageSrc.getModule()), OXFolderUtility.folderModule2String(storageDest.getModule()));
            }
            if (storageDest.getEffectiveUserPermission(this.user.getId(), this.userPerms).getFolderPermission() < 8) {
                throw OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(storageDest), this.ctx.getContextId());
            }
            if (folderId == targetFolderId) {
                throw OXFolderExceptionCode.NO_EQUAL_MOVE.create(this.ctx.getContextId());
            }
        }
        catch (RuntimeException e) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, this.ctx.getContextId());
        }
        try {
            if (storageSrc.hasSubfolders()) {
                TIntArrayList parentIDList = new TIntArrayList(1);
                parentIDList.add(storageSrc.getObjectID());
                if (OXFolderUtility.isDescendentFolder((TIntList)parentIDList, targetFolderId, this.readCon, this.ctx)) {
                    throw OXFolderExceptionCode.NO_SUBFOLDER_MOVE.create(OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
                }
                int numOfMoveableSubfolders = OXFolderSQL.getNumOfMoveableSubfolders(storageSrc.getObjectID(), this.user.getId(), this.user.getGroups(), this.readCon, this.ctx);
                if (numOfMoveableSubfolders != storageSrc.getSubfolderIds(true, this.ctx).size()) {
                    throw OXFolderExceptionCode.NO_SUBFOLDER_MOVE_ACCESS.create(OXFolderUtility.getUserName(this.session, this.user), OXFolderUtility.getFolderName(storageSrc), this.ctx.getContextId());
                }
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            this.processDeletedFolderThroughMove(storageSrc, new CheckPermissionOnRemove(this.session, this.writeCon, this.ctx), lastModified);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            storageSrc.setFolderName(newName);
            OXFolderSQL.moveFolderSQL(this.user.getId(), storageSrc, storageDest, lastModified, this.ctx, this.readCon, this.writeCon);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, storageSrc, TABLE_OXFOLDER_TREE);
        }
        catch (IncorrectStringSQLException e) {
            throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (16 != storageDest.getType()) {
            try {
                this.processInsertedFolderThroughMove(this.getFolderFromMaster(folderId), new CheckPermissionOnInsert(this.session, this.writeCon, this.ctx), lastModified);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (16 == storageDest.getType() && 16 != storageSrc.getType() || 16 != storageDest.getType() && 16 == storageSrc.getType()) {
            try {
                List<Integer> folderIDs;
                if (!storageSrc.hasSubfolders()) {
                    folderIDs = Collections.singletonList(folderId);
                } else {
                    folderIDs = new ArrayList<Integer>();
                    folderIDs.add(folderId);
                    folderIDs.addAll(OXFolderSQL.getSubfolderIDs(folderId, this.readCon, this.ctx, true));
                }
                OXFolderSQL.updateFolderType(this.writeCon, this.ctx, storageDest.getType(), folderIDs);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        try {
            OXFolderSQL.updateLastModified(storageSrc.getParentFolderID(), lastModified, this.user.getId(), this.writeCon, this.ctx);
            OXFolderSQL.updateLastModified(storageSrc.getObjectID(), lastModified, this.user.getId(), this.writeCon, this.ctx);
            OXFolderSQL.updateLastModified(storageDest.getObjectID(), lastModified, this.user.getId(), this.writeCon, this.ctx);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
        if (FolderCacheManager.isEnabled()) {
            boolean create;
            Connection wc = this.writeCon;
            boolean bl = create = wc == null;
            if (create) {
                wc = DBPool.pickupWriteable(this.ctx);
            }
            try {
                int destParentId;
                int srcParentId = storageSrc.getParentFolderID();
                if (srcParentId > 0) {
                    FolderCacheManager.getInstance().loadFolderObject(srcParentId, this.ctx, wc);
                }
                if ((destParentId = storageDest.getParentFolderID()) > 0) {
                    FolderCacheManager.getInstance().loadFolderObject(destParentId, this.ctx, wc);
                }
            }
            finally {
                if (create && wc != null) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                }
            }
        }
    }

    private void processDeletedFolderThroughMove(FolderObject folder, CheckPermissionOnRemove checker, long lastModified) throws OXException, SQLException, OXException {
        int folderId = folder.getObjectID();
        ArrayList<Integer> subflds = FolderObject.getSubfolderIds(folderId, this.ctx, this.writeCon);
        for (Integer subfld : subflds) {
            this.processDeletedFolderThroughMove(this.getOXFolderAccess().getFolderObject(subfld), checker, lastModified);
        }
        checker.checkPermissionsOnDelete(folder.getParentFolderID(), folderId, folder.getNonSystemPermissionsAsArray(), lastModified);
        OXFolderSQL.deleteAllSystemPermission(folderId, this.writeCon, this.ctx);
    }

    private void processInsertedFolderThroughMove(FolderObject folder, CheckPermissionOnInsert checker, long lastModified) throws OXException, SQLException, OXException {
        int folderId = folder.getObjectID();
        checker.checkParentPermissions(folder.getParentFolderID(), folder.getNonSystemPermissionsAsArray(), lastModified);
        ArrayList<Integer> subflds = FolderObject.getSubfolderIds(folderId, this.ctx, this.writeCon);
        for (Integer subfld : subflds) {
            this.processInsertedFolderThroughMove(this.getOXFolderAccess().getFolderObject(subfld), checker, lastModified);
        }
    }

    @Override
    public FolderObject clearFolder(FolderObject fo, boolean checkPermissions, long lastModified) throws OXException {
        EffectivePermission p;
        if (fo.getObjectID() <= 0) {
            throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(OXFolderUtility.getFolderName(fo));
        }
        if (!fo.containsParentFolderID() || fo.getParentFolderID() <= 0) {
            fo.setParentFolderID(this.getOXFolderAccess().getParentFolderID(fo.getObjectID()));
        } else {
            try {
                if (!OXFolderSQL.exists(fo.getObjectID(), this.readCon, this.ctx)) {
                    throw OXFolderExceptionCode.NOT_EXISTS.create(fo.getObjectID(), this.ctx.getContextId());
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (checkPermissions && !(p = this.getOXFolderAccess().getFolderPermission(fo.getObjectID(), this.user.getId(), this.userPerms)).isFolderVisible()) {
            if (p.getUnderlyingPermission().isFolderVisible()) {
                throw OXFolderExceptionCode.NOT_VISIBLE.create(fo.getObjectID(), OXFolderUtility.getUserName(this.user.getId(), this.ctx), this.ctx.getContextId());
            }
            throw OXFolderExceptionCode.NOT_VISIBLE.create(CATEGORY_PERMISSION_DENIED, fo.getObjectID(), OXFolderUtility.getUserName(this.user.getId(), this.ctx), this.ctx.getContextId());
        }
        if (!this.getOXFolderAccess().canDeleteAllObjectsInFolder(fo, this.session, this.ctx)) {
            throw OXFolderExceptionCode.NOT_ALL_OBJECTS_DELETION.create(OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(fo.getObjectID(), this.ctx), this.ctx.getContextId());
        }
        int module = fo.getModule();
        switch (module) {
            case 2: {
                this.deleteContainedAppointments(fo.getObjectID());
                break;
            }
            case 1: {
                this.deleteContainedTasks(fo.getObjectID());
                break;
            }
            case 3: {
                this.deleteContainedContacts(fo.getObjectID());
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.deleteContainedDocuments(fo.getObjectID());
                break;
            }
            default: {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(module, this.ctx.getContextId());
            }
        }
        if (16 == fo.getType()) {
            TIntObjectHashMap deleteableFolders = new TIntObjectHashMap();
            try {
                TIntList subfolders = OXFolderSQL.getSubfolderIDs(fo.getObjectID(), this.readCon, this.ctx);
                for (int i = 0; i < subfolders.size(); ++i) {
                    deleteableFolders.putAll(this.gatherDeleteableFolders(subfolders.get(i), this.user.getId(), this.userPerms, StringCollection.getSqlInString(this.user.getId(), this.user.getGroups())));
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            if (0 < deleteableFolders.size()) {
                this.deleteValidatedFolders((TIntObjectMap<TIntObjectMap<?>>)deleteableFolders, lastModified, fo.getType());
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderObject deleteFolder(FolderObject fo, boolean checkPermissions, long lastModified, boolean hardDelete) throws OXException {
        FolderObject folderObject;
        block27: {
            TIntObjectMap<TIntObjectMap<?>> deleteableFolders;
            FolderObject trashFolder;
            int folderId = fo.getObjectID();
            if (folderId <= 0) {
                throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(OXFolderUtility.getFolderName(fo));
            }
            if (folderId < 20) {
                throw OXFolderExceptionCode.NO_SYSTEM_FOLDER_MOVE.create(OXFolderUtility.getFolderName(fo), this.ctx.getContextId());
            }
            OXFolderAccess folderAccess = this.getOXFolderAccess();
            FolderObject folder = folderAccess.getFolderObject(folderId);
            if (checkPermissions) {
                EffectivePermission p = folder.getEffectiveUserPermission(this.user.getId(), this.userPerms);
                if (!p.isFolderVisible()) {
                    if (p.getUnderlyingPermission().isFolderVisible()) {
                        throw OXFolderExceptionCode.NOT_VISIBLE.create(folderId, OXFolderUtility.getUserName(this.user.getId(), this.ctx), this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(CATEGORY_PERMISSION_DENIED, folderId, OXFolderUtility.getUserName(this.user.getId(), this.ctx), this.ctx.getContextId());
                }
                if (!p.isFolderAdmin()) {
                    if (!p.getUnderlyingPermission().isFolderAdmin()) {
                        throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(folder), this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(CATEGORY_PERMISSION_DENIED, OXFolderUtility.getUserName(this.user.getId(), this.ctx), OXFolderUtility.getFolderName(folder), this.ctx.getContextId());
                }
            }
            FolderObject parentFolder = folderAccess.getFolderObject(folder.getParentFolderID());
            if (!hardDelete && null != (trashFolder = this.getTrashFolder(folder.getModule()))) {
                boolean belowTrash;
                int trashFolderID = trashFolder.getObjectID();
                if (parentFolder.getObjectID() == trashFolderID || parentFolder.getParentFolderID() == trashFolderID) {
                    belowTrash = true;
                } else {
                    FolderObject p = parentFolder;
                    while (p.getParentFolderID() != trashFolderID && 20 < p.getParentFolderID()) {
                        p = folderAccess.getFolderObject(p.getParentFolderID());
                    }
                    boolean bl = belowTrash = p.getParentFolderID() == trashFolderID;
                }
                if (!belowTrash) {
                    String name = folder.getFolderName();
                    try {
                        while (-1 != OXFolderSQL.lookUpFolderOnUpdate(folderId, trashFolderID, name, folder.getModule(), this.readCon, this.ctx)) {
                            name = OXFolderManagerImpl.incrementSequenceNumber(name);
                        }
                    }
                    catch (SQLException e) {
                        throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                    }
                    this.deleteSubscriptionsAndPublications(folder.getModule(), folderId, true);
                    FolderObject toUpdate = new FolderObject(name, folderId, folder.getModule(), folder.getType(), this.user.getId());
                    toUpdate.setParentFolderID(trashFolderID);
                    toUpdate.setPermissions(trashFolder.getPermissions());
                    int options = this.user.getId() != folder.getCreatedBy() ? 2 : 0;
                    return this.updateFolder(toUpdate, false, true, lastModified, options);
                }
            }
            try {
                deleteableFolders = this.gatherDeleteableFolders(folderId, this.user.getId(), this.userPerms, StringCollection.getSqlInString(this.user.getId(), this.user.getGroups()));
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            int type = this.getOXFolderAccess().getFolderType(folderId);
            this.deleteValidatedFolders(deleteableFolders, lastModified, type);
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
            Connection wc = this.writeCon;
            boolean create = wc == null;
            try {
                if (create) {
                    wc = DBPool.pickupWriteable(this.ctx);
                }
                boolean hasSubfolders = !OXFolderSQL.getSubfolderIDs(parentFolder.getObjectID(), wc, this.ctx).isEmpty();
                OXFolderSQL.updateSubfolderFlag(parentFolder.getObjectID(), hasSubfolders, lastModified, wc, this.ctx);
                if (FolderCacheManager.isEnabled() && FolderCacheManager.isInitialized()) {
                    FolderCacheManager.getInstance().removeFolderObject(parentFolder.getObjectID(), this.ctx);
                    FolderCacheManager.getInstance().loadFolderObject(parentFolder.getObjectID(), this.ctx, wc);
                }
                fo.fill(FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, true, false, "del_oxfolder_tree", "del_oxfolder_permissions"));
                folderObject = fo;
                if (!create || wc == null) break block27;
            }
            catch (Throwable throwable) {
                try {
                    if (create && wc != null) {
                        DBPool.closeWriterSilent(this.ctx, wc);
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
            }
            DBPool.closeWriterSilent(this.ctx, wc);
        }
        return folderObject;
    }

    void deleteValidatedFolders(TIntObjectMap<TIntObjectMap<?>> deleteableIDs, long lastModified, int type) throws OXException {
        OXException error;
        DeleteValidatedFoldersProcedure procedure = new DeleteValidatedFoldersProcedure(lastModified, type);
        if (!deleteableIDs.forEachEntry((TIntObjectProcedure)procedure) && null != (error = procedure.error)) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteSubscriptionsAndPublications(int module, int folderID, boolean handDown) throws OXException {
        Connection wc = this.writeCon;
        boolean create = wc == null;
        try {
            if (create) {
                wc = DBPool.pickupWriteable(this.ctx);
            }
            int n = this.deleteSubscriptionsAndPublications(wc, module, folderID, handDown);
            return n;
        }
        finally {
            if (create && wc != null) {
                DBPool.closeWriterSilent(this.ctx, wc);
            }
        }
    }

    private int deleteSubscriptionsAndPublications(Connection con, int module, int folderID, boolean handDown) throws OXException {
        int updated = 0;
        PreparedStatement stmt1 = null;
        PreparedStatement stmt2 = null;
        try {
            String whereFolderID;
            TIntList subfolderIDs;
            TIntList tIntList = subfolderIDs = handDown ? OXFolderSQL.getSubfolderIDs(folderID, con, this.ctx) : null;
            if (null == subfolderIDs || 0 == subfolderIDs.size()) {
                whereFolderID = "=?;";
            } else {
                StringBuilder StringBuilder2 = new StringBuilder(" IN (?");
                for (int i = 0; i < subfolderIDs.size(); ++i) {
                    StringBuilder2.append(",?");
                }
                StringBuilder2.append(");");
                whereFolderID = StringBuilder2.toString();
            }
            stmt1 = con.prepareStatement("DELETE FROM publications WHERE cid=? AND module=? AND entity" + whereFolderID);
            stmt1.setInt(1, this.ctx.getContextId());
            stmt1.setString(2, Module.getModuleString(module, folderID));
            stmt1.setInt(3, folderID);
            if (null != subfolderIDs && 0 < subfolderIDs.size()) {
                for (int i = 0; i < subfolderIDs.size(); ++i) {
                    stmt1.setInt(i + 4, subfolderIDs.get(i));
                }
            }
            updated += stmt1.executeUpdate();
            stmt2 = con.prepareStatement("DELETE FROM subscriptions WHERE cid=? AND folder_id" + whereFolderID);
            stmt2.setInt(1, this.ctx.getContextId());
            stmt2.setInt(2, folderID);
            if (null != subfolderIDs && 0 < subfolderIDs.size()) {
                for (int i = 0; i < subfolderIDs.size(); ++i) {
                    stmt2.setInt(i + 3, subfolderIDs.get(i));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt1);
                DBUtils.closeSQLStuff(stmt2);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt1);
        DBUtils.closeSQLStuff(stmt2);
        return updated += stmt2.executeUpdate();
    }

    private static String incrementSequenceNumber(String folderName) {
        String name = folderName;
        Pattern regex = Pattern.compile("\\((\\d+)\\)\\z");
        Matcher matcher = regex.matcher(name);
        if (!matcher.find()) {
            name = name + " (1)";
        } else if (0 == matcher.groupCount() || 0 < matcher.groupCount() && Strings.isEmpty((String)matcher.group(1))) {
            name = name.substring(0, matcher.start()) + " (1)";
        } else {
            int number = 0;
            try {
                number = Integer.valueOf(matcher.group(1).trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            name = name.substring(0, matcher.start()) + '(' + String.valueOf(1 + number) + ')';
        }
        return name;
    }

    private FolderObject getTrashFolder(int module) throws OXException {
        try {
            return this.getOXFolderAccess().getDefaultFolder(this.user.getId(), module, 16);
        }
        catch (OXException e) {
            if (!OXFolderExceptionCode.NO_DEFAULT_FOLDER_FOUND.equals(e)) {
                throw e;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteValidatedFolder(int folderID, long lastModified, int type, boolean hardDelete) throws OXException {
        block26: {
            FolderObject storageFolder;
            try {
                storageFolder = this.getFolderFromMaster(folderID, false);
            }
            catch (OXException e) {
                if (!OXFolderExceptionCode.NOT_EXISTS.equals(e)) {
                    throw e;
                }
                return;
            }
            if (hardDelete) {
                this.deleteContainedItems(folderID);
                try {
                    OXFolderSQL.delOXFolder(folderID, this.session.getUserId(), lastModified, true, false, this.ctx, this.writeCon);
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
            }
            Iterator<FolderDeleteListenerService> iter = FolderDeleteListenerRegistry.getInstance().getDeleteListenerServices();
            while (iter.hasNext()) {
                FolderDeleteListenerService next = iter.next();
                try {
                    next.onFolderDelete(folderID, this.ctx);
                }
                catch (OXException e) {
                    LOG.error("Folder delete listener \"{}\" failed for folder {} int context {}", new Object[]{next.getClass().getName(), folderID, this.ctx.getContextId(), e});
                    throw e;
                }
            }
            this.deleteContainedItems(folderID);
            OCLPermission[] perms = this.getOXFolderAccess().getFolderObject(folderID).getPermissionsAsArray();
            int parent = this.getOXFolderAccess().getParentFolderID(folderID);
            try {
                OXFolderSQL.delWorkingOXFolder(folderID, this.session.getUserId(), lastModified, this.ctx, this.writeCon);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            if (2 == type) {
                new CheckPermissionOnRemove(this.session, this.writeCon, this.ctx).checkPermissionsOnDelete(parent, folderID, perms, lastModified);
            }
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.ctx.getContextId());
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
            if (FolderCacheManager.isEnabled() && FolderCacheManager.isInitialized()) {
                try {
                    FolderCacheManager.getInstance().removeFolderObject(folderID, this.ctx);
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            Connection wc = this.writeCon;
            boolean closeWriter = false;
            if (wc == null) {
                wc = DBPool.pickupWriteable(this.ctx);
                closeWriter = true;
            }
            try {
                ServerUserSetting sus = ServerUserSetting.getInstance(wc);
                Integer collectFolder = sus.getContactCollectionFolder(this.ctx.getContextId(), this.user.getId());
                if (null != collectFolder && folderID == collectFolder) {
                    sus.setContactCollectOnMailAccess(this.ctx.getContextId(), this.user.getId(), false);
                    sus.setContactCollectOnMailTransport(this.ctx.getContextId(), this.user.getId(), false);
                    sus.setContactCollectionFolder(this.ctx.getContextId(), this.user.getId(), null);
                }
                this.deleteSubscriptionsAndPublications(wc, storageFolder.getModule(), folderID, false);
                if (hardDelete) break block26;
                FolderObject fo = FolderObject.loadFolderObjectFromDB(folderID, this.ctx, wc, true, false, "del_oxfolder_tree", "del_oxfolder_permissions");
                try {
                    if (8 == fo.getModule()) {
                        FolderObject parentFolder = FolderObject.loadFolderObjectFromDB(fo.getParentFolderID(), this.ctx, wc, true, false);
                        new EventClient(this.session).delete(fo, parentFolder, this.getFolderPath(fo, parentFolder, wc));
                        break block26;
                    }
                    new EventClient(this.session).delete(fo);
                }
                catch (OXException e) {
                    LOG.warn("Delete event could not be enqueued", (Throwable)e);
                }
            }
            finally {
                if (closeWriter) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                }
            }
        }
    }

    private void deleteContainedItems(int folderID) throws OXException {
        int module = this.getOXFolderAccess().getFolderModule(folderID);
        switch (module) {
            case 2: {
                this.deleteContainedAppointments(folderID);
                break;
            }
            case 1: {
                this.deleteContainedTasks(folderID);
                break;
            }
            case 3: {
                this.deleteContainedContacts(folderID);
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.deleteContainedDocuments(folderID);
                break;
            }
            default: {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(module, this.ctx.getContextId());
            }
        }
    }

    private void deleteContainedAppointments(int folderID) throws OXException {
        try {
            if (null == this.writeCon) {
                this.cSql.deleteAppointmentsInFolder(folderID);
            } else {
                this.cSql.deleteAppointmentsInFolder(folderID, this.writeCon);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteContainedTasks(int folderID) throws OXException {
        Tasks tasks2 = Tasks.getInstance();
        if (null == this.writeCon) {
            Connection wc = null;
            try {
                wc = DBPool.pickupWriteable(this.ctx);
                tasks2.deleteTasksInFolder(this.session, wc, folderID);
            }
            finally {
                if (null != wc) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                }
            }
        } else {
            tasks2.deleteTasksInFolder(this.session, this.writeCon, folderID);
        }
    }

    private void deleteContainedContacts(int folderID) throws OXException {
        ServerServiceRegistry.getInstance().getService(ContactService.class).deleteContacts(this.session, String.valueOf(folderID));
    }

    private void deleteContainedDocuments(int folderID) throws OXException {
        EventFiringInfostoreFacadeImpl infostoreFacade;
        if (this.writeCon == null) {
            infostoreFacade = new EventFiringInfostoreFacadeImpl(new DBPoolProvider());
        } else {
            infostoreFacade = new EventFiringInfostoreFacadeImpl(new StaticDBPoolProvider(this.writeCon));
            infostoreFacade.setCommitsTransaction(false);
        }
        infostoreFacade.setTransactional(true);
        infostoreFacade.startTransaction();
        try {
            infostoreFacade.removeDocument(folderID, Long.MAX_VALUE, ServerSessionAdapter.valueOf(this.session, this.ctx));
            infostoreFacade.commit();
        }
        catch (OXException x) {
            infostoreFacade.rollback();
            if (InfostoreExceptionCodes.ALREADY_LOCKED.equals(x)) {
                throw OXFolderExceptionCode.DELETE_FAILED_LOCKED_DOCUMENTS.create(x, OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
            }
            throw x;
        }
        catch (RuntimeException x) {
            infostoreFacade.rollback();
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(x, this.ctx.getContextId());
        }
        finally {
            infostoreFacade.finish();
        }
    }

    private TIntObjectMap<TIntObjectMap<?>> gatherDeleteableFolders(int folderID, int userId, UserPermissionBits userPerms, String permissionIDs) throws OXException, OXException, SQLException {
        TIntObjectHashMap deleteableIDs = new TIntObjectHashMap();
        Integer[] specials = new Integer[1];
        Integer i = null;
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null != service && service.getBoolProperty("com.openexchange.contactcollector.folder.deleteDenied", false)) {
            i = ServerUserSetting.getInstance(this.writeCon).getContactCollectionFolder(this.ctx.getContextId(), userId);
        }
        specials[0] = i;
        this.gatherDeleteableSubfoldersRecursively(folderID, userId, userPerms, permissionIDs, (TIntObjectMap<TIntObjectMap<?>>)deleteableIDs, folderID, specials);
        return deleteableIDs;
    }

    private void gatherDeleteableSubfoldersRecursively(int folderID, int userId, UserPermissionBits userPerms, String permissionIDs, TIntObjectMap<TIntObjectMap<?>> deleteableIDs, int initParent, Integer[] specials) throws OXException, OXException, SQLException {
        FolderObject delFolder = this.getOXFolderAccess().getFolderObject(folderID);
        if (delFolder.isShared(userId)) {
            throw OXFolderExceptionCode.NO_SHARED_FOLDER_DELETION.create(OXFolderUtility.getUserName(userId, this.ctx), OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
        }
        if (delFolder.isDefaultFolder()) {
            throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_DELETION.create(OXFolderUtility.getUserName(userId, this.ctx), OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
        }
        EffectivePermission effectivePerm = this.getOXFolderAccess().getFolderPermission(folderID, userId, userPerms);
        if (!effectivePerm.isFolderVisible()) {
            if (!effectivePerm.getUnderlyingPermission().isFolderVisible()) {
                if (initParent == folderID) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(folderID, OXFolderUtility.getUserName(userId, this.ctx), this.ctx.getContextId());
                }
                throw OXFolderExceptionCode.HIDDEN_FOLDER_ON_DELETION.create(OXFolderUtility.getFolderName(initParent, this.ctx), this.ctx.getContextId(), OXFolderUtility.getUserName(userId, this.ctx));
            }
            if (initParent == folderID) {
                throw OXFolderExceptionCode.NOT_VISIBLE.create(CATEGORY_PERMISSION_DENIED, folderID, OXFolderUtility.getUserName(userId, this.ctx), this.ctx.getContextId());
            }
            throw OXFolderExceptionCode.HIDDEN_FOLDER_ON_DELETION.create(CATEGORY_PERMISSION_DENIED, OXFolderUtility.getFolderName(initParent, this.ctx), this.ctx.getContextId(), OXFolderUtility.getUserName(userId, this.ctx));
        }
        if (!effectivePerm.isFolderAdmin()) {
            if (!effectivePerm.getUnderlyingPermission().isFolderAdmin()) {
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(userId, this.ctx), OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
            }
            throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(CATEGORY_PERMISSION_DENIED, OXFolderUtility.getUserName(userId, this.ctx), OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
        }
        if (!this.getOXFolderAccess().canDeleteAllObjectsInFolder(delFolder, this.session, this.ctx)) {
            throw OXFolderExceptionCode.NOT_ALL_OBJECTS_DELETION.create(OXFolderUtility.getUserName(userId, this.ctx), OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
        }
        for (Integer special : specials) {
            if (null == special || special != folderID) continue;
            throw OXFolderExceptionCode.DELETE_DENIED.create(OXFolderUtility.getFolderName(folderID, this.ctx), this.ctx.getContextId());
        }
        TIntList subfolders = OXFolderSQL.getSubfolderIDs(delFolder.getObjectID(), this.readCon, this.ctx);
        if (subfolders.isEmpty()) {
            deleteableIDs.put(folderID, null);
            return;
        }
        TIntObjectHashMap subMap = new TIntObjectHashMap();
        int size = subfolders.size();
        for (int i = 0; i < size; ++i) {
            this.gatherDeleteableSubfoldersRecursively(subfolders.get(i), userId, userPerms, permissionIDs, (TIntObjectMap<TIntObjectMap<?>>)subMap, initParent, specials);
        }
        deleteableIDs.put(folderID, (Object)subMap);
    }

    private String[] getFolderPath(FolderObject folder, FolderObject parentFolder, Connection connection) throws OXException {
        int startID;
        ArrayList<String> folderPath = new ArrayList<String>();
        folderPath.add(String.valueOf(folder.getObjectID()));
        if (null == parentFolder) {
            startID = folder.getParentFolderID();
            folderPath.add(String.valueOf(startID));
        } else {
            folderPath.add(String.valueOf(parentFolder.getObjectID()));
            startID = parentFolder.getParentFolderID();
            folderPath.add(String.valueOf(startID));
        }
        if (0 != startID) {
            try {
                List<Integer> pathToRoot = OXFolderSQL.getPathToRoot(startID, connection, this.ctx);
                for (Integer id : pathToRoot) {
                    folderPath.add(String.valueOf(id));
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        return folderPath.toArray(new String[folderPath.size()]);
    }

    @Override
    public void cleanUpTestFolders(int[] fuids, Context ctx) {
        for (int fuid : fuids) {
            try {
                OXFolderSQL.hardDeleteOXFolder(fuid, ctx, null);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                if (!FolderCacheManager.isEnabled() || !FolderCacheManager.isInitialized()) continue;
                try {
                    FolderCacheManager.getInstance().removeFolderObject(fuid, ctx);
                }
                catch (OXException e) {
                    LOG.warn("", (Throwable)e);
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private static User getUser(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser();
        }
        return UserStorage.getInstance().getUser(session.getUserId(), session.getContextId());
    }

    private static OXException handleIncorrectStringError(IncorrectStringSQLException e, Session session) throws OXException {
        String column = e.getColumn();
        if (null == column) {
            return OXFolderExceptionCode.INVALID_CHARACTER_SIMPLE.create(e, new Object[0]);
        }
        String displayName = OXFolderUtility.column2Field(column);
        if (null == displayName) {
            return OXFolderExceptionCode.INVALID_CHARACTER.create(e, e.getIncorrectString(), e.getColumn());
        }
        if (null == session) {
            return OXFolderExceptionCode.INVALID_CHARACTER.create(e, e.getIncorrectString(), displayName);
        }
        String translatedName = StringHelper.valueOf(OXFolderManagerImpl.getUser(session).getLocale()).getString(displayName);
        OXException oxe = OXFolderExceptionCode.INVALID_CHARACTER.create(e, e.getIncorrectString(), translatedName);
        oxe.addProblematic((OXException.ProblematicAttribute)new SimpleIncorrectStringAttribute(fieldMapping.get(column), e.getIncorrectString()));
        return oxe;
    }

    private static Object getFolderValue(int folderField, FolderObject folder) {
        if (300 == folderField) {
            return folder.getFolderName();
        }
        if (1 == folderField) {
            return folder.getObjectID();
        }
        if (20 == folderField) {
            return folder.getParentFolderID();
        }
        if (301 == folderField) {
            return folder.getModule();
        }
        if (302 == folderField) {
            return folder.getType();
        }
        if (4 == folderField) {
            return folder.getCreationDate();
        }
        if (2 == folderField) {
            return folder.getCreatedBy();
        }
        if (5 == folderField) {
            return folder.getLastModified();
        }
        if (3 == folderField) {
            return folder.getModifiedBy();
        }
        throw new IllegalStateException("Unknown folder field ID: " + folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OXException parseTruncated(DataTruncation exc, FolderObject folder, String tableName) {
        OXException fe;
        String[] fields = DBUtils.parseTruncatedFields(exc);
        OXException.Truncated[] truncateds = new OXException.Truncated[fields.length];
        StringBuilder sFields = new StringBuilder(fields.length << 3);
        for (int i = 0; i < fields.length; ++i) {
            sFields.append(fields[i]);
            sFields.append(", ");
            final int fieldId = fieldMapping.get(fields[i]);
            Object tmp = OXFolderManagerImpl.getFolderValue(fieldId, folder);
            final int valueLength = tmp instanceof String ? Charsets.getBytes((String)((String)tmp), (Charset)Charsets.UTF_8).length : 0;
            int tmp2 = -1;
            boolean closeReadCon = false;
            Connection readCon = this.readCon;
            if (readCon == null) {
                try {
                    readCon = DBPool.pickup(this.ctx);
                }
                catch (OXException e) {
                    LOG.error("A readable connection could not be fetched from pool", (Throwable)e);
                    return OXFolderExceptionCode.SQL_ERROR.create(exc, exc.getMessage());
                }
                closeReadCon = true;
            }
            try {
                tmp2 = DBUtils.getColumnSize(readCon, tableName, fields[i]);
            }
            catch (SQLException e) {
                LOG.error("", (Throwable)e);
                tmp2 = -1;
            }
            finally {
                if (closeReadCon) {
                    DBPool.closeReaderSilent(this.ctx, readCon);
                }
            }
            final int length = -1 == tmp2 ? 0 : tmp2;
            truncateds[i] = new OXException.Truncated(){

                public int getId() {
                    return fieldId;
                }

                public int getLength() {
                    return valueLength;
                }

                public int getMaxSize() {
                    return length;
                }
            };
        }
        sFields.setLength(sFields.length() - 2);
        if (truncateds.length > 0) {
            OXException.Truncated truncated = truncateds[0];
            fe = 1 == truncateds.length && 300 == truncated.getId() ? OXFolderExceptionCode.TRUNCATED_FOLDERNAME.create(exc, sFields.toString(), truncated.getMaxSize(), truncated.getLength()) : OXFolderExceptionCode.TRUNCATED.create(exc, sFields.toString(), truncated.getMaxSize(), truncated.getLength());
        } else {
            fe = OXFolderExceptionCode.TRUNCATED.create(exc, sFields.toString(), 0, 0);
        }
        for (OXException.Truncated truncated : truncateds) {
            fe.addProblematic((OXException.ProblematicAttribute)truncated);
        }
        return fe;
    }

    private static int getPublishedMailAttachmentsFolder(Session session) {
        if (null == session) {
            return -1;
        }
        Integer i = (Integer)session.getParameter(MailSessionParameterNames.getParamPublishingInfostoreFolderID());
        return null == i ? -1 : i;
    }

    static {
        HashMap<String, Integer> fieldMapping = new HashMap<String, Integer>(9);
        fieldMapping.put("fuid", 1);
        fieldMapping.put("parent", 20);
        fieldMapping.put("fname", 300);
        fieldMapping.put("module", 301);
        fieldMapping.put("type", 302);
        fieldMapping.put("creating_date", 4);
        fieldMapping.put("created_from", 2);
        fieldMapping.put("changing_date", 5);
        fieldMapping.put("changed_from", 3);
        OXFolderManagerImpl.fieldMapping = Collections.unmodifiableMap(fieldMapping);
    }

    private static final class ProcedureFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1821041261492515385L;

        public ProcedureFailedException(Throwable cause) {
            super(cause);
        }
    }

    private final class DeleteValidatedFoldersProcedure
    implements TIntObjectProcedure<TIntObjectMap<?>> {
        public OXException error;
        private final long lastModified;
        private final int type;

        public DeleteValidatedFoldersProcedure(long lastModified, int type) {
            this.lastModified = lastModified;
            this.type = type;
        }

        public boolean execute(int folderId, TIntObjectMap<?> hashMap) {
            if (null == this.error) {
                try {
                    if (null != hashMap) {
                        TIntObjectMap<?> tmp = hashMap;
                        OXFolderManagerImpl.this.deleteValidatedFolders(tmp, this.lastModified, this.type);
                    }
                    OXFolderManagerImpl.this.deleteValidatedFolder(folderId, this.lastModified, this.type, false);
                    return true;
                }
                catch (OXException e) {
                    this.error = e;
                    return false;
                }
            }
            return false;
        }
    }
}

