/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.impl;

import com.openexchange.tools.images.impl.DimensionConstrain;
import java.awt.Dimension;

public class CoverDimensionConstrain
implements DimensionConstrain {
    private final int minWidth;
    private final int minHeight;

    public CoverDimensionConstrain(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    @Override
    public Dimension getDimension(Dimension dimension) {
        if (this.minWidth <= 0 && this.minHeight <= 0) {
            return dimension;
        }
        double scaleWidth = this.minWidth <= 0 ? 0.0 : (double)this.minWidth / (double)dimension.width;
        double scaleHeight = this.minHeight <= 0 ? 0.0 : (double)this.minHeight / (double)dimension.height;
        double scale = Math.max(scaleWidth, scaleHeight);
        int dstWidth = (int)Math.round((double)dimension.width * scale);
        int dstHeight = (int)Math.round((double)dimension.height * scale);
        if (dstWidth < 3) {
            dstWidth = 3;
        }
        if (dstHeight < 3) {
            dstHeight = 3;
        }
        return new Dimension(dstWidth, dstHeight);
    }
}

