/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.server.osgi.ServerActivator;
import com.openexchange.tools.file.external.FileStorage;
import com.openexchange.tools.file.external.FileStorageFactory;
import com.openexchange.tools.file.external.FileStorageFactoryCandidate;
import com.openexchange.tools.file.internal.CompositingFileStorage;
import com.openexchange.tools.file.internal.HashingFileStorage;
import com.openexchange.tools.file.internal.LocalFileStorage;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CompositeFileStorageFactory
implements FileStorageFactory,
ServiceTrackerCustomizer<FileStorageFactoryCandidate, FileStorageFactoryCandidate> {
    protected static final List<FileStorageFactoryCandidate> FACTORY_CANDIDATES = new CopyOnWriteArrayList<FileStorageFactoryCandidate>();

    @Override
    public FileStorage getFileStorage(URI uri) throws OXException {
        if (null == uri) {
            return null;
        }
        FileStorageFactoryCandidate candidate = null;
        for (FileStorageFactoryCandidate fac : FACTORY_CANDIDATES) {
            if (!fac.supports(uri) || null != candidate && fac.getRanking() <= candidate.getRanking()) continue;
            candidate = fac;
        }
        if (null != candidate && candidate.getRanking() >= 0) {
            return candidate.getFileStorage(uri);
        }
        return this.getInternalFileStorage(uri);
    }

    @Override
    public FileStorage getInternalFileStorage(URI uri) throws OXException {
        if (null == uri) {
            return null;
        }
        try {
            LocalFileStorage standardFS = new LocalFileStorage(uri);
            HashingFileStorage hashedFS = new HashingFileStorage(new File(new File(uri), "hashed"));
            CompositingFileStorage cStorage = new CompositingFileStorage();
            cStorage.addStore(standardFS);
            cStorage.addStore("hashed", hashedFS);
            cStorage.setSavePrefix("hashed");
            return cStorage;
        }
        catch (IllegalArgumentException e) {
            throw OXException.general((String)("Cannot create file storage for URI: \"" + uri + "\". Wrong or missing FileStorage bundle for scheme " + uri.getScheme() + "?"), (Throwable)e);
        }
    }

    @Override
    public boolean supports(URI uri) throws OXException {
        return true;
    }

    @Override
    public int getRanking() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStorageFactoryCandidate addingService(ServiceReference<FileStorageFactoryCandidate> reference) {
        BundleContext context = ServerActivator.getContext();
        FileStorageFactoryCandidate candidate = (FileStorageFactoryCandidate)context.getService(reference);
        CompositeFileStorageFactory compositeFileStorageFactory = this;
        synchronized (compositeFileStorageFactory) {
            List<FileStorageFactoryCandidate> candidates = FACTORY_CANDIDATES;
            if (!candidates.contains(candidate)) {
                candidates.add(candidate);
                return candidate;
            }
        }
        return null;
    }

    public void modifiedService(ServiceReference<FileStorageFactoryCandidate> reference, FileStorageFactoryCandidate candidate) {
    }

    public void removedService(ServiceReference<FileStorageFactoryCandidate> reference, FileStorageFactoryCandidate candidate) {
        BundleContext context;
        boolean contained = FACTORY_CANDIDATES.remove(candidate);
        if (contained && null != (context = ServerActivator.getContext())) {
            context.ungetService(reference);
        }
    }
}

