/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.quota.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.i18n.I18nService;
import com.openexchange.quota.AccountQuota;
import com.openexchange.quota.Quota;
import com.openexchange.quota.QuotaProvider;
import com.openexchange.quota.QuotaService;
import com.openexchange.quota.QuotaType;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@Action(method=RequestMethod.GET, name="get", description="Get quota information", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="module", optional=true, description="The module identifier to get quota information for."), @Parameter(name="account", optional=true, description="The account identifier within the module to get quota information for, required if account is set.")}, responseDescription="A JSON object containing the requested quota information. If no \"module\" was specified, all defined modules quotas are set in the JSON object, each one mapped to it's module identifier. If the quota from a \"module\" was requested, a JSON array containing all account quotas of this module are returned. If both a \"module\" and \"account\" were requested, a JSON object representing the account quota is returned.")
public class GetAction
implements AJAXActionService {
    private final BundleContext context;

    public GetAction(BundleContext context) {
        this.context = context;
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData req, ServerSession session) throws OXException {
        AJAXRequestResult aJAXRequestResult;
        block7: {
            String module = req.getParameter("module");
            String accountID = req.getParameter("account");
            ServiceReference quotaServiceRef = this.context.getServiceReference(QuotaService.class);
            if (quotaServiceRef == null) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{QuotaService.class.getName()});
            }
            QuotaService quotaService = (QuotaService)this.context.getService(quotaServiceRef);
            try {
                if (quotaService == null) {
                    throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{QuotaService.class.getName()});
                }
                JSONValue result = this.performRequest(quotaService, session, module, accountID);
                aJAXRequestResult = new AJAXRequestResult((Object)result, "json");
                if (!(quotaServiceRef != null & quotaService != null)) break block7;
            }
            catch (JSONException e) {
                try {
                    throw AjaxExceptionCodes.JSON_ERROR.create(e, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (quotaServiceRef != null & quotaService != null) {
                        this.context.ungetService(quotaServiceRef);
                    }
                    throw throwable;
                }
            }
            this.context.ungetService(quotaServiceRef);
        }
        return aJAXRequestResult;
    }

    private JSONValue performRequest(QuotaService quotaService, ServerSession session, String module, String accountID) throws JSONException, OXException {
        if (module == null) {
            JSONObject allQuotas = new JSONObject();
            for (QuotaProvider provider : quotaService.getAllProviders()) {
                List accountQuotas = provider.getFor((Session)session);
                JSONArray jQuotas = GetAction.buildQuotasJSON(accountQuotas);
                if (jQuotas.isEmpty()) continue;
                JSONObject jProvider = new JSONObject();
                jProvider.put("display_name", (Object)this.localize(provider.getDisplayName(), session));
                jProvider.put("accounts", (Object)jQuotas);
                allQuotas.put(provider.getModuleID(), (Object)jProvider);
            }
            return allQuotas;
        }
        QuotaProvider provider = quotaService.getProvider(module);
        if (provider == null) {
            throw AjaxExceptionCodes.BAD_REQUEST_CUSTOM.create("No provider exists for module '" + module + "'.");
        }
        if (accountID == null) {
            return GetAction.buildQuotasJSON(provider.getFor((Session)session));
        }
        AccountQuota quota = provider.getFor((Session)session, accountID);
        if (quota == null) {
            throw AjaxExceptionCodes.BAD_REQUEST_CUSTOM.create("No account '" + accountID + "' exists for module '" + module + "'.");
        }
        return GetAction.buildQuotaJSON(quota);
    }

    private String localize(String str, ServerSession session) throws OXException {
        String localized = null;
        try {
            for (ServiceReference ref : this.context.getServiceReferences(I18nService.class, null)) {
                I18nService i18nService;
                Locale locale = (Locale)ref.getProperty("language");
                if (locale == null || !locale.equals(session.getUser().getLocale()) || (i18nService = (I18nService)this.context.getService(ref)) == null) continue;
                localized = i18nService.getLocalized(str);
                this.context.ungetService(ref);
                break;
            }
        }
        catch (InvalidSyntaxException e) {
            throw new OXException((Throwable)e);
        }
        if (localized == null) {
            return str;
        }
        return localized;
    }

    private static JSONArray buildQuotasJSON(List<AccountQuota> accountQuotas) throws JSONException {
        JSONArray jQuotas = new JSONArray();
        for (AccountQuota accountQuota : accountQuotas) {
            JSONObject jQuota = GetAction.buildQuotaJSON(accountQuota);
            if (jQuota == null) continue;
            jQuotas.put((Object)jQuota);
        }
        return jQuotas;
    }

    private static JSONObject buildQuotaJSON(AccountQuota accountQuota) throws JSONException {
        Quota sizeQuota = accountQuota.getQuota(QuotaType.SIZE);
        Quota amountQuota = accountQuota.getQuota(QuotaType.AMOUNT);
        if (!(null != sizeQuota && -1L != sizeQuota.getLimit() || null != amountQuota && -1L != amountQuota.getLimit())) {
            return null;
        }
        JSONObject jQuota = new JSONObject();
        jQuota.put("account_id", (Object)accountQuota.getAccountID());
        jQuota.put("account_name", (Object)accountQuota.getAccountName());
        if (null != amountQuota && amountQuota.getLimit() > 0L) {
            jQuota.put("countquota", amountQuota.getLimit());
            jQuota.put("countuse", amountQuota.getUsage());
        }
        if (null != sizeQuota && sizeQuota.getLimit() > 0L) {
            jQuota.put("quota", sizeQuota.getLimit());
            jQuota.put("use", sizeQuota.getUsage());
        }
        return jQuota;
    }
}

