/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport.config;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.mail.api.IMailProperties;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.MailConfigException;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;

public abstract class TransportConfig
extends MailConfig {
    protected TransportConfig() {
    }

    public static final <C extends TransportConfig> C getTransportConfig(C transportConfig, Session session, int accountId) throws OXException {
        MailAccountStorageService storage = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        MailAccount mailAccount = accountId == 0 ? storage.getDefaultMailAccount(session.getUserId(), session.getContextId()) : storage.getMailAccount(accountId, session.getUserId(), session.getContextId());
        transportConfig.accountId = accountId;
        TransportConfig.fillLoginAndPassword(transportConfig, session, UserStorage.getInstance().getUser(session.getUserId(), session.getContextId()).getLoginInfo(), mailAccount);
        String serverURL = TransportConfig.getTransportServerURL(mailAccount);
        if (serverURL == null) {
            if (MailConfig.ServerSource.GLOBAL.equals((Object)MailProperties.getInstance().getTransportServerSource())) {
                throw MailConfigException.create(new StringBuilder(128).append("Property \"").append("com.openexchange.mail.transportServer").append("\" not set in mail properties").toString());
            }
            throw MailConfigException.create(new StringBuilder(128).append("Cannot determine transport server URL for user ").append(session.getUserId()).append(" in context ").append(session.getContextId()).toString());
        }
        int lastPos = serverURL.length() - 1;
        if (serverURL.charAt(lastPos) == '/') {
            serverURL = serverURL.substring(0, lastPos);
        }
        transportConfig.parseServerURL(serverURL);
        transportConfig.doCustomParsing(mailAccount, session);
        return transportConfig;
    }

    public static String getTransportServerURL(MailAccount mailAccount) {
        if (!mailAccount.isDefaultAccount()) {
            return mailAccount.generateTransportServerURL();
        }
        if (MailConfig.ServerSource.GLOBAL.equals((Object)MailProperties.getInstance().getTransportServerSource())) {
            return MailProperties.getInstance().getTransportServer();
        }
        return mailAccount.generateTransportServerURL();
    }

    public static String getTransportServerURL(Session session, int accountId) throws OXException {
        MailAccountStorageService storage = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        return TransportConfig.getTransportServerURL(storage.getMailAccount(accountId, session.getUserId(), session.getContextId()));
    }

    @Override
    public IMailProperties getMailProperties() {
        return null;
    }

    @Override
    public void setMailProperties(IMailProperties mailProperties) {
    }

    public abstract ITransportProperties getTransportProperties();

    public abstract void setTransportProperties(ITransportProperties var1);
}

