/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.threader;

import com.openexchange.mail.MailSortField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.utils.MailMessageComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class Conversation {
    private static final MailMessageComparator COMPARATOR_DESC = new MailMessageComparator(MailSortField.RECEIVED_DATE, true, null);
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Set<MailMessageWrapper> messages;
    private final Set<String> messageIds;
    private final Set<String> references;

    public Conversation() {
        this.messages = new HashSet<MailMessageWrapper>(16);
        this.messageIds = new HashSet<String>(32, 0.9f);
        this.references = new HashSet<String>(32, 0.9f);
    }

    public Conversation(Conversation copy) {
        this.messages = copy.messages;
        this.messageIds = copy.messageIds;
        this.references = copy.references;
    }

    public Conversation(MailMessage message) {
        this();
        this.addMessage(message);
    }

    public Conversation(Collection<MailMessage> messages) {
        this();
        if (null != messages) {
            for (MailMessage message : messages) {
                this.addMessage(message);
            }
        }
    }

    public Conversation addMessage(MailMessage message) {
        if (null != message) {
            this.addWrapper(new MailMessageWrapper(message));
        }
        return this;
    }

    private void addWrapper(MailMessageWrapper mmw) {
        if (this.messages.add(mmw)) {
            String[] sReferences;
            MailMessage message = mmw.message;
            String messageId = message.getMessageId();
            if (null != messageId) {
                this.messageIds.add(messageId);
            }
            if (null != (sReferences = message.getReferences())) {
                for (String sReference : sReferences) {
                    if (null == sReference) continue;
                    this.references.add(sReference);
                }
            }
        }
    }

    public Conversation join(Conversation other) {
        if (null != other) {
            Set<MailMessageWrapper> messages = other.messages;
            for (MailMessageWrapper mmw : messages) {
                this.addWrapper(mmw);
            }
        }
        return this;
    }

    public boolean referencesOrIsReferencedBy(MailMessage message) {
        String[] sReferences;
        String messageId;
        if (!this.references.isEmpty() && null != (messageId = message.getMessageId()) && this.references.contains(messageId)) {
            return true;
        }
        return !this.messageIds.isEmpty() && null != (sReferences = message.getReferences()) && Conversation.containsAny(this.messageIds, Arrays.asList(sReferences));
    }

    public boolean referencesOrIsReferencedBy(Conversation other) {
        return !this.references.isEmpty() && Conversation.containsAny(this.references, other.messageIds) || !other.references.isEmpty() && Conversation.containsAny(this.messageIds, other.references);
    }

    public boolean references(Conversation other) {
        return this.references.isEmpty() ? false : Conversation.containsAny(this.references, other.messageIds);
    }

    public boolean isReferencedBy(Conversation other) {
        return other.references.isEmpty() ? false : Conversation.containsAny(this.messageIds, other.references);
    }

    private static boolean containsAny(Set<String> set, Collection<String> col) {
        Iterator<String> it = col.iterator();
        int i = col.size();
        while (i-- > 0) {
            if (!set.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public List<MailMessage> getMessages() {
        return this.getMessages(COMPARATOR_DESC);
    }

    public List<MailMessage> getMessages(Comparator<MailMessage> comparator) {
        if (this.messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MailMessage> ret = new ArrayList<MailMessage>(this.messages.size());
        for (MailMessageWrapper mmw : this.messages) {
            ret.add(mmw.message);
        }
        Collections.sort(ret, null == comparator ? COMPARATOR_DESC : comparator);
        return ret;
    }

    private static final class MailMessageWrapper {
        final MailMessage message;
        private final int hash;

        MailMessageWrapper(MailMessage message) {
            this.message = message;
            String id = message.getMailId();
            String fullName = message.getFolder();
            int prime = 31;
            int result = 1;
            result = 31 * result + (id == null ? 0 : id.hashCode());
            this.hash = result = 31 * result + (fullName == null ? 0 : fullName.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MailMessageWrapper)) {
                return false;
            }
            MailMessageWrapper other = (MailMessageWrapper)obj;
            if (this.message.getMailId() == null ? other.message.getMailId() != null : !this.message.getMailId().equals(other.message.getMailId())) {
                return false;
            }
            return !(this.message.getFolder() == null ? other.message.getFolder() != null : !this.message.getFolder().equals(other.message.getFolder()));
        }
    }
}

