/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.utils;

import com.openexchange.mail.MailField;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.MessageHeaders;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.UIDSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.FetchProfile;
import javax.mail.UIDFolder;

public final class MimeStorageUtility {
    private static final FetchProfile CACHE_FETCH_PROFILE = new FetchProfile();
    private static final Collection<MailField> CACHE_FIELDS;
    private static final MailField[] CACHE_FIELDS_ARR;
    private static final EnumSet<MailField> ENV_FIELDS;
    private static final EnumSet<MailField> ENUM_SET_FULL;
    private static final List<HeaderName> ENV_LIST;
    private static final EnumMap<MailField, FetchProfile.Item> FIELD2ITEM;
    private static final EnumMap<MailField, List<String>> FIELD2STRING;

    private MimeStorageUtility() {
    }

    public static FetchProfile cloneFetchProfile(FetchProfile toClone) {
        if (null == toClone) {
            return null;
        }
        FetchProfile clone = new FetchProfile();
        for (FetchProfile.Item item : toClone.getItems()) {
            clone.add(item);
        }
        for (String string : toClone.getHeaderNames()) {
            clone.add(string);
        }
        return clone;
    }

    public static Collection<MailField> getCacheFields() {
        return CACHE_FIELDS;
    }

    public static MailField[] getCacheFieldsArray() {
        return CACHE_FIELDS_ARR;
    }

    public static FetchProfile getCacheFetchProfile() {
        return CACHE_FETCH_PROFILE;
    }

    public static FetchProfile getUIDFetchProfile() {
        FetchProfile fp = new FetchProfile();
        fp.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        return fp;
    }

    public static FetchProfile getFlagsFetchProfile() {
        FetchProfile fp = new FetchProfile();
        fp.add(FetchProfile.Item.FLAGS);
        return fp;
    }

    public static Collection<MailField> fetchProfile2MailListFields(FetchProfile fetchProfile) {
        EnumSet<MailField> set = EnumSet.noneOf(MailField.class);
        set.add(MailField.FOLDER_ID);
        if (fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            set.add(MailField.FROM);
            set.add(MailField.TO);
            set.add(MailField.CC);
            set.add(MailField.BCC);
            set.add(MailField.SUBJECT);
            set.add(MailField.RECEIVED_DATE);
            set.add(MailField.SENT_DATE);
            set.add(MailField.SIZE);
        } else {
            set.add(MailField.RECEIVED_DATE);
            if (fetchProfile.contains((FetchProfile.Item)IMAPFolder.FetchProfileItem.SIZE)) {
                set.add(MailField.SIZE);
            }
        }
        if (fetchProfile.contains((FetchProfile.Item)UIDFolder.FetchProfileItem.UID)) {
            set.add(MailField.ID);
        }
        if (fetchProfile.contains(FetchProfile.Item.CONTENT_INFO)) {
            set.add(MailField.CONTENT_TYPE);
        }
        if (fetchProfile.contains(FetchProfile.Item.FLAGS)) {
            set.add(MailField.FLAGS);
            set.add(MailField.COLOR_LABEL);
        }
        if (fetchProfile.contains((FetchProfile.Item)IMAPFolder.FetchProfileItem.HEADERS)) {
            set.add(MailField.HEADERS);
        } else {
            if (fetchProfile.contains(MessageHeaders.HDR_FROM)) {
                set.add(MailField.FROM);
            }
            if (fetchProfile.contains(MessageHeaders.HDR_TO)) {
                set.add(MailField.TO);
            }
            if (fetchProfile.contains(MessageHeaders.HDR_CC)) {
                set.add(MailField.CC);
            }
            if (fetchProfile.contains(MessageHeaders.HDR_BCC)) {
                set.add(MailField.BCC);
            }
            if (fetchProfile.contains(MessageHeaders.HDR_SUBJECT)) {
                set.add(MailField.SUBJECT);
            }
            if (fetchProfile.contains(MessageHeaders.HDR_DISP_NOT_TO)) {
                set.add(MailField.DISPOSITION_NOTIFICATION_TO);
            }
            if (fetchProfile.contains(MessageHeaders.HDR_IMPORTANCE)) {
                set.add(MailField.PRIORITY);
            }
            if (fetchProfile.contains(MessageHeaders.HDR_X_PRIORITY)) {
                set.add(MailField.PRIORITY);
            }
        }
        return set;
    }

    public static UIDSet[] toUIDSet(long[] uids) {
        ArrayList<UIDSet> sets = new ArrayList<UIDSet>(uids.length);
        for (int i = 0; i < uids.length; ++i) {
            long current = uids[i];
            UIDSet set = new UIDSet();
            set.start = current;
            ++i;
            while (i < uids.length) {
                long next = uids[i];
                if (next != current + 1L) {
                    --i;
                    break;
                }
                current = next;
                ++i;
            }
            set.end = current;
            sets.add(set);
        }
        if (sets.isEmpty()) {
            return null;
        }
        return sets.toArray(new UIDSet[sets.size()]);
    }

    public static FetchProfile getFetchProfile(MailField[] fields, boolean preferEnvelope) {
        return MimeStorageUtility.getFetchProfile(fields, null, preferEnvelope);
    }

    public static FetchProfile getFetchProfile(MailField[] fields, MailField sortField, boolean preferEnvelope) {
        return MimeStorageUtility.getFetchProfile(fields, null, sortField, preferEnvelope);
    }

    public static boolean isEnvelopeField(MailField field) {
        return ENV_FIELDS.contains((Object)field);
    }

    public static FetchProfile getFetchProfile(MailField[] fields, MailField[] searchFields, MailField sortField, boolean preferEnvelope) {
        return MimeStorageUtility.getFetchProfile(fields, null, searchFields, sortField, preferEnvelope);
    }

    public static FetchProfile getFetchProfile(MailField[] fields, String[] headerNames, MailField[] searchFields, MailField sortField, boolean preferEnvelope) {
        List<MailField> list = Arrays.asList(fields);
        EnumSet<MailField> fieldSet = list.isEmpty() ? EnumSet.noneOf(MailField.class) : EnumSet.copyOf(list);
        MailField[] arr = fieldSet.contains((Object)MailField.FULL) ? ENUM_SET_FULL.toArray(new MailField[ENUM_SET_FULL.size()]) : fields;
        EnumSet<MailField> set = EnumSet.noneOf(MailField.class);
        if (arr != null) {
            set.addAll(Arrays.asList(arr));
            arr = null;
        }
        if (searchFields != null) {
            set.addAll(Arrays.asList(searchFields));
        }
        if (sortField != null) {
            set.add(sortField);
        }
        Set<Object> names = null == headerNames ? Collections.emptySet() : new HashSet<HeaderName>(Arrays.asList(HeaderName.valuesOf(headerNames)));
        FetchProfile fetchProfile = new FetchProfile();
        if (preferEnvelope && set.removeAll(ENV_FIELDS)) {
            fetchProfile.add(FetchProfile.Item.ENVELOPE);
            names.removeAll(ENV_LIST);
        }
        if (!set.isEmpty()) {
            if (set.contains((Object)MailField.FROM)) {
                names.remove(HeaderName.valueOf("From"));
            }
            if (set.contains((Object)MailField.TO)) {
                names.remove(HeaderName.valueOf("To"));
            }
            if (set.contains((Object)MailField.CC)) {
                names.remove(HeaderName.valueOf("Cc"));
            }
            if (set.contains((Object)MailField.BCC)) {
                names.remove(HeaderName.valueOf("Bcc"));
            }
            if (set.contains((Object)MailField.SUBJECT)) {
                names.remove(HeaderName.valueOf("Subject"));
            }
            if (set.contains((Object)MailField.SENT_DATE)) {
                names.remove(HeaderName.valueOf("Date"));
            }
            if (set.contains((Object)MailField.DISPOSITION_NOTIFICATION_TO)) {
                names.remove(HeaderName.valueOf("Disposition-Notification-To"));
            }
            if (set.contains((Object)MailField.PRIORITY)) {
                names.remove(HeaderName.valueOf("X-Priority"));
                names.remove(HeaderName.valueOf("Importance"));
            }
            for (MailField mailField : set) {
                MimeStorageUtility.addFetchItem(fetchProfile, mailField);
            }
            for (HeaderName headerName : names) {
                fetchProfile.add(headerName.toString());
            }
        }
        return fetchProfile;
    }

    public static void addFetchItem(FetchProfile fp, MailField field) {
        if (MailField.COLOR_LABEL.equals((Object)field)) {
            if (!fp.contains(FetchProfile.Item.FLAGS)) {
                fp.add(FetchProfile.Item.FLAGS);
            }
            return;
        }
        FetchProfile.Item item = FIELD2ITEM.get((Object)field);
        if (null != item) {
            fp.add(item);
            return;
        }
        List<String> strings = FIELD2STRING.get((Object)field);
        if (null != strings) {
            for (String string : strings) {
                fp.add(string);
            }
        }
    }

    static {
        CACHE_FETCH_PROFILE.add(FetchProfile.Item.ENVELOPE);
        CACHE_FETCH_PROFILE.add(FetchProfile.Item.FLAGS);
        CACHE_FETCH_PROFILE.add(FetchProfile.Item.CONTENT_INFO);
        CACHE_FETCH_PROFILE.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        CACHE_FETCH_PROFILE.add(FetchProfile.Item.SIZE);
        CACHE_FETCH_PROFILE.add(MessageHeaders.HDR_IMPORTANCE);
        CACHE_FETCH_PROFILE.add(MessageHeaders.HDR_X_PRIORITY);
        Collection<MailField> fields = MimeStorageUtility.fetchProfile2MailListFields(CACHE_FETCH_PROFILE);
        fields.add(MailField.ACCOUNT_NAME);
        CACHE_FIELDS = fields;
        CACHE_FIELDS_ARR = CACHE_FIELDS.toArray(new MailField[CACHE_FIELDS.size()]);
        EnumSet<MailField> set = EnumSet.noneOf(MailField.class);
        set.add(MailField.FROM);
        set.add(MailField.TO);
        set.add(MailField.CC);
        set.add(MailField.BCC);
        set.add(MailField.SUBJECT);
        set.add(MailField.SENT_DATE);
        ENV_FIELDS = set;
        ENUM_SET_FULL = EnumSet.complementOf(EnumSet.of(MailField.BODY, MailField.FULL, MailField.ACCOUNT_NAME));
        ENV_LIST = Arrays.asList(HeaderName.valuesOf("From", "To", "Cc", "Bcc", "Subject", "Date", "ReplyTo"));
        EnumMap<MailField, Object> field2item = new EnumMap<MailField, Object>(MailField.class);
        field2item.put(MailField.HEADERS, IMAPFolder.FetchProfileItem.HEADERS);
        field2item.put(MailField.ID, UIDFolder.FetchProfileItem.UID);
        field2item.put(MailField.CONTENT_TYPE, FetchProfile.Item.CONTENT_INFO);
        field2item.put(MailField.SIZE, IMAPFolder.FetchProfileItem.SIZE);
        field2item.put(MailField.FLAGS, FetchProfile.Item.FLAGS);
        FIELD2ITEM = field2item;
        EnumMap<MailField, List<String>> field2string = new EnumMap<MailField, List<String>>(MailField.class);
        field2string.put(MailField.FROM, Collections.singletonList(MessageHeaders.HDR_FROM));
        field2string.put(MailField.TO, Collections.singletonList(MessageHeaders.HDR_TO));
        field2string.put(MailField.CC, Collections.singletonList(MessageHeaders.HDR_CC));
        field2string.put(MailField.BCC, Collections.singletonList(MessageHeaders.HDR_BCC));
        field2string.put(MailField.SUBJECT, Collections.singletonList(MessageHeaders.HDR_SUBJECT));
        field2string.put(MailField.SENT_DATE, Collections.singletonList(MessageHeaders.HDR_DATE));
        field2string.put(MailField.DISPOSITION_NOTIFICATION_TO, Collections.singletonList(MessageHeaders.HDR_DISP_NOT_TO));
        field2string.put(MailField.PRIORITY, Arrays.asList(MessageHeaders.HDR_IMPORTANCE, MessageHeaders.HDR_X_PRIORITY));
        FIELD2STRING = field2string;
    }
}

