/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ManagedMimeMessage;
import com.openexchange.mail.mime.MimeCleanUp;
import com.openexchange.mail.mime.dataobjects.MimeMailPart;
import com.openexchange.mail.mime.dataobjects.MimeRawSource;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.slf4j.LoggerFactory;

public final class MimeMailMessage
extends MailMessage
implements MimeRawSource,
MimeCleanUp {
    private static final long serialVersionUID = 4593386724062676753L;
    private MimeMailPart mailPart;
    private String id;
    private int unreadMessages;
    private char separator;
    private int seqnum;

    public MimeMailMessage() {
        this.mailPart = new MimeMailPart();
    }

    public MimeMailMessage(MimeMessage msg) throws OXException {
        this.mailPart = new MimeMailPart((Part)msg);
    }

    @Override
    public Part getPart() {
        return this.mailPart.getPart();
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public int getSeqnum() {
        return this.seqnum;
    }

    public void setSeqnum(int seqnum) {
        this.seqnum = seqnum;
    }

    public void setContent(MimeMessage msg) throws OXException {
        this.mailPart = msg == null ? new MimeMailPart((Part)null) : new MimeMailPart((Part)msg);
    }

    public MimeMessage getMimeMessage() {
        return (MimeMessage)this.mailPart.getPart();
    }

    @Override
    public void cleanUp() {
        MimeMessage mimeMessage = this.getMimeMessage();
        if (mimeMessage instanceof ManagedMimeMessage) {
            try {
                ((ManagedMimeMessage)mimeMessage).cleanUp();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(MimeMailMessage.class).warn("Couldn't clean-up MIME resource.", (Throwable)e);
            }
        }
    }

    @Override
    public String getMailId() {
        return this.id;
    }

    @Override
    public void setMailId(String id) {
        this.id = id;
    }

    @Override
    public Object getContent() throws OXException {
        return this.mailPart.getContent();
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return this.mailPart.getDataHandler();
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return this.mailPart.getEnclosedCount();
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return this.mailPart.getEnclosedMailPart(index);
    }

    @Override
    public InputStream getRawInputStream() throws OXException {
        return this.mailPart.getRawInputStream();
    }

    @Override
    public InputStream getInputStream() throws OXException {
        return this.mailPart.getInputStream();
    }

    @Override
    public void writeTo(OutputStream out) throws OXException {
        this.mailPart.writeTo(out);
    }

    @Override
    public void loadContent() throws OXException {
        this.mailPart.loadContent();
    }

    @Override
    public void prepareForCaching() {
        this.mailPart.prepareForCaching();
    }

    @Override
    public void setUnreadMessages(int unreadMessages) {
        this.unreadMessages = unreadMessages;
    }

    @Override
    public int getUnreadMessages() {
        return this.unreadMessages;
    }

    public String toString() {
        String folder;
        StringBuilder builder = new StringBuilder(32);
        builder.append("MimeMailMessage [");
        String id = this.getMailId();
        if (id != null) {
            builder.append("id=").append(id).append(", ");
        }
        if ((folder = this.getFolder()) != null) {
            builder.append("folder=").append(folder);
        }
        builder.append(']');
        return builder.toString();
    }
}

