/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.java.Charsets;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.compose.CompositionSpace;
import com.openexchange.mail.compose.CompositionSpaces;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.ContentAwareComposedMailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.parser.MessageParser;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.MtaStatusInfo;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.PUT, name="new", description="Send/Save mail as MIME data block (RFC822) (added in SP5)", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", optional=true, description="In case the mail should not be sent out, but saved in a specific folder, the \"folder\" parameter can be used. If the mail should be sent out to the recipient, the \"folder\" parameter must not be included and the mail is stored in the folder \"Sent Items\". Example \"folder=default.INBOX/Testfolder\""), @Parameter(name="flags", optional=true, description="In case the mail should be stored with status \"read\" (e.g. mail has been read already in the client inbox), the parameter \"flags\" has to be included. If no \"folder\" parameter is specified, this parameter must not be included. For infos about mail flags see Detailed mail data spec.")}, requestBody="The MIME Data Block.", responseDescription="Object ID of the newly created/moved mail.")
public final class NewAction
extends AbstractMailAction {
    private static final Logger LOG = LoggerFactory.getLogger(NewAction.class);
    private static final String FLAGS = MailJSONField.FLAGS.getKey();
    private static final String FROM = MailJSONField.FROM.getKey();
    private static final String UPLOAD_FORMFIELD_MAIL = "json_0";
    private final EnumSet<ComposeType> draftTypes = EnumSet.of(ComposeType.DRAFT, ComposeType.DRAFT_DELETE_ON_TRANSPORT, ComposeType.DRAFT_EDIT, ComposeType.DRAFT_NO_DELETE_ON_TRANSPORT);

    public NewAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        AJAXRequestData request = req.getRequest();
        ArrayList<OXException> warnings = new ArrayList<OXException>();
        try {
            long maxFileSize;
            long maxSize;
            if (TransportProperties.getInstance().isPublishOnExceededQuota() && req.getSession().getUserPermissionBits().hasInfostore()) {
                maxSize = -1L;
                maxFileSize = -1L;
            } else {
                UserSettingMail usm = req.getSession().getUserSettingMail();
                maxFileSize = usm.getUploadQuotaPerFile();
                if (maxFileSize <= 0L) {
                    maxFileSize = -1L;
                }
                if ((maxSize = usm.getUploadQuota()) <= 0L) {
                    if (maxSize == 0L) {
                        maxSize = -1L;
                    } else {
                        int globalQuota;
                        LOG.debug("Upload quota is less than zero. Using global server property \"MAX_UPLOAD_SIZE\" instead.");
                        try {
                            globalQuota = ServerConfig.getInt(ServerConfig.Property.MAX_UPLOAD_SIZE);
                        }
                        catch (OXException e) {
                            LOG.error("", (Throwable)e);
                            globalQuota = 0;
                        }
                        long l = maxSize = globalQuota <= 0 ? -1L : (long)globalQuota;
                    }
                }
            }
            if (request.hasUploads(maxFileSize, maxSize) || request.getParameter(UPLOAD_FORMFIELD_MAIL) != null) {
                return this.performWithUploads(req, request, warnings);
            }
            return this.performWithoutUploads(req, warnings);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private AJAXRequestResult performWithUploads(MailRequest req, AJAXRequestData request, List<OXException> warnings) throws OXException, JSONException {
        AJAXRequestResult result;
        int accountId;
        InternetAddress from;
        ServerSession session = req.getSession();
        String csid = req.getParameter("csid");
        UploadEvent uploadEvent = request.getUploadEvent();
        String msgIdentifier = null;
        UserSettingMail userSettingMail = null;
        String json0 = uploadEvent.getFormField(UPLOAD_FORMFIELD_MAIL);
        if (json0 == null || json0.trim().length() == 0) {
            throw MailExceptionCode.PROCESSING_ERROR.create(MailExceptionCode.MISSING_PARAM.create(UPLOAD_FORMFIELD_MAIL), new Object[0]);
        }
        JSONObject jMail = new JSONObject(json0);
        if (null == csid) {
            csid = jMail.optString("csid", null);
        }
        try {
            InternetAddress[] fromAddresses = MessageParser.parseAddressKey(FROM, jMail, true);
            from = null == fromAddresses || 0 == fromAddresses.length ? null : fromAddresses[0];
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
        try {
            accountId = NewAction.resolveFrom2Account(session, from, true, true);
        }
        catch (OXException e) {
            if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e) || MailExceptionCode.INVALID_SENDER.equals(e)) {
                throw e;
            }
            LOG.warn("{}. Using default account's transport.", (Object)e.getMessage());
            accountId = 0;
        }
        MailServletInterface mailInterface = this.getMailInterface(req);
        if ((jMail.optInt(FLAGS, 0) & 4) > 0) {
            ComposeType sendType;
            ComposedMailMessage composedMail = MessageParser.parse4Draft(jMail, uploadEvent, session, accountId, warnings);
            MailPath msgref = composedMail.getMsgref();
            ComposeType composeType = sendType = jMail.hasAndNotNull("sendtype") ? ComposeType.getType(jMail.getInt("sendtype")) : null;
            if (null != sendType) {
                composedMail.setSendType(sendType);
            }
            if ((msgIdentifier = mailInterface.saveDraft(composedMail, false, accountId).toString()) == null) {
                throw MailExceptionCode.DRAFT_FAILED_UNKNOWN.create();
            }
            if (null != csid) {
                if (null != msgref && ComposeType.DRAFT_EDIT.equals((Object)sendType)) {
                    CompositionSpace space = CompositionSpace.getCompositionSpace(csid, session);
                    space.addCleanUp(msgref);
                }
                CompositionSpaces.applyCompositionSpace(csid, session, mailInterface.getMailAccess());
                CompositionSpaces.destroy(csid, (Session)session);
            }
            warnings.addAll(mailInterface.getWarnings());
        } else {
            String sCopy2Sent;
            String protocol = request.isSecure() ? "https://" : "http://";
            ComposedMailMessage[] composedMails = MessageParser.parse4Transport(jMail, uploadEvent, session, accountId, protocol, request.getHostname(), warnings);
            ComposeType sendType = jMail.hasAndNotNull("sendtype") ? ComposeType.getType(jMail.getInt("sendtype")) : ComposeType.NEW;
            String folder = req.getParameter("folder");
            if (null != folder) {
                MailTransport mailTransport = MailTransport.getInstance(session, accountId);
                MailMessage mm = mailTransport.sendMailMessage(composedMails[0], sendType, new Address[]{MimeMessageUtility.POISON_ADDRESS});
                mailInterface.openFor(folder);
                if (null != csid) {
                    CompositionSpaces.applyCompositionSpace(csid, session, mailInterface.getMailAccess());
                    CompositionSpaces.destroy(csid, (Session)session);
                }
                String[] ids = mailInterface.appendMessages(folder, new MailMessage[]{mm}, false);
                msgIdentifier = ids[0];
                mailInterface.updateMessageFlags(folder, ids, 32, true);
                JSONObject responseObj = new JSONObject(2);
                responseObj.put("folder_id", (Object)folder);
                responseObj.put("id", (Object)ids[0]);
                AJAXRequestResult result2 = new AJAXRequestResult((Object)responseObj, "json");
                return result2;
            }
            if (this.draftTypes.contains((Object)sendType)) {
                for (ComposedMailMessage cm : composedMails) {
                    if (null == cm) continue;
                    cm.removeHeader("Message-ID");
                    cm.removeMessageId();
                }
            }
            if (ComposeType.DRAFT.equals((Object)sendType)) {
                String sDeleteDraftOnTransport;
                String paramName = "deleteDraftOnTransport";
                if (jMail.hasAndNotNull("deleteDraftOnTransport")) {
                    Object object = jMail.opt("deleteDraftOnTransport");
                    if (null != object && AJAXRequestDataTools.parseBoolParameter(object.toString())) {
                        sendType = ComposeType.DRAFT_DELETE_ON_TRANSPORT;
                    }
                } else if (request.containsParameter("deleteDraftOnTransport") && null != (sDeleteDraftOnTransport = request.getParameter("deleteDraftOnTransport")) && AJAXRequestDataTools.parseBoolParameter(sDeleteDraftOnTransport)) {
                    sendType = ComposeType.DRAFT_DELETE_ON_TRANSPORT;
                }
            } else if (ComposeType.DRAFT.equals((Object)sendType)) {
                // empty if block
            }
            for (ComposedMailMessage cm : composedMails) {
                if (null == cm) continue;
                cm.setSendType(sendType);
            }
            UserSettingMail usm = session.getUserSettingMail();
            usm.setNoSave(true);
            String paramName = "copy2Sent";
            if (jMail.hasAndNotNull("copy2Sent")) {
                Object object = jMail.opt("copy2Sent");
                if (null != object) {
                    if (AJAXRequestDataTools.parseBoolParameter(object.toString())) {
                        usm.setNoCopyIntoStandardSentFolder(false);
                    } else if (Boolean.FALSE.equals(AJAXRequestDataTools.parseFalseBoolParameter(object.toString()))) {
                        usm.setNoCopyIntoStandardSentFolder(true);
                    }
                }
            } else if (request.containsParameter("copy2Sent") && null != (sCopy2Sent = request.getParameter("copy2Sent"))) {
                if (AJAXRequestDataTools.parseBoolParameter(sCopy2Sent)) {
                    usm.setNoCopyIntoStandardSentFolder(false);
                } else if (Boolean.FALSE.equals(AJAXRequestDataTools.parseFalseBoolParameter(sCopy2Sent))) {
                    usm.setNoCopyIntoStandardSentFolder(true);
                }
            }
            userSettingMail = usm;
            msgIdentifier = mailInterface.sendMessage(composedMails[0], sendType, accountId, usm, new MtaStatusInfo());
            for (int i = 1; i < composedMails.length; ++i) {
                ComposedMailMessage cm = composedMails[i];
                if (null == cm) continue;
                mailInterface.sendMessage(cm, sendType, accountId, usm);
            }
            if (null != csid) {
                CompositionSpaces.applyCompositionSpace(csid, session, null);
                CompositionSpaces.destroy(csid, (Session)session);
            }
            warnings.addAll(mailInterface.getWarnings());
            try {
                ServerUserSetting setting = ServerUserSetting.getInstance();
                int contextId = session.getContextId();
                int userId = session.getUserId();
                if (setting.isContactCollectOnMailTransport(contextId, userId).booleanValue()) {
                    NewAction.triggerContactCollector(session, composedMails[0]);
                }
            }
            catch (Exception e) {
                LOG.warn("Contact collector could not be triggered.", (Throwable)e);
            }
        }
        if (msgIdentifier == null) {
            if (null != userSettingMail && userSettingMail.isNoCopyIntoStandardSentFolder()) {
                result = new AJAXRequestResult(JSONObject.NULL, "json");
                result.addWarnings(warnings);
                return result;
            }
            if (warnings.isEmpty()) {
                throw MailExceptionCode.SEND_FAILED_UNKNOWN.create();
            }
            result = new AJAXRequestResult(JSONObject.NULL, "json");
            result.addWarnings(warnings);
            return result;
        }
        result = new AJAXRequestResult((Object)msgIdentifier, "string");
        result.addWarnings(warnings);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult performWithoutUploads(MailRequest req, List<OXException> warnings) throws OXException, MessagingException, JSONException {
        JSONObject responseData;
        MailMessage mail;
        QuotedInternetAddress fromAddress;
        ServerSession session = req.getSession();
        String folder = req.getParameter("folder");
        int i = req.optInt("flags");
        int flags = -9999 == i ? 0 : i;
        String tmp = req.getParameter("force");
        boolean force = null == tmp ? false : AJAXRequestDataTools.parseBoolParameter(tmp);
        QuotedInternetAddress defaultSendAddr = new QuotedInternetAddress(NewAction.getDefaultSendAddress(session), false);
        MimeMessage message = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new UnsynchronizedByteArrayInputStream(Charsets.toAsciiBytes((String)((String)req.getRequest().requireData()))));
        message.removeHeader("x-original-headers");
        String fromAddr = message.getHeader(MessageHeaders.HDR_FROM, null);
        if (NewAction.isEmpty(fromAddr)) {
            fromAddress = defaultSendAddr;
            message.setFrom((Address)fromAddress);
            mail = MimeMessageConverter.convertMessage(message);
        } else {
            fromAddress = new QuotedInternetAddress(fromAddr, true);
            mail = MimeMessageConverter.convertMessage(message);
        }
        PutNewMailData data = new PutNewMailData(){

            @Override
            public MailMessage getMail() {
                return mail;
            }

            @Override
            public InternetAddress getFromAddress() {
                return fromAddress;
            }
        };
        if (folder == null) {
            responseData = this.transportMessage(session, flags, force, data.getFromAddress(), data.getMail());
        } else {
            String[] ids;
            MailServletInterface mailInterface = MailServletInterface.getInstance(session);
            try {
                ids = mailInterface.appendMessages(folder, new MailMessage[]{data.getMail()}, force);
                if (flags > 0) {
                    mailInterface.updateMessageFlags(folder, ids, flags, true);
                }
            }
            finally {
                mailInterface.close(true);
            }
            JSONObject responseObj = new JSONObject();
            responseObj.put("folder_id", (Object)folder);
            responseObj.put("id", (Object)ids[0]);
            responseData = responseObj;
        }
        AJAXRequestResult result = new AJAXRequestResult((Object)responseData, "json");
        result.addWarnings(warnings);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject transportMessage(ServerSession session, int flags, boolean force, InternetAddress from, MailMessage m) throws OXException, JSONException {
        int accId;
        try {
            accId = NewAction.resolveFrom2Account(session, from, true, !force);
        }
        catch (OXException e) {
            if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e)) {
                throw e;
            }
            if (!force && MailExceptionCode.INVALID_SENDER.equals(e)) {
                throw e;
            }
            LOG.warn("{}. Using default account's transport.", (Object)e.getMessage());
            accId = 0;
        }
        int accountId = accId;
        MailTransport transport = MailTransport.getInstance(session, accountId);
        try {
            MailMessage sentMail = m instanceof MimeMailMessage ? transport.sendMailMessage(new ContentAwareComposedMailMessage(((MimeMailMessage)m).getMimeMessage(), session, null), ComposeType.NEW) : transport.sendRawMessage(m.getSourceBytes());
            JSONObject responseData = null;
            if (!session.getUserSettingMail().isNoCopyIntoStandardSentFolder()) {
                MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
                try {
                    String[] uidArr;
                    mailAccess = MailAccess.getInstance(session, accountId);
                    mailAccess.connect();
                    String sentFullname = MailFolderUtility.prepareMailFolderParam(mailAccess.getFolderStorage().getSentFolder()).getFullname();
                    try {
                        if (flags != -9999) {
                            sentMail.setFlags(flags);
                        }
                        uidArr = mailAccess.getMessageStorage().appendMessages(sentFullname, new MailMessage[]{sentMail});
                        try {
                            MailMessageCache.getInstance().removeFolderMessages(accountId, sentFullname, session.getUserId(), session.getContext().getContextId());
                        }
                        catch (OXException e) {
                            LOG.error("", (Throwable)e);
                        }
                    }
                    catch (OXException e) {
                        if (e.getMessage().indexOf("quota") != -1) {
                            throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED_QUOTA.create(e, new Object[0]);
                        }
                        throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED.create(e, new Object[0]);
                    }
                    if (uidArr != null && uidArr[0] != null) {
                        mailAccess.getMessageStorage().updateMessageFlags(sentFullname, uidArr, 32, true);
                    }
                    responseData = new JSONObject(2);
                    responseData.put("folder_id", (Object)MailFolderUtility.prepareFullname(0, sentFullname));
                    responseData.put("id", (Object)uidArr[0]);
                }
                finally {
                    if (null != mailAccess) {
                        mailAccess.close(true);
                    }
                }
            }
            JSONObject jSONObject = responseData;
            return jSONObject;
        }
        finally {
            transport.close();
        }
    }

    private static interface PutNewMailData {
        public InternetAddress getFromAddress();

        public MailMessage getMail();
    }
}

