/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.java.Reference;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractArchiveMailAction;
import com.openexchange.mail.permission.DefaultMailPermission;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="archive", description="Moves mails to archive folder", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested mail."), @Parameter(name="folder", description="Object ID of the source folder.")}, requestBody="A JSON object containing the id of the destination folder inside the \"folder_id\" field: e.g.: {\"folder_id\": 1376}.", responseDescription="A JSON true response.")
public final class ArchiveAction
extends AbstractArchiveMailAction {
    public ArchiveAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected AJAXRequestResult perform(final MailRequest req) throws OXException {
        try {
            final ServerSession session = req.getSession();
            MailAccountStorageService service = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
            if (null == service) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{MailAccountStorageService.class.getName()});
            }
            JSONArray jArray = (JSONArray)req.getRequest().getData();
            if (null == jArray) {
                throw AjaxExceptionCodes.MISSING_REQUEST_BODY.create();
            }
            String sourceFolder = req.getParameter("folder");
            if (null == sourceFolder) {
                TIntObjectHashMap m = new TIntObjectHashMap(2);
                int length = jArray.length();
                int i = 0;
                while (true) {
                    String fullName;
                    LinkedList<String> list;
                    if (i >= length) {
                        final Reference exceptionRef = new Reference();
                        final Calendar cal = Calendar.getInstance(TimeZoneUtils.getTimeZone("UTC"));
                        m.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Map<String, List<String>>>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public boolean execute(int accountId, Map<String, List<String>> mapping) {
                                boolean proceed = false;
                                MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
                                try {
                                    mailAccess = MailAccess.getInstance(session, accountId);
                                    mailAccess.connect();
                                    int[] separatorRef = new int[1];
                                    String archiveFullname = ArchiveAction.this.checkArchiveFullNameFor(mailAccess, req, separatorRef);
                                    char separator = (char)separatorRef[0];
                                    for (Map.Entry<String, List<String>> mappingEntry : mapping.entrySet()) {
                                        String fullName = mappingEntry.getKey();
                                        if (fullName.equals(archiveFullname) || fullName.startsWith(archiveFullname + separator)) continue;
                                        List<String> mailIds = mappingEntry.getValue();
                                        MailMessage[] msgs = mailAccess.getMessageStorage().getMessages(fullName, mailIds.toArray(new String[mailIds.size()]), new MailField[]{MailField.ID, MailField.RECEIVED_DATE});
                                        if (null == msgs || msgs.length <= 0) {
                                            boolean bl = true;
                                            return bl;
                                        }
                                        ArchiveAction.this.move2Archive(msgs, fullName, archiveFullname, separator, cal, mailAccess);
                                    }
                                    proceed = true;
                                }
                                catch (Exception e) {
                                    exceptionRef.setValue((Object)e);
                                }
                                finally {
                                    if (null != mailAccess) {
                                        mailAccess.close(true);
                                    }
                                }
                                return proceed;
                            }
                        });
                        return new AJAXRequestResult((Object)Boolean.TRUE, "native");
                    }
                    JSONObject jObject = jArray.getJSONObject(i);
                    String folder = jObject.getString("folder");
                    String id = jObject.getString("id");
                    FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(folder);
                    int accountId2 = fa.getAccountId();
                    HashMap<String, LinkedList<String>> map = (HashMap<String, LinkedList<String>>)m.get(accountId2);
                    if (null == map) {
                        map = new HashMap<String, LinkedList<String>>();
                        m.put(accountId2, map);
                    }
                    if (null == (list = (LinkedList<String>)map.get(fullName = fa.getFullname()))) {
                        list = new LinkedList<String>();
                        map.put(fullName, list);
                    }
                    list.add(id);
                    ++i;
                }
            }
            FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(sourceFolder);
            int accountId = fa.getAccountId();
            MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
            try {
                mailAccess = MailAccess.getInstance(session, accountId);
                mailAccess.connect();
                int[] separatorRef = new int[1];
                String archiveFullname = this.checkArchiveFullNameFor(mailAccess, req, separatorRef);
                char separator = (char)separatorRef[0];
                String fullName = fa.getFullname();
                if (fullName.equals(archiveFullname) || fullName.startsWith(archiveFullname + separator)) {
                    AJAXRequestResult accountId2 = new AJAXRequestResult((Object)Boolean.TRUE, "native");
                    return accountId2;
                }
                int length = jArray.length();
                String[] mailIds = new String[length];
                for (int i = 0; i < length; ++i) {
                    mailIds[i] = jArray.getString(i);
                }
                String fullName2 = fa.getFullname();
                MailMessage[] msgs = mailAccess.getMessageStorage().getMessages(fullName2, mailIds, new MailField[]{MailField.ID, MailField.RECEIVED_DATE});
                if (null == msgs || msgs.length <= 0) {
                    AJAXRequestResult aJAXRequestResult = new AJAXRequestResult((Object)Boolean.TRUE, "native");
                    return aJAXRequestResult;
                }
                this.move2Archive(msgs, fullName2, archiveFullname, separator, mailAccess);
                return new AJAXRequestResult((Object)Boolean.TRUE, "native");
            }
            finally {
                if (null != mailAccess) {
                    mailAccess.close(true);
                }
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    protected void move2Archive(MailMessage[] msgs, String fullName, String archiveFullname, char separator, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws OXException {
        Calendar cal = Calendar.getInstance(TimeZoneUtils.getTimeZone("UTC"));
        this.move2Archive(msgs, fullName, archiveFullname, separator, cal, mailAccess);
    }

    protected void move2Archive(MailMessage[] msgs, String fullName, String archiveFullname, char separator, Calendar cal, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws OXException {
        List ids;
        HashMap<Integer, LinkedList<String>> map = new HashMap<Integer, LinkedList<String>>(4);
        for (MailMessage mailMessage : msgs) {
            Date receivedDate = mailMessage.getReceivedDate();
            cal.setTime(receivedDate);
            Integer year = cal.get(1);
            ids = (LinkedList<String>)map.get(year);
            if (null == ids) {
                ids = new LinkedList<String>();
                map.put(year, (LinkedList<String>)ids);
            }
            ids.add(mailMessage.getMailId());
        }
        int accountId = mailAccess.getAccountId();
        Session session = mailAccess.getSession();
        for (Map.Entry entry : map.entrySet()) {
            String sYear = ((Integer)entry.getKey()).toString();
            String fn = archiveFullname + separator + sYear;
            if (!mailAccess.getFolderStorage().exists(fn)) {
                MailFolderDescription toCreate = new MailFolderDescription();
                toCreate.setAccountId(accountId);
                toCreate.setParentAccountId(accountId);
                toCreate.setParentFullname(archiveFullname);
                toCreate.setExists(false);
                toCreate.setFullname(fn);
                toCreate.setName(sYear);
                toCreate.setSeparator(separator);
                DefaultMailPermission mp = new DefaultMailPermission();
                mp.setEntity(session.getUserId());
                int p = 128;
                mp.setAllPermission(128, 128, 128, 128);
                mp.setFolderAdmin(true);
                mp.setGroupPermission(false);
                toCreate.addPermission(mp);
                mailAccess.getFolderStorage().createFolder(toCreate);
                CacheFolderStorage.getInstance().removeFromCache(archiveFullname, "0", true, session);
            }
            ids = (List)entry.getValue();
            mailAccess.getMessageStorage().moveMessages(fullName, fn, ids.toArray(new String[ids.size()]), true);
        }
    }
}

