/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.attachment;

import com.openexchange.exception.OXException;
import com.openexchange.java.util.UUIDs;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.attachment.AttachmentTokenConstants;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import java.io.Closeable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public final class AttachmentToken
implements AttachmentTokenConstants,
Closeable {
    private final String id;
    private final long ttlMillis;
    private final AtomicLong timeoutStamp;
    private int contextId;
    private int userId;
    private int accountId;
    private String mailId;
    private String attachmentId;
    private String fullName;
    private MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess;
    private String sessionId;
    private String clientIp;
    private String client;
    private String userAgent;
    private String jsessionId;
    private boolean oneTime;
    private boolean checkIp;

    public AttachmentToken(long ttlMillis) {
        if (ttlMillis <= 0L) {
            throw new IllegalArgumentException("ttlMillis must be positive.");
        }
        this.id = new StringBuilder(75).append(UUIDs.getUnformattedString((UUID)UUID.randomUUID())).append('.').append(UUIDs.getUnformattedString((UUID)UUID.randomUUID())).toString();
        this.ttlMillis = ttlMillis;
        this.timeoutStamp = new AtomicLong(System.currentTimeMillis() + ttlMillis);
    }

    public AttachmentToken setOneTime(boolean oneTime) {
        this.oneTime = oneTime;
        return this;
    }

    public boolean isOneTime() {
        return this.oneTime;
    }

    public boolean isCheckIp() {
        return this.checkIp;
    }

    public AttachmentToken setCheckIp(boolean checkIp) {
        this.checkIp = checkIp;
        return this;
    }

    public String getJSessionId() {
        return this.jsessionId;
    }

    public AttachmentToken setAccessInfo(int accountId, Session session) {
        this.accountId = accountId;
        this.jsessionId = (String)session.getParameter("JSESSIONID");
        this.contextId = session.getContextId();
        this.userId = session.getUserId();
        this.sessionId = session.getSessionID();
        this.clientIp = session.getLocalIp();
        this.client = session.getClient();
        this.userAgent = (String)session.getParameter("user-agent");
        return this;
    }

    public AttachmentToken setAttachmentInfo(String fullName, String mailId, String attachmentId) {
        this.fullName = fullName;
        this.mailId = mailId;
        this.attachmentId = attachmentId;
        return this;
    }

    public AttachmentToken touch() {
        long cur;
        while (!this.timeoutStamp.compareAndSet(cur = this.timeoutStamp.get(), System.currentTimeMillis() + this.ttlMillis)) {
        }
        return this;
    }

    public String getId() {
        return this.id;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.timeoutStamp.get();
    }

    public MailPart getAttachment() throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = MailAccess.getInstance(this.userId, this.contextId, this.accountId);
        this.mailAccess = mailAccess;
        mailAccess.connect();
        return mailAccess.getMessageStorage().getAttachment(MailFolderUtility.prepareMailFolderParam(this.fullName).getFullname(), this.mailId, this.attachmentId);
    }

    @Override
    public void close() {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = this.mailAccess;
        if (null != mailAccess) {
            mailAccess.close(true);
            this.mailAccess = null;
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getClient() {
        return this.client;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getContextId() {
        return this.contextId;
    }

    public int getUserId() {
        return this.userId;
    }
}

