/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.mail.MailField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public final class MailFields {
    private static final MailField[] VALUES = MailField.values();
    private final boolean[] arr = new boolean[VALUES.length];

    public static MailField[] addIfAbsent(MailField[] fields, MailField ... toAdd) {
        if (null == fields) {
            return null;
        }
        MailFields mailFields = new MailFields(fields);
        boolean changed = false;
        if (null != toAdd) {
            for (MailField mailField : toAdd) {
                if (mailField == null || mailFields.arr[mailField.ordinal()]) continue;
                mailFields.arr[mailField.ordinal()] = true;
                changed = true;
            }
        }
        return changed ? mailFields.toArray() : fields;
    }

    public static MailField[] toArray(MailField ... fields) {
        if (null == fields) {
            return null;
        }
        return new MailFields(fields).toArray();
    }

    public static MailFields valueOf(int[] columns) {
        return null == columns ? new MailFields() : new MailFields(MailField.getFields(columns));
    }

    public MailFields() {
        Arrays.fill(this.arr, false);
    }

    public MailFields(boolean initValue) {
        Arrays.fill(this.arr, initValue);
    }

    public MailFields(MailField mailField, MailField ... mailFields) {
        this();
        if (null != mailField) {
            this.arr[mailField.ordinal()] = true;
        }
        if (null != mailFields) {
            for (MailField mf : mailFields) {
                if (null == mf) continue;
                this.arr[mf.ordinal()] = true;
            }
        }
    }

    public MailFields(MailField[] mailFields) {
        this();
        if (null != mailFields) {
            for (MailField mailField : mailFields) {
                if (null == mailField) continue;
                this.arr[mailField.ordinal()] = true;
            }
        }
    }

    public MailFields(Collection<MailField> mailFields) {
        this();
        if (null != mailFields) {
            for (MailField mailField : mailFields) {
                if (null == mailField) continue;
                this.arr[mailField.ordinal()] = true;
            }
        }
    }

    public MailFields(MailFields mailFields) {
        if (null != mailFields) {
            System.arraycopy(mailFields.arr, 0, this.arr, 0, this.arr.length);
        }
    }

    public String toString() {
        return Arrays.toString((Object[])this.toArray());
    }

    public int size() {
        int size = 0;
        int i = this.arr.length;
        while (i-- > 0) {
            if (!this.arr[i]) continue;
            ++size;
        }
        return size;
    }

    public MailFields add(MailField mailField) {
        if (mailField != null) {
            this.arr[mailField.ordinal()] = true;
        }
        return this;
    }

    public void addAll(MailField[] mailFields) {
        if (mailFields != null) {
            for (MailField mailField : mailFields) {
                this.arr[mailField.ordinal()] = true;
            }
        }
    }

    public void addAll(Collection<MailField> mailFields) {
        if (mailFields != null) {
            for (MailField mailField : mailFields) {
                this.arr[mailField.ordinal()] = true;
            }
        }
    }

    public void removeMailField(MailField mailField) {
        if (mailField != null) {
            this.arr[mailField.ordinal()] = false;
        }
    }

    public void removeMailFields(MailField[] mailFields) {
        if (mailFields != null) {
            for (MailField mailField : mailFields) {
                this.arr[mailField.ordinal()] = false;
            }
        }
    }

    public boolean contains(MailField mailField) {
        return null != mailField && this.arr[mailField.ordinal()];
    }

    public boolean containsAny(MailFields mailFields) {
        if (mailFields == null) {
            return false;
        }
        boolean[] otherArr = mailFields.arr;
        int i = otherArr.length;
        while (i-- > 0) {
            if (!otherArr[i] || !this.arr[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(MailFields mailFields) {
        if (mailFields == null) {
            return false;
        }
        boolean[] otherArr = mailFields.arr;
        int i = otherArr.length;
        while (i-- > 0) {
            if (!otherArr[i] || this.arr[i]) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(MailFields otherFields) {
        if (otherFields == null) {
            return false;
        }
        boolean[] otherArr = otherFields.arr;
        boolean retval = false;
        int i = otherArr.length;
        while (i-- > 0) {
            if (!otherArr[i] || !this.arr[i]) continue;
            this.arr[i] = false;
            retval = true;
        }
        return retval;
    }

    public boolean retainAll(MailFields otherFields) {
        if (otherFields == null) {
            return false;
        }
        boolean[] otherArr = otherFields.arr;
        boolean retval = false;
        int i = otherArr.length;
        while (i-- > 0) {
            if (otherArr[i] || !this.arr[i]) continue;
            this.arr[i] = false;
            retval = true;
        }
        return retval;
    }

    public boolean isEmpty() {
        boolean retval = true;
        int i = this.arr.length;
        while (retval && i-- > 0) {
            retval = !this.arr[i];
        }
        return retval;
    }

    public MailField[] toArray() {
        ArrayList<MailField> l = new ArrayList<MailField>(this.arr.length);
        int i = this.arr.length;
        while (i-- > 0) {
            if (!this.arr[i]) continue;
            l.add(VALUES[i]);
        }
        return l.toArray(new MailField[l.size()]);
    }

    public Set<MailField> toSet() {
        EnumSet<MailField> set = EnumSet.noneOf(MailField.class);
        int i = this.arr.length;
        while (i-- > 0) {
            if (!this.arr[i]) continue;
            set.add(VALUES[i]);
        }
        return set;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.arr);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailFields)) {
            return false;
        }
        MailFields other = (MailFields)obj;
        return Arrays.equals(this.arr, other.arr);
    }
}

