/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.image;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.converters.cover.Mp3CoverExtractor;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.image.ImageUtility;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import org.jaudiotagger.tag.mp4.field.Mp4TagCoverField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Mp3ImageDataSource
implements ImageDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(Mp3ImageDataSource.class);
    private static final Mp3ImageDataSource INSTANCE = new Mp3ImageDataSource();
    private static final String[] ARGS = new String[]{"com.openexchange.file.storage.folder", "com.openexchange.file.storage.id"};
    private static final String REGISTRATION_NAME = "com.openexchange.file.storage.mp3Cover";
    private static final String ALIAS = "/file/mp3Cover";

    public static Mp3ImageDataSource getInstance() {
        return INSTANCE;
    }

    private Mp3ImageDataSource() {
    }

    public <D> Data<D> getData(Class<? extends D> type, DataArguments dataArguments, Session session) throws OXException {
        if (!InputStream.class.equals(type)) {
            throw DataExceptionCodes.TYPE_NOT_SUPPORTED.create(new Object[]{type.getName()});
        }
        String val = dataArguments.get(ARGS[0]);
        if (val == null) {
            throw DataExceptionCodes.MISSING_ARGUMENT.create(new Object[]{ARGS[0]});
        }
        String folderId = val.toString();
        String val2 = dataArguments.get(ARGS[1]);
        if (val2 == null) {
            throw DataExceptionCodes.MISSING_ARGUMENT.create(new Object[]{ARGS[1]});
        }
        String fileId = val2.toString();
        String mimeType = null;
        byte[] imageBytes = null;
        ManagedFile managedFile = Mp3ImageDataSource.optData(fileId, folderId, ServerSessionAdapter.valueOf(session), ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class));
        try {
            File tmpFile = managedFile.getFile();
            if (Mp3CoverExtractor.isMp3(managedFile.getContentType()) || Mp3CoverExtractor.isMp3FileExt(managedFile.getFileName())) {
                MP3File mp3 = new MP3File(tmpFile, 4, true);
                AbstractID3v2Tag id3v2Tag = mp3.getID3v2Tag();
                if (null == id3v2Tag) {
                    LOG.warn("Extracting cover image from MP3 failed. Missing ID3v2 tag.");
                } else {
                    TagField imageField = id3v2Tag.getFirstField(FieldKey.COVER_ART);
                    if (imageField instanceof AbstractID3v2Frame) {
                        AbstractTagFrameBody body = ((AbstractID3v2Frame)imageField).getBody();
                        if (body instanceof FrameBodyAPIC) {
                            FrameBodyAPIC imageFrameBody = (FrameBodyAPIC)body;
                            if (!imageFrameBody.isImageUrl()) {
                                imageBytes = (byte[])this.getObjectValue("PictureData", (AbstractTagFrameBody)imageFrameBody);
                                mimeType = (String)this.getObjectValue("MIMEType", (AbstractTagFrameBody)imageFrameBody);
                            }
                        } else if (body instanceof FrameBodyPIC) {
                            FrameBodyPIC imageFrameBody = (FrameBodyPIC)body;
                            if (!imageFrameBody.isImageUrl()) {
                                imageBytes = (byte[])this.getObjectValue("PictureData", (AbstractTagFrameBody)imageFrameBody);
                                mimeType = (String)this.getObjectValue("MIMEType", (AbstractTagFrameBody)imageFrameBody);
                            }
                        } else {
                            LOG.warn("Extracting cover image from MP3 failed. Unknown frame body class: {}", (Object)body.getClass().getName());
                        }
                    }
                }
            } else if (Mp3CoverExtractor.isSupported(managedFile.getContentType()) || Mp3CoverExtractor.isSupportedFileExt(managedFile.getFileName())) {
                AudioFile f = AudioFileIO.read((File)tmpFile);
                Tag tag = f.getTag();
                if (tag instanceof Mp4Tag) {
                    Mp4Tag mp4tag = (Mp4Tag)tag;
                    List coverarts = mp4tag.get(Mp4FieldKey.ARTWORK);
                    if (null != coverarts && !coverarts.isEmpty()) {
                        Mp4TagCoverField coverArtField = (Mp4TagCoverField)coverarts.get(0);
                        imageBytes = coverArtField.getData();
                        mimeType = Mp4TagCoverField.getMimeTypeForImageType((Mp4FieldType)coverArtField.getFieldType());
                    }
                } else {
                    Artwork artwork = tag.getFirstArtwork();
                    if (null != artwork) {
                        imageBytes = artwork.getBinaryData();
                        mimeType = artwork.getMimeType();
                    }
                }
            }
        }
        catch (IOException e) {
            throw FileStorageExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (TagException e) {
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (ReadOnlyFileException e) {
            throw FileStorageExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (CannotReadException e) {
            throw FileStorageExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (InvalidAudioFrameException e) {
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (RuntimeException e) {
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            managedFile.delete();
        }
        DataProperties properties = new DataProperties();
        if (imageBytes == null) {
            LOG.debug("Requested a non-existing image in MP3 file: file-id={} folder={} context={} session-user={}\nReturning an empty image as fallback.", new Object[]{fileId, folderId, session.getContextId(), session.getUserId()});
            properties.put("com.openexchange.conversion.content-type", mimeType);
            properties.put("com.openexchange.conversion.size", String.valueOf(0));
            return new SimpleData((Object)new UnsynchronizedByteArrayInputStream(new byte[0]), properties);
        }
        properties.put("com.openexchange.conversion.content-type", mimeType);
        properties.put("com.openexchange.conversion.size", String.valueOf(imageBytes.length));
        if (null != mimeType) {
            List<String> extensions = MimeType2ExtMap.getFileExtensions(mimeType);
            properties.put("com.openexchange.conversion.name", "image." + extensions.get(0));
        }
        return new SimpleData((Object)new UnsynchronizedByteArrayInputStream(imageBytes), properties);
    }

    private Object getObjectValue(String identifier, AbstractTagFrameBody imageFrameBody) {
        AbstractDataType dataType = imageFrameBody.getObject(identifier);
        return null == dataType ? null : dataType.getValue();
    }

    public String[] getRequiredArguments() {
        String[] args = new String[ARGS.length];
        System.arraycopy(ARGS, 0, args, 0, ARGS.length);
        return args;
    }

    public Class<?>[] getTypes() {
        return new Class[]{InputStream.class};
    }

    @Override
    public String getRegistrationName() {
        return REGISTRATION_NAME;
    }

    @Override
    public String getAlias() {
        return ALIAS;
    }

    @Override
    public ImageLocation parseUrl(String url) {
        return ImageUtility.parseImageLocationFrom(url);
    }

    @Override
    public DataArguments generateDataArgumentsFrom(ImageLocation imageLocation) {
        DataArguments dataArguments = new DataArguments(2);
        dataArguments.put(ARGS[0], imageLocation.getFolder());
        dataArguments.put(ARGS[1], imageLocation.getId());
        return dataArguments;
    }

    @Override
    public String generateUrl(ImageLocation imageLocation, Session session) throws OXException {
        StringBuilder sb = new StringBuilder(64);
        ImageUtility.startImageUrl(imageLocation, session, this, true, sb);
        com.openexchange.file.storage.File file = Mp3ImageDataSource.optFile(imageLocation, ServerSessionAdapter.valueOf(session));
        if (null != file) {
            sb.append('&').append("timestamp=").append(file.getLastModified().getTime());
        }
        return sb.toString();
    }

    @Override
    public long getExpires() {
        return -1L;
    }

    @Override
    public String getETag(ImageLocation imageLocation, Session session) throws OXException {
        int delim = 35;
        StringBuilder builder = new StringBuilder(128);
        builder.append('#').append(imageLocation.getFolder());
        com.openexchange.file.storage.File file = Mp3ImageDataSource.optFile(imageLocation, ServerSessionAdapter.valueOf(session));
        if (null != file) {
            builder.append('#').append(file.getLastModified().getTime());
        }
        builder.append('#');
        return ImageUtility.getMD5(builder.toString(), "hex");
    }

    @Override
    public ImageLocation parseRequest(AJAXRequestData requestData) {
        return ImageUtility.parseImageLocationFrom(requestData);
    }

    private static com.openexchange.file.storage.File optFile(ImageLocation imageLocation, ServerSession session) throws OXException {
        return Mp3ImageDataSource.optFile(imageLocation.getId(), imageLocation.getFolder(), session);
    }

    private static com.openexchange.file.storage.File optFile(String fileId, String folderId, ServerSession session) throws OXException {
        if (!session.getUserPermissionBits().hasInfostore()) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{fileId, folderId});
        }
        ServerServiceRegistry serviceRegistry = ServerServiceRegistry.getInstance();
        IDBasedFileAccess fileAccess = serviceRegistry.getService(IDBasedFileAccessFactory.class).createAccess((Session)session);
        try {
            String fileName;
            com.openexchange.file.storage.File mp3File = fileAccess.getFileMetadata(fileId, FileStorageFileAccess.CURRENT_VERSION);
            String fileMIMEType = Strings.asciiLowerCase((String)mp3File.getFileMIMEType());
            if (null != fileMIMEType ? !Mp3CoverExtractor.isSupported(fileMIMEType) : null != (fileName = Strings.asciiLowerCase((String)mp3File.getFileName())) && !Mp3CoverExtractor.isSupportedFileExt(fileName)) {
                throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create(new Object[]{"File is not a supported audio file: " + fileMIMEType});
            }
            com.openexchange.file.storage.File file = mp3File;
            return file;
        }
        catch (RuntimeException e) {
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            fileAccess.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ManagedFile optData(String fileId, String folderId, ServerSession session, ManagedFileManagement fileManagement) throws OXException {
        if (!session.getUserPermissionBits().hasInfostore()) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{fileId, folderId});
        }
        ServerServiceRegistry serviceRegistry = ServerServiceRegistry.getInstance();
        IDBasedFileAccess fileAccess = serviceRegistry.getService(IDBasedFileAccessFactory.class).createAccess((Session)session);
        try {
            int pos;
            com.openexchange.file.storage.File audioFile = fileAccess.getFileMetadata(fileId, FileStorageFileAccess.CURRENT_VERSION);
            String fileName = audioFile.getFileName();
            ManagedFile managedFile = null == fileName ? fileManagement.createManagedFile(fileAccess.getDocument(fileId, FileStorageFileAccess.CURRENT_VERSION)) : ((pos = fileName.indexOf(46)) > 0 ? fileManagement.createManagedFile(fileAccess.getDocument(fileId, FileStorageFileAccess.CURRENT_VERSION), fileName.substring(pos)) : fileManagement.createManagedFile(fileAccess.getDocument(fileId, FileStorageFileAccess.CURRENT_VERSION)));
            managedFile.setContentType(audioFile.getFileMIMEType());
            managedFile.setFileName(fileName);
            ManagedFile managedFile2 = managedFile;
            return managedFile2;
        }
        finally {
            fileAccess.finish();
        }
    }
}

