/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.AbstractFormatMultipleDateReplacement;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DeleteExceptionsReplacement
extends AbstractFormatMultipleDateReplacement {
    public DeleteExceptionsReplacement(Date[] dates) {
        this(dates, null, null);
    }

    public DeleteExceptionsReplacement(Date[] dates, Locale locale, TimeZone timeZone) {
        super(dates, "Delete exceptions: %1$s", locale, timeZone);
        this.fallback = "No delete exceptions";
    }

    @Override
    public String getReplacement() {
        if (this.dates == null || this.dates.length == 0) {
            return "";
        }
        String repl = super.getReplacement();
        return new StringBuilder(repl.length() + 1).append(repl).append('\n').toString();
    }

    @Override
    public TemplateToken getToken() {
        return TemplateToken.DELETE_EXCEPTIONS;
    }
}

