/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.upload.quotachecker;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.upload.impl.UploadQuotaChecker;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailUploadQuotaChecker
extends UploadQuotaChecker {
    private static final Logger LOG = LoggerFactory.getLogger(MailUploadQuotaChecker.class);
    private final long uploadQuota;
    private final long uploadQuotaPerFile;

    public MailUploadQuotaChecker(UserSettingMail settings) {
        Validate.notNull((Object)settings, (String)"UserSettingMail cannot be null!");
        long quota = settings.getUploadQuota();
        if (quota >= 0L) {
            this.uploadQuota = quota;
        } else {
            int globalQuota;
            LOG.debug("Upload quota is less than zero. Using global server property \"MAX_UPLOAD_SIZE\" instead.");
            try {
                globalQuota = ServerConfig.getInt(ServerConfig.Property.MAX_UPLOAD_SIZE);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                globalQuota = 0;
            }
            this.uploadQuota = globalQuota;
        }
        long quotaPerFile = settings.getUploadQuotaPerFile();
        this.uploadQuotaPerFile = quotaPerFile > 0L ? quotaPerFile : -1L;
    }

    public MailUploadQuotaChecker(Session session, Context ctx) {
        this(UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), ctx));
    }

    @Override
    public long getFileQuotaMax() {
        return this.uploadQuotaPerFile;
    }

    @Override
    public long getQuotaMax() {
        return this.uploadQuota;
    }
}

