/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.groupware.update.tasks.MakeFolderIdPrimaryForDelContactsTable;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactsAddIndex4AutoCompleteSearchV2
extends UpdateTaskAdapter {
    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING, WorkingLevel.SCHEMA);
    }

    @Override
    public String[] getDependencies() {
        return new String[]{MakeFolderIdPrimaryForDelContactsTable.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        Logger log = LoggerFactory.getLogger(ContactsAddIndex4AutoCompleteSearchV2.class);
        log.info("Performing update task {}", (Object)ContactsAddIndex4AutoCompleteSearchV2.class.getSimpleName());
        Connection connection = Database.getNoTimeout(params.getContextId(), true);
        boolean committed = false;
        try {
            connection.setAutoCommit(false);
            ContactsAddIndex4AutoCompleteSearchV2.createIndexIfNeeded(log, connection, new String[]{"cid", "field03"}, "givenname");
            ContactsAddIndex4AutoCompleteSearchV2.createIndexIfNeeded(log, connection, new String[]{"cid", "field02"}, "surname");
            ContactsAddIndex4AutoCompleteSearchV2.createIndexIfNeeded(log, connection, new String[]{"cid", "field01"}, "displayname");
            ContactsAddIndex4AutoCompleteSearchV2.createIndexIfNeeded(log, connection, new String[]{"cid", "field65"}, "email1");
            ContactsAddIndex4AutoCompleteSearchV2.createIndexIfNeeded(log, connection, new String[]{"cid", "field66"}, "email2");
            ContactsAddIndex4AutoCompleteSearchV2.createIndexIfNeeded(log, connection, new String[]{"cid", "field67"}, "email3");
            connection.commit();
            committed = true;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (!committed) {
                DBUtils.rollback(connection);
            }
            DBUtils.autocommit(connection);
            Database.backNoTimeout(params.getContextId(), true, connection);
        }
        log.info("{} successfully performed.", (Object)ContactsAddIndex4AutoCompleteSearchV2.class.getSimpleName());
    }

    private static void createIndexIfNeeded(Logger log, Connection connection, String[] columns, String indexName) throws SQLException {
        String existingIndex = Tools.existsIndex(connection, "prg_contacts", columns);
        if (null == existingIndex) {
            log.info("Creating new index named \"{}\" with columns ({}) on table \"prg_contacts\".", (Object)indexName, (Object)Arrays.toString(columns));
            Tools.createIndex(connection, "prg_contacts", indexName, columns, false);
        } else {
            log.info("Found existing index named \"{}\" with columns ({}) on table \"prg_contacts\".", (Object)indexName, (Object)Arrays.toString(columns));
        }
    }
}

