/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.groupware.update.ProgressState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressStatusImpl
implements ProgressState {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressStatusImpl.class);
    private static final long logTimeDistance = 10000L;
    private final String taskName;
    private final String schema;
    private int total = -1;
    private int state = 0;
    private long lastLogTime;

    public ProgressStatusImpl(String taskName, String schema) {
        this.taskName = taskName;
        this.schema = schema;
    }

    @Override
    public void setTotal(int total) {
        this.total = total;
        this.lastLogTime = System.currentTimeMillis();
    }

    @Override
    public void setState(int state) {
        this.state = state;
        this.logState();
    }

    @Override
    public void incrementState() {
        ++this.state;
        this.logState();
    }

    private void logState() {
        long now = System.currentTimeMillis();
        if (now > this.lastLogTime + 10000L) {
            this.lastLogTime = now;
            LOG.info("Update task {} finished {}% on schema {}{}", new Object[]{this.taskName, this.state * 100 / this.total, this.schema, Character.valueOf('.')});
        }
    }
}

