/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.index;

import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.index.IndexField;
import java.util.HashMap;
import java.util.Map;

public enum InfostoreIndexField implements IndexField
{
    UUID(null),
    FOLDER(Metadata.FOLDER_ID_LITERAL),
    ID(Metadata.ID_LITERAL),
    CREATED_BY(Metadata.CREATED_BY_LITERAL),
    MODIFIED_BY(Metadata.MODIFIED_BY_LITERAL),
    CREATED(Metadata.CREATION_DATE_LITERAL),
    LAST_MODIFIED(Metadata.LAST_MODIFIED_LITERAL),
    TITLE(Metadata.TITLE_LITERAL),
    VERSION(Metadata.VERSION_LITERAL),
    DESCRIPTION(Metadata.DESCRIPTION_LITERAL),
    URL(Metadata.URL_LITERAL),
    SEQUENCE_NUMBER(Metadata.SEQUENCE_NUMBER_LITERAL),
    CATEGORIES(Metadata.CATEGORIES_LITERAL),
    COLOR_LABEL(Metadata.COLOR_LABEL_LITERAL),
    VERSION_COMMENT(Metadata.VERSION_COMMENT_LITERAL),
    NUMBER_OF_VERSIONS(Metadata.NUMBER_OF_VERSIONS_LITERAL),
    FILESTORE_LOCATION(Metadata.FILESTORE_LOCATION_LITERAL);

    private static final Map<Metadata, InfostoreIndexField> mapping;
    private final Metadata metadataField;

    private InfostoreIndexField(Metadata metadataField) {
        this.metadataField = metadataField;
    }

    public Metadata getMetadataField() {
        return this.metadataField;
    }

    public static InfostoreIndexField getByMetadateField(int metadataField) {
        Metadata key = Metadata.get(metadataField);
        return null == key ? null : mapping.get(key);
    }

    static {
        mapping = new HashMap<Metadata, InfostoreIndexField>();
        for (InfostoreIndexField field : InfostoreIndexField.values()) {
            Metadata metadataField = field.getMetadataField();
            if (metadataField == null) continue;
            mapping.put(metadataField, field);
        }
    }
}

