/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.filestore;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.filestore.Filestore;
import com.openexchange.groupware.filestore.FilestoreExceptionCodes;
import com.openexchange.java.Autoboxing;
import java.net.URI;
import java.net.URISyntaxException;

public final class FilestoreTools {
    private FilestoreTools() {
    }

    public static URI createLocation(Filestore store, Context context) throws OXException {
        if (store.getId() != context.getFilestoreId()) {
            throw FilestoreExceptionCodes.FILESTORE_MIXUP.create(Autoboxing.I((int)store.getId()), Autoboxing.I((int)context.getContextId()), Autoboxing.I((int)context.getFilestoreId()));
        }
        URI uri = store.getUri();
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath() + '/' + context.getFilestoreName(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw FilestoreExceptionCodes.URI_CREATION_FAILED.create(e, uri.toString() + '/' + context.getFilestoreName());
        }
    }
}

