/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Strings;
import com.openexchange.tools.arrays.Arrays;

public class ParsedDisplayName {
    private String displayName;
    private String givenName;
    private String surName;

    public ParsedDisplayName(String displayName) {
        this.displayName = displayName;
        this.parse(displayName);
    }

    public Contact applyTo(Contact contact) {
        if (null != contact) {
            contact.setDisplayName(this.displayName);
            contact.setGivenName(this.givenName);
            contact.setSurName(this.surName);
        }
        return contact;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSurName() {
        return this.surName;
    }

    private void parse(String displayName) {
        Object[] splitted;
        this.displayName = displayName;
        while (0 < displayName.length() && ('<' == displayName.charAt(0) || '\"' == displayName.charAt(0) || '\'' == displayName.charAt(0))) {
            displayName = displayName.substring(1);
        }
        while (0 < displayName.length() && ('>' == displayName.charAt(displayName.length() - 1) || '\"' == displayName.charAt(displayName.length() - 1) || '\'' == displayName.charAt(displayName.length() - 1))) {
            displayName = displayName.substring(0, displayName.length() - 1);
        }
        if (Strings.isEmpty((String)displayName)) {
            return;
        }
        if (0 < displayName.indexOf(44)) {
            splitted = Strings.splitByComma((String)displayName.trim());
            Arrays.reverse((Object[])splitted);
        } else {
            splitted = Strings.splitByWhitespaces((String)displayName.trim());
        }
        this.parse((String[])splitted);
    }

    private void parse(String[] splitted) {
        if (1 == splitted.length) {
            this.givenName = splitted[0].trim();
        } else if (2 == splitted.length) {
            this.givenName = splitted[0].trim();
            this.surName = splitted[1].trim();
        } else {
            for (int i = 0; i < splitted.length - 1; ++i) {
                String name = splitted[i].trim();
                this.givenName = null == this.givenName ? name : this.givenName + ' ' + name;
            }
            this.surName = splitted[splitted.length - 1].trim();
        }
    }
}

