/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.groupware.attach.impl.AttachmentBaseImpl;
import com.openexchange.groupware.attach.impl.OverridableAttachmentAuthorization;
import com.openexchange.groupware.attach.impl.OverridableAttachmentListener;
import com.openexchange.groupware.calendar.CalendarAttachments;
import com.openexchange.groupware.contact.ContactsAttachment;
import com.openexchange.groupware.tasks.TaskAttachmentListener;
import com.openexchange.groupware.tasks.TaskAuthorization;
import com.openexchange.tools.service.ServicePriorityConflictException;
import com.openexchange.tools.service.SpecificServiceChooser;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

public abstract class Attachments {
    private static final TIntObjectMap<SpecificServiceChooser<AttachmentAuthorization>> authz = new TIntObjectHashMap(3);
    private static final TIntObjectMap<SpecificServiceChooser<AttachmentListener>> listener = new TIntObjectHashMap(3);
    private static final AttachmentBaseImpl impl = new AttachmentBaseImpl(new DBPoolProvider());

    public static SpecificServiceChooser<AttachmentAuthorization> getAuthorizationChooserForModule(int module) {
        return (SpecificServiceChooser)authz.get(module);
    }

    public static SpecificServiceChooser<AttachmentListener> getListenerChooserForModule(int module) {
        return (SpecificServiceChooser)listener.get(module);
    }

    public static AttachmentBase getInstance() {
        return impl;
    }

    public static AttachmentBase getInstance(DBProvider provider) {
        return new AttachmentBaseImpl(provider);
    }

    static {
        try {
            SpecificServiceChooser<AttachmentAuthorization> taskAuth = new SpecificServiceChooser<AttachmentAuthorization>();
            taskAuth.registerForEverything(new TaskAuthorization(), 0);
            SpecificServiceChooser<AttachmentAuthorization> contactAuth = new SpecificServiceChooser<AttachmentAuthorization>();
            contactAuth.registerForEverything(new ContactsAttachment(), 0);
            SpecificServiceChooser<AttachmentAuthorization> appointmentAuth = new SpecificServiceChooser<AttachmentAuthorization>();
            appointmentAuth.registerForEverything(new CalendarAttachments(), 0);
            authz.put(4, taskAuth);
            authz.put(7, contactAuth);
            authz.put(1, appointmentAuth);
            SpecificServiceChooser<AttachmentListener> taskListener = new SpecificServiceChooser<AttachmentListener>();
            taskListener.registerForEverything(new TaskAttachmentListener(), 0);
            SpecificServiceChooser<AttachmentListener> contactListener = new SpecificServiceChooser<AttachmentListener>();
            contactListener.registerForEverything(new ContactsAttachment(), 0);
            SpecificServiceChooser<AttachmentListener> appointmentListener = new SpecificServiceChooser<AttachmentListener>();
            appointmentListener.registerForEverything(new CalendarAttachments(), 0);
            listener.put(4, taskListener);
            listener.put(7, contactListener);
            listener.put(1, appointmentListener);
            impl.addAuthorization(new OverridableAttachmentAuthorization(taskAuth), 4);
            impl.registerAttachmentListener(new OverridableAttachmentListener(taskListener), 4);
            impl.addAuthorization(new OverridableAttachmentAuthorization(contactAuth), 7);
            impl.registerAttachmentListener(new OverridableAttachmentListener(contactListener), 7);
            impl.addAuthorization(new OverridableAttachmentAuthorization(appointmentAuth), 1);
            impl.registerAttachmentListener(new OverridableAttachmentListener(appointmentListener), 1);
        }
        catch (ServicePriorityConflictException e) {
            e.printStackTrace();
        }
    }
}

