/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach;

import com.openexchange.ajax.Attachment;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentConfig;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.groupware.upload.impl.UploadSizeExceededException;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Streams;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttachmentUtility {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentUtility.class);
    private static final String CALLBACK = "callback";

    private AttachmentUtility() {
    }

    public static List<Integer> attachTo(int objectId, int module, int folderId, AJAXRequestData requestData, ServerSession session) throws OXException {
        long maxUploadSize = AttachmentConfig.getMaxUploadSize();
        if (!requestData.hasUploads(-1L, maxUploadSize > 0L ? maxUploadSize : -1L)) {
            return Collections.emptyList();
        }
        UploadEvent upload = requestData.getUploadEvent(-1L, maxUploadSize > 0L ? maxUploadSize : -1L);
        if (null == upload) {
            return Collections.emptyList();
        }
        ArrayList<AttachmentMetadata> attachments2 = new ArrayList<AttachmentMetadata>(4);
        ArrayList<UploadFile> uploadFiles = new ArrayList<UploadFile>(4);
        long sum = 0L;
        int index = 0;
        for (UploadFile uploadFile : upload.getUploadFiles()) {
            AttachmentMetadataImpl attachment = new AttachmentMetadataImpl(objectId, module, folderId);
            AttachmentUtility.assureSize(index, attachments2, uploadFiles);
            attachments2.set(index, attachment);
            uploadFiles.set(index, uploadFile);
            AttachmentUtility.checkSize(sum += uploadFile.getSize(), requestData);
            ++index;
        }
        return AttachmentUtility.attach(attachments2, uploadFiles, session, session.getContext(), session.getUser(), session.getUserConfiguration());
    }

    private static List<Integer> attach(List<AttachmentMetadata> attachments2, List<UploadFile> uploadFiles, ServerSession session, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        AttachmentUtility.initAttachments(attachments2, uploadFiles);
        LinkedList<BufferedInputStream> closeables = new LinkedList<BufferedInputStream>();
        boolean rollback = false;
        try {
            Attachment.ATTACHMENT_BASE.startTransaction();
            rollback = true;
            Iterator<UploadFile> ufIter = uploadFiles.iterator();
            LinkedList<Integer> ids = new LinkedList<Integer>();
            long timestamp = 0L;
            for (AttachmentMetadata attachment : attachments2) {
                UploadFile uploadFile = ufIter.next();
                attachment.setId(0);
                BufferedInputStream data = new BufferedInputStream(new FileInputStream(uploadFile.getTmpFile()), 65536);
                closeables.add(data);
                long modified = Attachment.ATTACHMENT_BASE.attachToObject(attachment, data, session, ctx, user, userConfig);
                if (modified > timestamp) {
                    timestamp = modified;
                }
                ids.add(attachment.getId());
            }
            Attachment.ATTACHMENT_BASE.commit();
            rollback = false;
            LinkedList<Integer> linkedList = ids;
            return linkedList;
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                AttachmentUtility.rollback();
            }
            AttachmentUtility.finish();
            for (Closeable closeable : closeables) {
                Streams.close((Closeable)closeable);
            }
        }
    }

    private static void initAttachments(List<AttachmentMetadata> attachments2, List<UploadFile> uploads) {
        ArrayList<AttachmentMetadata> attList = new ArrayList<AttachmentMetadata>(attachments2);
        Iterator<UploadFile> ufIter = new ArrayList<UploadFile>(uploads).iterator();
        int index = 0;
        for (AttachmentMetadata attachment : attList) {
            if (attachment == null) {
                attachments2.remove(index);
                ufIter.next();
                uploads.remove(index);
                continue;
            }
            UploadFile upload = ufIter.next();
            if (upload == null) {
                attachments2.remove(index);
                uploads.remove(index);
                continue;
            }
            if (attachment.getFilename() == null || "".equals(attachment.getFilename())) {
                attachment.setFilename(upload.getPreparedFileName());
            }
            if (attachment.getFilesize() <= 0L) {
                attachment.setFilesize(upload.getSize());
            }
            if (attachment.getFileMIMEType() == null || "".equals(attachment.getFileMIMEType())) {
                attachment.setFileMIMEType(upload.getContentType());
            }
            ++index;
        }
    }

    private static void assureSize(int index, List<AttachmentMetadata> attachments2, List<UploadFile> uploadFiles) {
        int i;
        int enlarge = index - (attachments2.size() - 1);
        for (i = 0; i < enlarge; ++i) {
            attachments2.add(null);
        }
        enlarge = index - (uploadFiles.size() - 1);
        for (i = 0; i < enlarge; ++i) {
            uploadFiles.add(null);
        }
    }

    public static void checkSize(long size, AJAXRequestData requestData) throws OXException {
        long maxUploadSize = AttachmentConfig.getMaxUploadSize();
        if (maxUploadSize == 0L) {
            return;
        }
        if (size > maxUploadSize) {
            if (!requestData.containsParameter(CALLBACK)) {
                requestData.putParameter(CALLBACK, "error");
            }
            throw UploadSizeExceededException.create(size, maxUploadSize, true);
        }
    }

    public static void rollback() {
        try {
            Attachment.ATTACHMENT_BASE.rollback();
        }
        catch (Exception e) {
            LOG.debug("Rollback failed.", (Throwable)e);
        }
    }

    public static void finish() {
        try {
            Attachment.ATTACHMENT_BASE.finish();
        }
        catch (Exception e) {
            LOG.debug("Finishing failed.", (Throwable)e);
        }
    }

    private static final class AttachmentMetadataImpl
    implements AttachmentMetadata {
        private int createdBy;
        private Date creationDate;
        private String fileMIMEType;
        private String filename;
        private long filesize;
        private boolean rtfFlag;
        private int objectId;
        private int moduleId;
        private int id;
        private int folderId;
        private String comment;
        private String fileId;

        AttachmentMetadataImpl() {
        }

        AttachmentMetadataImpl(int attachedId, int moduleId, int folderId) {
            this.objectId = attachedId;
            this.moduleId = moduleId;
            this.folderId = folderId;
        }

        @Override
        public int getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public void setCreatedBy(int createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public Date getCreationDate() {
            return this.creationDate;
        }

        @Override
        public void setCreationDate(Date creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public String getFileMIMEType() {
            return this.fileMIMEType;
        }

        @Override
        public void setFileMIMEType(String fileMIMEType) {
            this.fileMIMEType = fileMIMEType;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public void setFilename(String filename) {
            this.filename = filename;
        }

        @Override
        public long getFilesize() {
            return this.filesize;
        }

        @Override
        public void setFilesize(long filesize) {
            this.filesize = filesize;
        }

        @Override
        public int getAttachedId() {
            return this.objectId;
        }

        @Override
        public void setAttachedId(int objectId) {
            this.objectId = objectId;
        }

        @Override
        public boolean getRtfFlag() {
            return this.rtfFlag;
        }

        @Override
        public void setRtfFlag(boolean rtfFlag) {
            this.rtfFlag = rtfFlag;
        }

        @Override
        public int getModuleId() {
            return this.moduleId;
        }

        @Override
        public void setModuleId(int moduleId) {
            this.moduleId = moduleId;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void setId(int id) {
            this.id = id;
        }

        @Override
        public void setFolderId(int folderId) {
            this.folderId = folderId;
        }

        @Override
        public int getFolderId() {
            return this.folderId;
        }

        @Override
        public void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public String getFileId() {
            return this.fileId;
        }
    }
}

