/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.folderstorage.Permission;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public final class Tools {
    private static final ConcurrentMap<String, Future<TimeZone>> TZ_MAP = new ConcurrentHashMap<String, Future<TimeZone>>();
    private static final int RADIX = 10;
    private static final int MAX_PERMISSION = 64;
    private static final TIntIntMap MAPPING = new TIntIntHashMap(6){
        {
            this.put(128, 64);
            this.put(64, 64);
            this.put(0, 0);
            this.put(2, 1);
            this.put(4, 2);
            this.put(8, 4);
        }
    };

    private Tools() {
    }

    public static TimeZone getTimeZone(final String timeZoneID) {
        FutureTask<TimeZone> ft;
        FutureTask<TimeZone> future = (FutureTask<TimeZone>)TZ_MAP.get(timeZoneID);
        if (null == future && null == (future = (Future)TZ_MAP.putIfAbsent(timeZoneID, ft = new FutureTask<TimeZone>(new Callable<TimeZone>(){

            @Override
            public TimeZone call() throws Exception {
                return TimeZone.getTimeZone(timeZoneID);
            }
        })))) {
            future = ft;
            ft.run();
        }
        try {
            return (TimeZone)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        catch (CancellationException e) {
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                IllegalStateException ise = new IllegalStateException(e.getMessage());
                ise.initCause(e);
                throw ise;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalStateException("Not unchecked", cause);
        }
    }

    public static boolean isGlobalId(String id) {
        return Tools.getUnsignedInteger(id) > 0;
    }

    public static int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int result = 0;
        int i = 0;
        int limit = -2147483647;
        int multmin = -214748364;
        if (i < max) {
            if ((digit = Tools.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = Tools.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    private static int digit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    public static int createPermissionBits(Permission perm) {
        return Tools.createPermissionBits(perm.getFolderPermission(), perm.getReadPermission(), perm.getWritePermission(), perm.getDeletePermission(), perm.isAdmin());
    }

    public static int createPermissionBits(int fp, int rp, int wp, int dp, boolean adminFlag) {
        int retval = 0;
        int i = 4;
        retval += (adminFlag ? 1 : 0) << i-- * 7;
        retval += MAPPING.get(dp) << i-- * 7;
        retval += MAPPING.get(wp) << i-- * 7;
        retval += MAPPING.get(rp) << i-- * 7;
        return retval += MAPPING.get(fp) << i * 7;
    }
}

