/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.storage.internal;

import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.contact.storage.registry.ContactStorageRegistry;
import com.openexchange.exception.OXException;
import com.openexchange.session.Session;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DefaultContactStorageRegistry
implements ContactStorageRegistry {
    private final List<ContactStorage> knownStorages = new ArrayList<ContactStorage>();

    @Override
    public ContactStorage getStorage(Session session, String folderId) throws OXException {
        ContactStorage contactStorage = null;
        for (ContactStorage storage : this.knownStorages) {
            if (!storage.supports(session, folderId) || null != contactStorage && storage.getPriority() <= contactStorage.getPriority()) continue;
            contactStorage = storage;
        }
        return contactStorage;
    }

    @Override
    public List<ContactStorage> getStorages(Session session) throws OXException {
        return Collections.unmodifiableList(this.knownStorages);
    }

    public void addStorage(ContactStorage storage) {
        this.knownStorages.add(storage);
    }

    public void removeStorage(ContactStorage storage) {
        this.knownStorages.remove(storage);
    }
}

