/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.contact.SortOptions;
import com.openexchange.contact.internal.Tools;
import com.openexchange.contact.internal.mapping.ContactMapper;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.Search;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.java.Strings;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class Check {
    public static void argNotNull(Object object, String argumentName) {
        if (null == object) {
            throw new IllegalArgumentException("the passed argument '" + argumentName + "' may not be null");
        }
    }

    public static void hasStorages(Map<ContactStorage, List<String>> storages) throws OXException {
        if (null == storages || 0 == storages.size()) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ContactStorage.class.getName()});
        }
    }

    public static void validateProperties(Contact contact) throws OXException {
        ContactMapper.getInstance().validateAll(contact);
    }

    public static void isNotPrivate(Contact contact, Session session, String folderID) throws OXException {
        if (contact.containsPrivateFlag()) {
            throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void canReadOwn(EffectivePermission permission, Session session, String folderID) throws OXException {
        if (!permission.canReadOwnObjects()) {
            throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void canWriteOwn(EffectivePermission permission, Session session) throws OXException {
        if (!permission.canWriteOwnObjects()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(session.getUserId(), session.getContextId());
        }
    }

    public static void canWriteAll(EffectivePermission permission, Session session) throws OXException {
        if (!permission.canWriteAllObjects()) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(session.getUserId(), session.getContextId());
        }
    }

    public static void canReadAll(EffectivePermission permission, Session session, String folderID) throws OXException {
        if (!permission.canReadAllObjects()) {
            throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void canCreateObjects(EffectivePermission permission, Session session, String folderID) throws OXException {
        if (!permission.canCreateObjects()) {
            throw ContactExceptionCodes.NO_CREATE_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void canDeleteOwn(EffectivePermission permission, Session session, String folderID) throws OXException {
        if (!permission.canDeleteOwnObjects()) {
            throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void canDeleteAll(EffectivePermission permission, Session session, String folderID) throws OXException {
        if (!permission.canDeleteAllObjects()) {
            throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(Tools.parse(folderID), session.getContextId(), session.getUserId());
        }
    }

    public static void isContactFolder(FolderObject folder, Session session) throws OXException {
        if (3 != folder.getModule()) {
            throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(folder.getObjectID(), session.getContextId(), session.getUserId());
        }
    }

    public static void contactNotNull(Contact contact, int contextID, int id) throws OXException {
        if (null == contact) {
            throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(id, contextID);
        }
    }

    public static void lastModifiedBefore(Contact contact, Date lastRead) throws OXException {
        if (lastRead.before(contact.getLastModified())) {
            throw ContactExceptionCodes.OBJECT_HAS_CHANGED.create();
        }
    }

    public static void folderEquals(Contact contact, String folderID, int contextID) throws OXException {
        if (contact.getParentFolderID() != Tools.parse(folderID)) {
            throw ContactExceptionCodes.NOT_IN_FOLDER.create(contact.getObjectID(), Tools.parse(folderID), contextID);
        }
    }

    public static void noPrivateInPublic(FolderObject folder, Contact contact, Session session) throws OXException {
        if (2 == folder.getType() && contact.getPrivateFlag()) {
            throw ContactExceptionCodes.PFLAG_IN_PUBLIC_FOLDER.create(folder.getObjectID(), session.getContextId(), session.getUserId());
        }
    }

    public static void validateSearch(ContactSearchObject contactSearch) throws OXException {
        Search.checkPatternLength(contactSearch);
        if (0 != contactSearch.getIgnoreOwn() || null != contactSearch.getAnniversaryRange() || null != contactSearch.getBirthdayRange() || null != contactSearch.getBusinessPostalCodeRange() || null != contactSearch.getCreationDateRange() || null != contactSearch.getDynamicSearchField() || null != contactSearch.getDynamicSearchFieldValue() || null != contactSearch.getFrom() || null != contactSearch.getLastModifiedRange() || null != contactSearch.getNumberOfEmployeesRange() || null != contactSearch.getSalesVolumeRange() || null != contactSearch.getOtherPostalCodeRange() || null != contactSearch.getPrivatePostalCodeRange()) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void canWriteInGAB(ContactStorage storage, Session session, String folderID, Contact update) throws OXException {
        if (6 == Tools.parse(folderID)) {
            if (!OXFolderProperties.isEnableInternalUsersEdit()) {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(update.getObjectID(), session.getContextId());
            }
            if (update.containsDisplayName()) {
                if (Tools.isEmpty(update.getDisplayName())) {
                    throw ContactExceptionCodes.DISPLAY_NAME_MANDATORY.create();
                }
                CompositeSearchTerm searchTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
                searchTerm.addSearchTerm((SearchTerm)Tools.createContactFieldTerm(ContactField.FOLDER_ID, SingleSearchTerm.SingleOperation.EQUALS, folderID));
                searchTerm.addSearchTerm((SearchTerm)Tools.createContactFieldTerm(ContactField.DISPLAY_NAME, SingleSearchTerm.SingleOperation.EQUALS, update.getDisplayName()));
                searchTerm.addSearchTerm((SearchTerm)Tools.createContactFieldTerm(ContactField.OBJECT_ID, SingleSearchTerm.SingleOperation.NOT_EQUALS, update.getObjectID()));
                SearchIterator<Contact> searchIterator = null;
                try {
                    searchIterator = storage.search(session, searchTerm, new ContactField[]{ContactField.OBJECT_ID}, new SortOptions(0, 1));
                    if (searchIterator.hasNext()) {
                        throw ContactExceptionCodes.DISPLAY_NAME_IN_USE.create(session.getContextId(), update.getObjectID());
                    }
                }
                finally {
                    Tools.close(searchIterator);
                }
            }
            if (update.containsSurName() && Tools.isEmpty(update.getSurName())) {
                throw ContactExceptionCodes.LAST_NAME_MANDATORY.create();
            }
            if (update.containsGivenName() && Tools.isEmpty(update.getGivenName())) {
                throw ContactExceptionCodes.FIRST_NAME_MANDATORY.create();
            }
            if (update.containsEmail1() && Tools.getContext(session).getMailadmin() != session.getUserId()) {
                throw ContactExceptionCodes.NO_PRIMARY_EMAIL_EDIT.create(session.getContextId(), update.getObjectID(), session.getUserId());
            }
        }
    }

    public static void readOnlyFields(int userID, Contact storedContact, Contact delta) throws OXException {
        if (delta.containsContextId()) {
            if (0 == delta.getContextId() || delta.getContextId() == storedContact.getContextId()) {
                delta.removeContextID();
            } else {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(storedContact.getObjectID(), storedContact.getContextId());
            }
        }
        if (delta.containsObjectID()) {
            if (0 == delta.getObjectID() || delta.getObjectID() == storedContact.getObjectID()) {
                delta.removeObjectID();
            } else {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(storedContact.getObjectID(), storedContact.getContextId());
            }
        }
        if (delta.containsInternalUserId()) {
            if (0 == delta.getInternalUserId() || delta.getInternalUserId() == storedContact.getInternalUserId()) {
                delta.removeInternalUserId();
            } else {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(storedContact.getObjectID(), storedContact.getContextId());
            }
        }
        if (delta.containsUid() && !Strings.isEmpty((String)storedContact.getUid())) {
            if (Strings.isEmpty((String)delta.getUid()) || delta.getUid().equals(storedContact.getUid())) {
                delta.removeUid();
            } else {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(storedContact.getObjectID(), storedContact.getContextId());
            }
        }
        if (delta.containsCreatedBy()) {
            if (0 == delta.getCreatedBy() || delta.getCreatedBy() == storedContact.getCreatedBy()) {
                delta.removeCreatedBy();
            } else {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(storedContact.getObjectID(), storedContact.getContextId());
            }
        }
        if (delta.containsCreationDate()) {
            if (null == delta.getCreationDate() || delta.getCreationDate().equals(storedContact.getCreationDate()) || 0L == delta.getCreationDate().getTime()) {
                delta.removeCreationDate();
            } else {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(storedContact.getObjectID(), storedContact.getContextId());
            }
        }
        if (delta.containsPrivateFlag() && delta.getPrivateFlag() && storedContact.getCreatedBy() != userID) {
            throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(storedContact.getObjectID(), storedContact.getContextId());
        }
    }

    private Check() {
    }
}

