/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.meta.MetaContributor;
import com.openexchange.ajax.meta.MetaContributorRegistry;
import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.ajax.writer.WriterProcedure;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.server.services.MetaContributors;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWriter {
    static final Logger LOG = LoggerFactory.getLogger(DataWriter.class);
    protected TimeZone timeZone;
    static final TimeZone UTC = TimeZoneUtils.getTimeZone("UTC");
    protected JSONWriter jsonwriter;
    private static final FieldWriter<DataObject> OBJECT_ID_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getObjectID(), json, obj.containsObjectID());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("id", obj.getObjectID(), json, obj.containsObjectID());
        }
    };
    private static final FieldWriter<DataObject> CREATED_BY_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getCreatedBy(), json, obj.containsCreatedBy());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("created_by", obj.getCreatedBy(), json, obj.containsCreatedBy());
        }
    };
    private static final FieldWriter<DataObject> CREATION_DATE_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getCreationDate(), timeZone, json, obj.containsCreationDate());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("creation_date", obj.getCreationDate(), timeZone, json);
        }
    };
    private static final FieldWriter<DataObject> MODIFIED_BY_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getModifiedBy(), json, obj.containsModifiedBy());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("modified_by", obj.getModifiedBy(), json, obj.containsModifiedBy());
        }
    };
    private static final FieldWriter<DataObject> LAST_MODIFIED_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getLastModified(), timeZone, json, obj.containsLastModified());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("last_modified", obj.getLastModified(), timeZone, json, obj.containsLastModified());
        }
    };
    private static final FieldWriter<DataObject> LAST_MODIFIED_UTC_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getLastModified(), UTC, json, obj.containsLastModified());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("last_modified_utc", obj.getLastModified(), UTC, json, obj.containsLastModified());
        }
    };
    private static final FieldWriter<DataObject> META_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json, Session session) throws JSONException {
            Map<String, Object> map = obj.getMap();
            if (null == (map = DataWriter.contributeTo(map, obj, session)) || map.isEmpty()) {
                DataWriter.writeValue((String)null, json, false);
            } else {
                DataWriter.writeValue((JSONValue)JSONCoercion.coerceToJSON(map), json, true);
            }
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            Map<String, Object> map = obj.getMap();
            if (null != (map = DataWriter.contributeTo(map, obj, session)) && !map.isEmpty()) {
                DataWriter.writeParameter("meta", (JSONValue)JSONCoercion.coerceToJSON(map), json, true);
            }
        }
    };
    private static final TIntObjectMap<FieldWriter<DataObject>> WRITER_MAP;

    protected DataWriter(TimeZone timeZone, JSONWriter writer) {
        this.timeZone = timeZone;
        this.jsonwriter = writer;
    }

    public void writeParameter(String name, String value) throws JSONException {
        if (value != null && value.length() > 0) {
            this.jsonwriter.key(name);
            this.jsonwriter.value((Object)value);
        }
    }

    public void writeParameter(String name, Date value) throws JSONException {
        if (value != null) {
            this.jsonwriter.key(name);
            this.jsonwriter.value(value.getTime());
        }
    }

    public static void writeParameter(String name, String value, JSONObject json) throws JSONException {
        if (value != null && value.length() > 0) {
            json.put(name, (Object)value);
        }
    }

    public static void writeParameter(String name, String value, JSONObject json, boolean condition) throws JSONException {
        if (condition) {
            DataWriter.writeParameter(name, value, json);
        }
    }

    public static void writeParameter(String name, JSONValue value, JSONObject json) throws JSONException {
        if (value != null) {
            json.put(name, (Object)value);
        }
    }

    public static void writeParameter(String name, JSONValue value, JSONObject json, boolean condition) throws JSONException {
        if (condition) {
            json.put(name, (Object)value);
        }
    }

    public static void writeParameter(String name, int value, JSONObject json) throws JSONException {
        json.put(name, value);
    }

    public static void writeParameter(String name, int value, JSONObject json, boolean condition) throws JSONException {
        if (condition) {
            DataWriter.writeParameter(name, value, json);
        }
    }

    public static void writeParameter(String name, long value, JSONObject json) throws JSONException {
        DataWriter.writeParameter(name, Long.toString(value), json);
    }

    public static void writeParameter(String name, long value, JSONObject json, boolean condition) throws JSONException {
        DataWriter.writeParameter(name, Long.toString(value), json, condition);
    }

    public static void writeParameter(String name, Long value, JSONObject json, boolean condition) throws JSONException {
        if (null == value) {
            DataWriter.writeNull(name, json, condition);
        } else {
            DataWriter.writeParameter(name, Long.toString(value), json, condition);
        }
    }

    public static void writeParameter(String name, Integer value, JSONObject json, boolean condition) throws JSONException {
        if (null != value) {
            DataWriter.writeParameter(name, Integer.toString(value), json, condition);
        }
    }

    public static void writeParameter(String name, BigDecimal value, JSONObject jsonObj, boolean condition) throws JSONException {
        if (condition) {
            DataWriter.writeParameter(name, value, jsonObj);
        }
    }

    private static void writeParameter(String name, BigDecimal value, JSONObject jsonObj) throws JSONException {
        if (null == value) {
            jsonObj.put(name, JSONObject.NULL);
        } else {
            jsonObj.put(name, (Object)value);
        }
    }

    public static void writeParameter(String name, boolean value, JSONObject jsonObj) throws JSONException {
        jsonObj.put(name, value);
    }

    public static void writeParameter(String name, boolean value, JSONObject jsonObj, boolean condition) throws JSONException {
        if (condition) {
            jsonObj.put(name, value);
        }
    }

    public static void writeParameter(String name, Date value, JSONObject jsonObj) throws JSONException {
        if (value != null) {
            jsonObj.put(name, value.getTime());
        }
    }

    public static void writeParameter(String name, Date value, TimeZone timeZone, JSONObject jsonObj) throws JSONException {
        DataWriter.writeParameter(name, value, value, timeZone, jsonObj);
    }

    static void writeParameter(String name, Date value, TimeZone timeZone, JSONObject json, boolean condition) throws JSONException {
        if (condition) {
            DataWriter.writeParameter(name, value, timeZone, json);
        }
    }

    public static void writeParameter(String name, Date value, Date offsetDate, TimeZone timeZone, JSONObject jsonObj) throws JSONException {
        if (value != null) {
            jsonObj.put(name, value.getTime() + (long)timeZone.getOffset(offsetDate.getTime()));
        }
    }

    public static void writeValue(String value, JSONArray jsonArray) {
        if (value != null && value.length() > 0) {
            jsonArray.put((Object)value);
        } else {
            jsonArray.put(JSONObject.NULL);
        }
    }

    static void writeValue(String value, JSONArray jsonArray, boolean condition) {
        if (condition) {
            DataWriter.writeValue(value, jsonArray);
        } else {
            jsonArray.put(JSONObject.NULL);
        }
    }

    public static void writeValue(int value, JSONArray jsonArray) {
        jsonArray.put(value);
    }

    public static void writeValue(int value, JSONArray jsonArray, boolean condition) {
        if (condition) {
            jsonArray.put(value);
        } else {
            jsonArray.put(JSONObject.NULL);
        }
    }

    public static void writeValue(BigDecimal value, JSONArray jsonArray, boolean condition) {
        if (!condition || null == value) {
            jsonArray.put(JSONObject.NULL);
        } else {
            jsonArray.put((Object)value);
        }
    }

    public static void writeValue(long value, JSONArray jsonArray, boolean condition) {
        DataWriter.writeValue(Long.toString(value), jsonArray, condition);
    }

    public static void writeValue(Long value, JSONArray json, boolean condition) {
        if (condition) {
            DataWriter.writeValue(Long.toString(value), json);
        } else {
            DataWriter.writeNull(json);
        }
    }

    public static void writeValue(Integer value, JSONArray json, boolean condition) {
        if (condition) {
            DataWriter.writeValue(Integer.toString(value), json);
        } else {
            DataWriter.writeNull(json);
        }
    }

    protected static void writeNull(JSONArray json) {
        json.put(JSONObject.NULL);
    }

    protected static void writeNull(String name, JSONObject json, boolean condition) throws JSONException {
        if (condition) {
            json.put(name, JSONObject.NULL);
        }
    }

    public static void writeValue(boolean value, JSONArray jsonArray) {
        jsonArray.put(value);
    }

    public static void writeValue(boolean value, JSONArray jsonArray, boolean condition) {
        if (condition) {
            jsonArray.put(value);
        } else {
            jsonArray.put(JSONObject.NULL);
        }
    }

    public static void writeValue(Date value, JSONArray jsonArray) {
        if (value == null) {
            jsonArray.put(JSONObject.NULL);
        } else {
            jsonArray.put(value.getTime());
        }
    }

    public static void writeValue(Date value, JSONArray json, boolean condition) {
        if (condition) {
            json.put(value.getTime());
        } else {
            json.put(JSONObject.NULL);
        }
    }

    public static void writeValue(JSONValue value, JSONArray jsonArray) {
        if (value == null) {
            jsonArray.put(JSONObject.NULL);
        } else {
            jsonArray.put((Object)value);
        }
    }

    public static void writeValue(JSONValue value, JSONArray json, boolean condition) {
        if (condition) {
            json.put((Object)value);
        } else {
            json.put(JSONObject.NULL);
        }
    }

    public static void writeValue(Date value, TimeZone timeZone, JSONArray jsonArray) {
        DataWriter.writeValue(value, value, timeZone, jsonArray);
    }

    static void writeValue(Date value, TimeZone timeZone, JSONArray json, boolean condition) {
        if (condition) {
            DataWriter.writeValue(value, timeZone, json);
        } else {
            json.put(JSONObject.NULL);
        }
    }

    public static void writeValue(Date value, Date offsetDate, TimeZone timeZone, JSONArray jsonArray) {
        if (value == null) {
            jsonArray.put(JSONObject.NULL);
        } else {
            int offset = timeZone.getOffset(offsetDate.getTime());
            jsonArray.put(value.getTime() + (long)offset);
        }
    }

    public static void writeValueNull(JSONArray jsonArray) {
        jsonArray.put(JSONObject.NULL);
    }

    protected void writeFields(DataObject obj, TimeZone tz, JSONObject json, Session session) throws JSONException {
        JSONException je;
        WriterProcedure<DataObject> procedure = new WriterProcedure<DataObject>(obj, json, tz, session);
        if (!WRITER_MAP.forEachValue(procedure) && null != (je = procedure.getError())) {
            throw je;
        }
    }

    protected boolean writeField(DataObject obj, int column, TimeZone tz, JSONArray json, Session session) throws JSONException {
        FieldWriter writer = (FieldWriter)WRITER_MAP.get(column);
        if (null == writer) {
            return false;
        }
        writer.write(obj, tz, json, session);
        return true;
    }

    protected static Map<String, Object> contributeTo(Map<String, Object> map, DataObject obj, Session session) {
        String topic = obj.getTopic();
        if (null != topic) {
            MetaContributorRegistry registry = MetaContributors.getRegistry();
            if (null == registry) {
                return map;
            }
            Set contributors = registry.getMetaContributors(topic);
            if (null != contributors && !contributors.isEmpty()) {
                LinkedHashMap<String, Object> mapp = null == map ? new LinkedHashMap<String, Object>(2) : map;
                int objectID = obj.getObjectID();
                String id = objectID <= 0 ? null : Integer.toString(objectID);
                for (MetaContributor contributor : contributors) {
                    try {
                        contributor.contributeTo(mapp, id, session);
                    }
                    catch (Exception e) {
                        LOG.warn("Cannot contribute to entity (contributor={}, entity={})", new Object[]{contributor.getClass().getName(), objectID, e});
                    }
                }
                return mapp;
            }
        }
        return map;
    }

    static {
        TIntObjectHashMap m = new TIntObjectHashMap(8, 1.0f);
        m.put(1, OBJECT_ID_WRITER);
        m.put(2, CREATED_BY_WRITER);
        m.put(4, CREATION_DATE_WRITER);
        m.put(3, MODIFIED_BY_WRITER);
        m.put(5, LAST_MODIFIED_WRITER);
        m.put(6, LAST_MODIFIED_UTC_WRITER);
        m.put(23, META_WRITER);
        WRITER_MAP = m;
    }

    protected static interface FieldWriter<T> {
        public void write(T var1, TimeZone var2, JSONArray var3, Session var4) throws JSONException;

        public void write(T var1, TimeZone var2, JSONObject var3, Session var4) throws JSONException;
    }
}

