/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.cache.ResourceCaches;
import com.openexchange.ajax.requesthandler.converters.preview.cache.CacheKeyGenerator;
import com.openexchange.java.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewThumbCacheKeyGenerator
implements CacheKeyGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewThumbCacheKeyGenerator.class);
    private final AJAXRequestResult result;
    private final String width;
    private final String height;
    private final String scaleType;
    private final AJAXRequestData requestData;
    private String cachedCacheKey = null;

    public PreviewThumbCacheKeyGenerator(AJAXRequestResult result, AJAXRequestData requestData) {
        this.result = result;
        this.requestData = requestData;
        this.width = requestData.getParameter("width");
        this.height = requestData.getParameter("height");
        this.scaleType = requestData.getParameter("scaleType");
    }

    @Override
    public String generateCacheKey() {
        String eTag;
        if (this.cachedCacheKey == null && !Strings.isEmpty((String)(eTag = this.result.getHeader("ETag")))) {
            this.cachedCacheKey = ResourceCaches.generateDefaultThumbnailCacheKey(eTag, this.requestData);
            LOG.debug("Generated cacheKey {} based on etag {}, width {}, height {} and scaleType {}", new Object[]{this.cachedCacheKey, eTag, this.width, this.height, this.scaleType});
        }
        return this.cachedCacheKey;
    }
}

