/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login.osgi;

import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.osgi.LoginServletRegisterer;
import com.openexchange.ajax.login.osgi.TokenLoginCustomizer;
import com.openexchange.config.ConfigurationService;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.login.LoginRampUpService;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.login.internal.format.CompositeLoginFormatter;
import com.openexchange.oauth.provider.OAuthProviderService;
import com.openexchange.oauth.provider.v2.OAuth2ProviderService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.osgi.ServiceSet;
import com.openexchange.osgi.SimpleRegistryListener;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tokenlogin.TokenLoginService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LoginActivator
extends HousekeepingActivator {
    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class};
    }

    protected void startBundle() throws Exception {
        final BundleContext context = this.context;
        class ServerServiceRegistryTracker<S>
        implements ServiceTrackerCustomizer<S, S> {
            ServerServiceRegistryTracker() {
            }

            public S addingService(ServiceReference<S> reference) {
                Object service = context.getService(reference);
                ServerServiceRegistry.getInstance().addService(service);
                return (S)service;
            }

            public void modifiedService(ServiceReference<S> reference, S service) {
            }

            public void removedService(ServiceReference<S> reference, S service) {
                context.ungetService(reference);
                ServerServiceRegistry.getInstance().removeService(service.getClass());
            }
        }
        this.track(OAuthProviderService.class, new ServerServiceRegistryTracker());
        this.track(OAuth2ProviderService.class, new ServerServiceRegistryTracker());
        ServiceSet rampUp = new ServiceSet();
        this.track(LoginRampUpService.class, (SimpleRegistryListener)rampUp);
        Filter filter = context.createFilter("(|(objectClass=" + ConfigurationService.class.getName() + ")(" + "objectClass" + '=' + HttpService.class.getName() + ")(" + "objectClass" + '=' + DispatcherPrefixService.class.getName() + ")(" + "objectClass" + '=' + LoginRequestHandler.class.getName() + "))");
        this.rememberTracker(new ServiceTracker(context, filter, (ServiceTrackerCustomizer)new LoginServletRegisterer(context, (ServiceSet<LoginRampUpService>)rampUp)));
        this.track(TokenLoginService.class, new TokenLoginCustomizer(context));
        this.openTrackers();
        ConfigurationService configurationService = (ConfigurationService)this.getService(ConfigurationService.class);
        String loginFormat = configurationService.getProperty("com.openexchange.ajax.login.formatstring.login");
        String logoutFormat = configurationService.getProperty("com.openexchange.ajax.login.formatstring.logout");
        LoginPerformer.setLoginFormatter(new CompositeLoginFormatter(loginFormat, logoutFormat));
    }
}

