/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.container.ByteArrayInputStreamClosure;
import com.openexchange.ajax.container.ByteArrayRandomAccess;
import com.openexchange.ajax.container.FileRandomAccess;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;

public class FileHolder
implements IFileHolder {
    private static final Field bufField;
    private static final Field markField;
    private IFileHolder.InputStreamClosure isClosure;
    private InputStream is;
    private long length;
    private String contentType;
    private String name;
    private String disposition;
    private String delivery;
    private File file;
    private byte[] bytes;
    private IFileHolder.RandomAccess raf;
    private final List<Runnable> tasks;

    private static byte[] bytesFrom(ByteArrayInputStream bais) {
        if (null == bais) {
            return null;
        }
        try {
            Field bufField = FileHolder.bufField;
            Field markfield = markField;
            if (null != bufField && null != markfield) {
                byte[] buf = (byte[])bufField.get(bais);
                int mark = markfield.getInt(bais);
                if (mark <= 0) {
                    return buf;
                }
                int len = buf.length - mark;
                if (len <= 0) {
                    return null;
                }
                byte[] ret = new byte[len];
                System.arraycopy(buf, mark, ret, 0, len);
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static IFileHolder.InputStreamClosure newClosureFor(File file) {
        return null == file ? null : new FileInputStreamClosure(file);
    }

    public FileHolder(InputStream is, long length, String contentType, String name) {
        this.is = is;
        this.length = length;
        this.contentType = contentType;
        this.name = name;
        this.tasks = new LinkedList<Runnable>();
        this.file = null;
        if (is instanceof ByteArrayInputStream) {
            this.bytes = FileHolder.bytesFrom((ByteArrayInputStream)is);
            this.isClosure = new ByteArrayInputStreamClosure(this.bytes);
            this.length = this.bytes.length;
        } else {
            this.bytes = null;
        }
    }

    public FileHolder(IFileHolder.InputStreamClosure isClosure, long length, String contentType, String name) {
        this.isClosure = isClosure;
        this.length = length;
        this.contentType = contentType;
        this.name = name;
        this.tasks = new LinkedList<Runnable>();
        if (isClosure instanceof FileInputStreamClosure) {
            this.file = ((FileInputStreamClosure)isClosure).file;
            this.bytes = null;
        } else if (isClosure instanceof ByteArrayInputStreamClosure) {
            this.file = null;
            this.bytes = ((ByteArrayInputStreamClosure)isClosure).bytes;
        } else {
            this.file = null;
            this.bytes = null;
        }
    }

    public FileHolder(File file) {
        this(file, null);
    }

    public FileHolder(final File file, String contentType) {
        this.length = file.length();
        this.contentType = contentType == null ? MimeType2ExtMap.getContentType(file) : contentType;
        this.name = file.getName();
        this.tasks = new LinkedList<Runnable>();
        this.isClosure = new IFileHolder.InputStreamClosure(){

            @Override
            public InputStream newStream() throws OXException, IOException {
                return new FileInputStream(file);
            }
        };
        this.file = file;
        this.bytes = null;
    }

    @Override
    public List<Runnable> getPostProcessingTasks() {
        return this.tasks;
    }

    @Override
    public void addPostProcessingTask(Runnable task) {
        if (null != task) {
            this.tasks.add(task);
        }
    }

    public FileHolder setRandomAccess(IFileHolder.RandomAccess raf) {
        this.raf = raf;
        return this;
    }

    @Override
    public boolean repetitive() {
        byte[] bytes;
        if (null != this.isClosure) {
            return true;
        }
        if (this.is instanceof ByteArrayInputStream && null != (bytes = FileHolder.bytesFrom((ByteArrayInputStream)this.is))) {
            this.isClosure = new ByteArrayInputStreamClosure(bytes);
            this.is = null;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public InputStream getStream() throws OXException {
        IFileHolder.InputStreamClosure isClosure = this.isClosure;
        if (null != isClosure) {
            try {
                return isClosure.newStream();
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
        }
        return this.is;
    }

    @Override
    public IFileHolder.RandomAccess getRandomAccess() throws OXException {
        IFileHolder.RandomAccess raf = this.raf;
        if (null != raf) {
            return raf;
        }
        File file = this.file;
        if (null != file) {
            try {
                return new FileRandomAccess(file);
            }
            catch (FileNotFoundException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
        }
        byte[] bytes = this.bytes;
        if (null != bytes) {
            return new ByteArrayRandomAccess(bytes);
        }
        return null;
    }

    public void setStream(InputStream is) {
        Streams.close((Closeable)this.is);
        this.is = is;
        this.isClosure = null;
        this.file = null;
        this.raf = null;
        this.length = -1L;
        if (is instanceof ByteArrayInputStream) {
            this.bytes = FileHolder.bytesFrom((ByteArrayInputStream)is);
            this.isClosure = new ByteArrayInputStreamClosure(this.bytes);
            this.length = this.bytes.length;
        } else {
            this.bytes = null;
        }
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    @Override
    public String getDelivery() {
        return this.delivery;
    }

    static {
        Field f;
        try {
            f = ByteArrayInputStream.class.getDeclaredField("buf");
            f.setAccessible(true);
        }
        catch (SecurityException e) {
            f = null;
        }
        catch (NoSuchFieldException e) {
            f = null;
        }
        bufField = f;
        try {
            f = ByteArrayInputStream.class.getDeclaredField("mark");
            f.setAccessible(true);
        }
        catch (SecurityException e) {
            f = null;
        }
        catch (NoSuchFieldException e) {
            f = null;
        }
        markField = f;
    }

    private static final class FileInputStreamClosure
    implements IFileHolder.InputStreamClosure {
        final File file;

        FileInputStreamClosure(File file) {
            this.file = file;
        }

        @Override
        public InputStream newStream() throws IOException {
            return new FileInputStream(this.file);
        }
    }
}

