/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentLinkedList<E>
extends LinkedList<E> {
    private static final long serialVersionUID = 1325003661930837607L;
    private final AtomicReference<LinkedList<E>> ref;

    public ConcurrentLinkedList() {
        this.ref = new AtomicReference(new LinkedList());
    }

    public ConcurrentLinkedList(Collection<? extends E> c) {
        this.ref = new AtomicReference<LinkedList<? extends E>>(new LinkedList<E>(c));
    }

    public LinkedList<E> getSnapshot() {
        return new LinkedList(this.ref.get());
    }

    @Override
    public int size() {
        return this.ref.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.ref.get().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.ref.get().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.ref.get().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.ref.get().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.ref.get().toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean added;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            added = list.add(e);
        } while (!this.ref.compareAndSet(expected, list));
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            removed = list.remove(o);
        } while (!this.ref.compareAndSet(expected, list));
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.ref.get().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added;
        LinkedList<? extends E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            added = list.addAll(c);
        } while (!this.ref.compareAndSet(expected, list));
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean added;
        LinkedList<? extends E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            added = list.addAll(index, c);
        } while (!this.ref.compareAndSet(expected, list));
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            removed = list.removeAll(c);
        } while (!this.ref.compareAndSet(expected, list));
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retained;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            retained = list.retainAll(c);
        } while (!this.ref.compareAndSet(expected, list));
        return retained;
    }

    @Override
    public void clear() {
        LinkedList list;
        LinkedList<E> expected;
        while (!this.ref.compareAndSet(expected = this.ref.get(), list = new LinkedList())) {
        }
    }

    @Override
    public E get(int index) {
        return this.ref.get().get(index);
    }

    @Override
    public E set(int index, E element) {
        E ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.set(index, element);
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public void add(int index, E element) {
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            list.add(index, element);
        } while (!this.ref.compareAndSet(expected, list));
    }

    @Override
    public E remove(int index) {
        E ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.remove(index);
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public int indexOf(Object o) {
        return this.ref.get().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.ref.get().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.ref.get().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.ref.get().listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.ref.get().subList(fromIndex, toIndex);
    }

    @Override
    public E getFirst() {
        return this.ref.get().getFirst();
    }

    @Override
    public E getLast() {
        return this.ref.get().getLast();
    }

    @Override
    public E removeFirst() {
        E ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.removeFirst();
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public E removeLast() {
        E ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.removeLast();
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public void addFirst(E e) {
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            list.addFirst(e);
        } while (!this.ref.compareAndSet(expected, list));
    }

    @Override
    public void addLast(E e) {
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            list.addLast(e);
        } while (!this.ref.compareAndSet(expected, list));
    }

    @Override
    public E peek() {
        return this.ref.get().peek();
    }

    @Override
    public E element() {
        return this.ref.get().element();
    }

    @Override
    public E poll() {
        E ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.poll();
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public E remove() {
        E ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.remove();
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public boolean offer(E e) {
        boolean ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.offer(e);
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public boolean offerFirst(E e) {
        boolean ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.offerFirst(e);
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public boolean offerLast(E e) {
        boolean ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.offerLast(e);
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public E peekFirst() {
        return this.ref.get().peekFirst();
    }

    @Override
    public E peekLast() {
        return this.ref.get().peekLast();
    }

    @Override
    public E pollFirst() {
        E ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.pollFirst();
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public E pollLast() {
        E ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.pollLast();
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public void push(E e) {
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            list.push(e);
        } while (!this.ref.compareAndSet(expected, list));
    }

    @Override
    public E pop() {
        E ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.pop();
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        boolean ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.removeFirstOccurrence(o);
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        boolean ret;
        LinkedList<E> list;
        LinkedList<E> expected;
        do {
            expected = this.ref.get();
            list = new LinkedList<E>(expected);
            ret = list.removeLastOccurrence(o);
        } while (!this.ref.compareAndSet(expected, list));
        return ret;
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.ref.get().descendingIterator();
    }
}

