/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentEnumSet<E extends Enum<E>>
implements Set<E> {
    private final AtomicReference<EnumSet<E>> ref;
    private final Class<E> elementType;

    public ConcurrentEnumSet(Class<E> elementType) {
        this.ref = new AtomicReference<EnumSet<E>>(EnumSet.noneOf(elementType));
        this.elementType = elementType;
    }

    public ConcurrentEnumSet(Collection<E> c, Class<E> elementType) {
        this.ref = new AtomicReference<EnumSet<E>>(EnumSet.copyOf(c));
        this.elementType = elementType;
    }

    public Set<E> getSnapshot() {
        return Collections.unmodifiableSet((Set)this.ref.get());
    }

    @Override
    public int size() {
        return this.ref.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.ref.get().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.ref.get().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.ref.get().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.ref.get().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.ref.get().toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean added;
        EnumSet<E> set;
        EnumSet<E> expected;
        do {
            expected = this.ref.get();
            set = EnumSet.copyOf(expected);
            added = set.add(e);
        } while (!this.ref.compareAndSet(expected, set));
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed;
        EnumSet<E> set;
        EnumSet<E> expected;
        do {
            expected = this.ref.get();
            set = EnumSet.copyOf(expected);
            removed = set.remove(o);
        } while (!this.ref.compareAndSet(expected, set));
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.ref.get().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added;
        EnumSet<? extends E> set;
        EnumSet<E> expected;
        do {
            expected = this.ref.get();
            set = EnumSet.copyOf(expected);
            added = set.addAll(c);
        } while (!this.ref.compareAndSet(expected, set));
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret;
        EnumSet<E> set;
        EnumSet<E> expected;
        do {
            expected = this.ref.get();
            set = EnumSet.copyOf(expected);
            ret = set.retainAll(c);
        } while (!this.ref.compareAndSet(expected, set));
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret;
        EnumSet<E> set;
        EnumSet<E> expected;
        do {
            expected = this.ref.get();
            set = EnumSet.copyOf(expected);
            ret = set.removeAll(c);
        } while (!this.ref.compareAndSet(expected, set));
        return ret;
    }

    @Override
    public void clear() {
        EnumSet<E> set;
        EnumSet<E> expected;
        while (!this.ref.compareAndSet(expected = this.ref.get(), set = EnumSet.noneOf(this.elementType))) {
        }
    }
}

