/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.stream;

import java.io.IOException;
import java.io.StringWriter;

public class UnsynchronizedStringWriter
extends StringWriter {
    private final StringBuilder buf;

    public UnsynchronizedStringWriter() {
        this.buf = new StringBuilder();
        this.lock = this.buf;
    }

    public UnsynchronizedStringWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buf = new StringBuilder(initialSize);
        this.lock = this.buf;
    }

    @Override
    public void write(int c) {
        this.buf.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.append(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.buf.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.buf.append(str.substring(off, off + len));
    }

    @Override
    public StringWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(((Object)csq).toString());
        }
        return this;
    }

    @Override
    public StringWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(((Object)cs.subSequence(start, end)).toString());
        return this;
    }

    @Override
    public StringWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public String toString() {
        return this.buf.toString();
    }

    @Override
    @Deprecated
    public StringBuffer getBuffer() {
        return new StringBuffer(this.buf);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

