/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cli;

import com.openexchange.auth.mbean.AuthenticatorMBean;
import com.openexchange.cli.AbstractCLI;
import com.openexchange.cli.ExecutionFault;
import com.openexchange.cli.JMXAuthenticatorImpl;
import com.openexchange.cli.ReservedOptions;
import com.openexchange.java.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public abstract class AbstractMBeanCLI<R>
extends AbstractCLI {
    protected AbstractMBeanCLI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R execute(String[] args) {
        options = new ReservedOptions();
        error = true;
        try {
            options.addOption("h", "help", false, "Prints a help text");
            options.addOption("p", "port", true, "The optional JMX port (default:9999)");
            options.addOption("l", "login", true, "The optional JMX login (if JMX authentication is enabled)");
            options.addOption("s", "password", true, "The optional JMX password (if JMX authentication is enabled)");
            requiresAdministrativePermission = this.requiresAdministrativePermission();
            if (requiresAdministrativePermission) {
                options.addOption("A", "adminuser", true, "Admin username");
                options.addOption("P", "adminpass", true, "Admin password");
            }
            this.addOptions(options);
            parser = new PosixParser();
            cmd = parser.parse((Options)options, args);
            if (cmd.hasOption('h')) {
                this.printHelp(options);
                System.exit(0);
                var7_12 = null;
                return var7_12;
            }
            port = this.parsePort('p', 9999, cmd, options);
            jmxLogin = null;
            if (cmd.hasOption('l')) {
                jmxLogin = cmd.getOptionValue('l');
            }
            jmxPassword = null;
            if (cmd.hasOption('s')) {
                jmxPassword = cmd.getOptionValue('s');
            }
            this.checkOptions(cmd, options);
            if (jmxLogin == null || jmxPassword == null) {
                environment = null;
            } else {
                environment = new HashMap<String, JMXAuthenticatorImpl>(1);
                environment.put("jmx.remote.authenticator", new JMXAuthenticatorImpl(jmxLogin, jmxPassword));
            }
            url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            jmxConnector = JMXConnectorFactory.connect(url, environment);
            retval = null;
            try {
                mbsc = jmxConnector.getMBeanServerConnection();
                try {
                    if (requiresAdministrativePermission && this.isAuthEnabled(authenticator = this.authenticatorMBean(mbsc))) {
                        adminLogin = cmd.getOptionValue('A');
                        if (Strings.isEmpty((String)adminLogin)) {
                            System.out.println("You must provide administrative credentials to proceed.");
                            this.printHelp(options);
                            System.exit(-1);
                            var17_25 = null;
                            return var17_25;
                        }
                    }
                    ** GOTO lbl71
                }
                catch (Exception e) {
                    t = e.getCause();
                    if (null == t) {
                        v0 /* !! */  = e;
                        throw new ExecutionFault(v0 /* !! */ );
                    }
                    v0 /* !! */  = t;
                    throw new ExecutionFault(v0 /* !! */ );
                }
                adminPassword = cmd.getOptionValue('P');
                if (!Strings.isEmpty((String)adminPassword)) ** GOTO lbl-1000
                System.out.println("You must provide administrative credentials to proceed.");
                this.printHelp(options);
                System.exit(-1);
                var18_28 = null;
                return var18_28;
lbl-1000:
                // 1 sources

                {
                    this.administrativeAuth(adminLogin, adminPassword, cmd, authenticator);
lbl71:
                    // 2 sources

                    retval = this.invoke(options, cmd, mbsc);
                }
            }
            finally {
                try {
                    jmxConnector.close();
                }
                catch (Exception e) {}
            }
            error = false;
            var14_20 = retval;
            return var14_20;
        }
        catch (ExecutionFault e) {
            t = e.getCause();
            message = t.getMessage();
            System.err.println(null == message ? "An error occurred." : message);
            return null;
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            this.printHelp(options);
            return null;
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
            return null;
        }
        catch (RuntimeException e) {
            System.err.println("Problem in runtime: " + e.getMessage());
            return null;
        }
        finally {
            if (error) {
                System.exit(1);
            }
        }
    }

    protected AuthenticatorMBean authenticatorMBean(MBeanServerConnection mbsc) throws MalformedObjectNameException {
        return AbstractMBeanCLI.getMBean(mbsc, AuthenticatorMBean.class, "com.openexchange.auth");
    }

    protected boolean isAuthEnabled(AuthenticatorMBean authenticator) throws MBeanException {
        return !authenticator.isMasterAuthenticationDisabled();
    }

    protected abstract void administrativeAuth(String var1, String var2, CommandLine var3, AuthenticatorMBean var4) throws MBeanException;

    protected abstract void addOptions(Options var1);

    protected abstract R invoke(Options var1, CommandLine var2, MBeanServerConnection var3) throws Exception;

    protected static <MBean> MBean getMBean(MBeanServerConnection mbsc, Class<? extends MBean> clazz, String domain) throws MalformedObjectNameException {
        return MBeanServerInvocationHandler.newProxyInstance(mbsc, AbstractMBeanCLI.getObjectName(clazz.getName(), domain), clazz, false);
    }

    protected static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }
}

