/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.file.storage.FileStorageConstants;
import com.openexchange.file.storage.FileStoragePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface FileStorageFolder
extends FileStorageConstants {
    public static final String ROOT_FULLNAME = "";
    public static final String CAPABILITY_PERMISSIONS = "permissions";
    public static final String CAPABILITY_QUOTA = "quota";
    public static final String CAPABILITY_SORT = "sort";
    public static final String CAPABILITY_SUBSCRIPTION = "subscription";
    public static final String CAPABILITY_PUBLICATION = "publication";
    public static final Set<String> ALL_CAPABILITIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("permissions", "publication", "quota", "sort", "subscription")));

    public Set<String> getCapabilities();

    public String getId();

    public String getName();

    public FileStoragePermission getOwnPermission();

    public String getParentId();

    public List<FileStoragePermission> getPermissions();

    public boolean hasSubfolders();

    public boolean hasSubscribedSubfolders();

    public boolean isSubscribed();

    public Date getCreationDate();

    public Date getLastModifiedDate();

    public boolean isHoldsFolders();

    public boolean isHoldsFiles();

    public boolean isRootFolder();

    public boolean isDefaultFolder();

    public int getFileCount();

    public Map<String, Object> getProperties();

    public Map<String, Object> getMeta();
}

