/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.meta.FileComparator;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tx.TransactionAware;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public interface FileStorageFileAccess
extends TransactionAware {
    public static final String CURRENT_VERSION = null;
    public static final String NEW = null;
    public static final String ALL_FOLDERS = null;
    public static final long UNDEFINED_SEQUENCE_NUMBER = -1L;
    public static final long DISTANT_FUTURE = Long.MAX_VALUE;
    public static final long DISTANT_PAST = Long.MIN_VALUE;
    public static final int NOT_SET = -11;

    public boolean exists(String var1, String var2, String var3) throws OXException;

    public File getFileMetadata(String var1, String var2, String var3) throws OXException;

    public IDTuple saveFileMetadata(File var1, long var2) throws OXException;

    public IDTuple saveFileMetadata(File var1, long var2, List<File.Field> var4) throws OXException;

    public IDTuple copy(IDTuple var1, String var2, String var3, File var4, InputStream var5, List<File.Field> var6) throws OXException;

    public IDTuple move(IDTuple var1, String var2, long var3, File var5, List<File.Field> var6) throws OXException;

    public InputStream getDocument(String var1, String var2, String var3) throws OXException;

    public IDTuple saveDocument(File var1, InputStream var2, long var3) throws OXException;

    public IDTuple saveDocument(File var1, InputStream var2, long var3, List<File.Field> var5) throws OXException;

    public void removeDocument(String var1, long var2) throws OXException;

    public List<IDTuple> removeDocument(List<IDTuple> var1, long var2) throws OXException;

    public List<IDTuple> removeDocument(List<IDTuple> var1, long var2, boolean var4) throws OXException;

    public void touch(String var1, String var2) throws OXException;

    public TimedResult<File> getDocuments(String var1) throws OXException;

    public TimedResult<File> getDocuments(String var1, List<File.Field> var2) throws OXException;

    public TimedResult<File> getDocuments(String var1, List<File.Field> var2, File.Field var3, SortDirection var4) throws OXException;

    public TimedResult<File> getDocuments(List<IDTuple> var1, List<File.Field> var2) throws OXException;

    public Delta<File> getDelta(String var1, long var2, List<File.Field> var4, boolean var5) throws OXException;

    public Delta<File> getDelta(String var1, long var2, List<File.Field> var4, File.Field var5, SortDirection var6, boolean var7) throws OXException;

    public SearchIterator<File> search(String var1, List<File.Field> var2, String var3, File.Field var4, SortDirection var5, int var6, int var7) throws OXException;

    public FileStorageAccountAccess getAccountAccess();

    public static enum SortDirection {
        ASC,
        DESC;

        public static final SortDirection DEFAULT;

        public Comparator<File> comparatorBy(File.Field by) {
            FileComparator fileComparator = new FileComparator(by);
            switch (this) {
                case ASC: {
                    return fileComparator;
                }
                case DESC: {
                    return new InverseComparator(fileComparator);
                }
            }
            return null;
        }

        public Comparator<File> comparatorBy(File.Field by, Comparator<File> comparator) {
            FileComparator fileComparator = new FileComparator(by, comparator);
            switch (this) {
                case ASC: {
                    return fileComparator;
                }
                case DESC: {
                    return new InverseComparator(fileComparator);
                }
            }
            return null;
        }

        public void sort(List<File> collection, File.Field by) {
            Collections.sort(collection, this.comparatorBy(by));
        }

        public void sort(List<File> collection, File.Field by, Comparator<File> comparator) {
            Collections.sort(collection, this.comparatorBy(by, comparator));
        }

        public static SortDirection get(String name) {
            if (name == null) {
                return DEFAULT;
            }
            for (SortDirection dir : SortDirection.values()) {
                if (!dir.name().equalsIgnoreCase(name)) continue;
                return dir;
            }
            return null;
        }

        static {
            DEFAULT = ASC;
        }

        private static final class InverseComparator
        implements Comparator<File> {
            private Comparator<File> delegate = null;

            public InverseComparator(Comparator<File> delegate) {
                this.delegate = delegate;
            }

            @Override
            public int compare(File o1, File o2) {
                return -this.delegate.compare(o1, o2);
            }
        }
    }

    public static class IDTuple {
        private String folder;
        private String id;

        public IDTuple() {
        }

        public IDTuple(String folder, String id) {
            this();
            this.folder = folder;
            this.id = id;
        }

        public String getFolder() {
            return this.folder;
        }

        public void setFolder(String folder) {
            this.folder = folder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IDTuple other = (IDTuple)obj;
            if (this.folder == null ? other.folder != null : !this.folder.equals(other.folder)) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public String toString() {
            return "IDTuple [folder=" + this.folder + ", id=" + this.id + "]";
        }
    }
}

