/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.WarningsAware;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultWarningsAware
implements WarningsAware {
    private final List<OXException> warnings;

    public DefaultWarningsAware() {
        this(false);
    }

    public DefaultWarningsAware(boolean concurrent) {
        this.warnings = concurrent ? new CopyOnWriteArrayList() : new ArrayList(4);
    }

    @Override
    public List<OXException> getWarnings() {
        return new ArrayList<OXException>(this.warnings);
    }

    @Override
    public List<OXException> getAndFlushWarnings() {
        ArrayList<OXException> ret = new ArrayList<OXException>(this.warnings);
        this.warnings.clear();
        return ret;
    }

    @Override
    public void addWarning(OXException warning) {
        this.warnings.add(warning);
    }

    @Override
    public void removeWarning(OXException warning) {
        this.warnings.remove(warning);
    }
}

