/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.parser;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.ExternalGroupParticipant;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.Participants;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.webdav.xml.XmlServlet;
import com.openexchange.webdav.xml.parser.CommonParser;
import java.util.List;
import org.jdom2.Element;

public abstract class CalendarParser
extends CommonParser {
    protected void parseElementCalendar(CalendarObject calendarobject, Element eProp) throws OXException {
        if (CalendarParser.hasElement(eProp.getChild("recurrence_id", XmlServlet.NS))) {
            calendarobject.setRecurrenceID(CalendarParser.getValueAsInt(eProp.getChild("recurrence_id", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("recurrence_position", XmlServlet.NS))) {
            calendarobject.setRecurrencePosition(CalendarParser.getValueAsInt(eProp.getChild("recurrence_position", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("recurrence_date_position", XmlServlet.NS))) {
            calendarobject.setRecurrenceDatePosition(CalendarParser.getValueAsDate(eProp.getChild("recurrence_date_position", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("month", XmlServlet.NS))) {
            calendarobject.setMonth(CalendarParser.getValueAsInt(eProp.getChild("month", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("day_in_month", XmlServlet.NS))) {
            calendarobject.setDayInMonth(CalendarParser.getValueAsInt(eProp.getChild("day_in_month", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("days", XmlServlet.NS))) {
            calendarobject.setDays(CalendarParser.getValueAsInt(eProp.getChild("days", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("interval", XmlServlet.NS))) {
            calendarobject.setInterval(CalendarParser.getValueAsInt(eProp.getChild("interval", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("until", XmlServlet.NS))) {
            calendarobject.setUntil(CalendarParser.getValueAsDate(eProp.getChild("until", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("start_date", XmlServlet.NS))) {
            calendarobject.setStartDate(CalendarParser.getValueAsDate(eProp.getChild("start_date", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("end_date", XmlServlet.NS))) {
            calendarobject.setEndDate(CalendarParser.getValueAsDate(eProp.getChild("end_date", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("recurrence_type", XmlServlet.NS))) {
            int recurrenceType = this.parseRecurrenceType(CalendarParser.getValue(eProp.getChild("recurrence_type", XmlServlet.NS)));
            calendarobject.setRecurrenceType(recurrenceType);
        }
        if (CalendarParser.hasElement(eProp.getChild("notify_participants", XmlServlet.NS))) {
            calendarobject.setNotification(CalendarParser.getValueAsBoolean(eProp.getChild("notify_participants", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("title", XmlServlet.NS))) {
            calendarobject.setTitle(CalendarParser.getValue(eProp.getChild("title", XmlServlet.NS)));
        }
        if (CalendarParser.hasElement(eProp.getChild("note", XmlServlet.NS))) {
            calendarobject.setNote(CalendarParser.getValue(eProp.getChild("note", XmlServlet.NS)));
        }
        this.parseElementParticipants(calendarobject, eProp.getChild("participants", XmlServlet.NS));
        this.parseElementCommon((CommonObject)calendarobject, eProp);
    }

    protected int parseRecurrenceType(String value) throws OXException {
        if (value.equals("none")) {
            return 0;
        }
        if (value.equals("daily")) {
            return 1;
        }
        if (value.equals("weekly")) {
            return 2;
        }
        if (value.equals("monthly")) {
            return 3;
        }
        if (value.equals("yearly")) {
            return 4;
        }
        throw OXException.general((String)("unknown value in recurrence_type: " + value));
    }

    protected void parseElementParticipants(CalendarObject calendarObj, Element eParticipant) throws OXException {
        int a;
        if (eParticipant == null) {
            return;
        }
        Participants participants = new Participants();
        boolean hasParticipants = false;
        List elementUsers = eParticipant.getChildren("user", XmlServlet.NS);
        List elementGroups = eParticipant.getChildren("group", XmlServlet.NS);
        List elementResources = eParticipant.getChildren("resource", XmlServlet.NS);
        if (elementUsers != null) {
            for (a = 0; a < elementUsers.size(); ++a) {
                this.parseElementUser((Element)elementUsers.get(a), participants);
                hasParticipants = true;
            }
        }
        if (elementGroups != null) {
            for (a = 0; a < elementGroups.size(); ++a) {
                this.parseElementGroup((Element)elementGroups.get(a), participants);
                hasParticipants = true;
            }
        }
        if (elementResources != null) {
            for (a = 0; a < elementResources.size(); ++a) {
                this.parseElementResource((Element)elementResources.get(a), participants);
                hasParticipants = true;
            }
        }
        if (hasParticipants) {
            calendarObj.setUsers(participants.getUsers());
            calendarObj.setParticipants(participants.getList());
        }
    }

    private void parseElementUser(Element e, Participants participants) throws OXException {
        UserParticipant participant = null;
        String external = e.getAttributeValue("external", XmlServlet.NS);
        if (external != null && "true".equals(external)) {
            String mail = e.getAttributeValue("mail", XmlServlet.NS);
            participant = new ExternalUserParticipant(mail);
        } else {
            UserParticipant userparticipant;
            int userId = CalendarParser.getValueAsInt(e);
            participant = userparticipant = new UserParticipant(userId);
            String confirm = e.getAttributeValue("confirm", XmlServlet.NS);
            if (confirm != null) {
                if (confirm.equals("accept")) {
                    userparticipant.setConfirm(1);
                } else if (confirm.equals("decline")) {
                    userparticipant.setConfirm(2);
                } else if (confirm.equals("tentative")) {
                    userparticipant.setConfirm(3);
                } else if (confirm.equals("none")) {
                    userparticipant.setConfirm(0);
                } else {
                    throw OXException.general((String)("unknown value in confirm attribute: " + confirm));
                }
            }
            participants.add(userparticipant);
        }
        participants.add((Participant)participant);
    }

    private void parseElementGroup(Element e, Participants participants) {
        GroupParticipant participant = null;
        String external = e.getAttributeValue("external", XmlServlet.NS);
        if (external != null && "true".equals(external)) {
            String mail = e.getAttributeValue("mail", XmlServlet.NS);
            participant = new ExternalGroupParticipant(mail);
        } else {
            int groupId = CalendarParser.getValueAsInt(e);
            participant = new GroupParticipant(groupId);
        }
        participants.add((Participant)participant);
    }

    private void parseElementResource(Element e, Participants participants) {
        int resourceId = CalendarParser.getValueAsInt(e);
        ResourceParticipant p = new ResourceParticipant(resourceId);
        participants.add((Participant)p);
    }
}

