/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.Messaging;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class MessagingFixtureFactory
implements FixtureFactory<Messaging> {
    private final FixtureLoader fixtureLoader;

    public MessagingFixtureFactory(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<Messaging> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new MessagingFixtures(fixtureName, entries, this.fixtureLoader);
    }

    private class MessagingFixtures
    extends DefaultFixtures<Messaging>
    implements Fixtures<Messaging> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<Messaging>> messagings;

        public MessagingFixtures(String fixtureName, Map<String, Map<String, String>> entries, FixtureLoader fixtureLoader) {
            super(Messaging.class, entries, fixtureLoader);
            this.messagings = new HashMap<String, Fixture<Messaging>>();
            this.entries = entries;
        }

        @Override
        public Fixture<Messaging> getEntry(String entryName) throws OXException {
            if (this.messagings.containsKey(entryName)) {
                return this.messagings.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            this.defaults(values);
            Messaging messaging = new Messaging();
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (values.containsKey("type")) {
                config.put("type", values.get("type"));
                values.remove("type");
            }
            if (values.containsKey("name")) {
                config.put("name", values.get("name"));
                values.remove("name");
            }
            if (values.containsKey("url")) {
                config.put("url", values.get("url"));
                values.remove("url");
            }
            if (values.containsKey("login")) {
                config.put("login", values.get("login"));
                values.remove("login");
            }
            if (values.containsKey("password")) {
                config.put("password", values.get("password"));
                values.remove("password");
            }
            if (values.containsKey("message")) {
                config.put("message", values.get("message") + " - " + UUID.randomUUID().toString());
                values.remove("message");
            }
            messaging.setConfiguration(config);
            this.apply(messaging, values);
            Fixture<Messaging> fixture = new Fixture<Messaging>(messaging, values.keySet().toArray(new String[values.size()]), values);
            this.messagings.put(entryName, fixture);
            return fixture;
        }

        private void defaults(Map<String, String> values) {
            if (!values.containsKey("displayName")) {
                values.put("displayName", values.get("login"));
            }
        }
    }
}

