/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import java.sql.SQLException;

public class Bug11148Test
extends CalendarSqlTest {
    public void testUpdateWithInvalidRecurrencePatternShouldFail() throws OXException, SQLException {
        CalendarDataObject cdao = this.appointments.buildRecurringAppointment();
        this.appointments.save(cdao);
        this.clean.add(cdao);
        CalendarDataObject modified = new CalendarDataObject();
        modified.setStartDate(cdao.getStartDate());
        modified.setEndDate(cdao.getEndDate());
        modified.setObjectID(cdao.getObjectID());
        modified.setParentFolderID(cdao.getParentFolderID());
        modified.setRecurrenceType(3);
        modified.setInterval(1);
        modified.setDays(4);
        modified.setDayInMonth(666);
        modified.setContext(cdao.getContext());
        try {
            this.appointments.save(modified);
            Bug11148Test.fail((String)"Could save invalid dayInMonth value");
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    public void testShouldRebuildEntireRecurrencePatternOnUpdate() throws SQLException, OXException {
        CalendarDataObject cdao = this.appointments.buildRecurringAppointment();
        this.appointments.save(cdao);
        this.clean.add(cdao);
        CalendarDataObject modified = new CalendarDataObject();
        modified.setObjectID(cdao.getObjectID());
        modified.setParentFolderID(cdao.getParentFolderID());
        modified.setContext(cdao.getContext());
        modified.setRecurrenceType(3);
        modified.setDayInMonth(12);
        modified.setInterval(2);
        modified.setOccurrence(3);
        try {
            this.appointments.save(modified);
            CalendarDataObject reloaded = this.appointments.reload(modified);
            Bug11148Test.assertEquals((int)0, (int)reloaded.getDays());
            Bug11148Test.assertEquals((int)12, (int)reloaded.getDayInMonth());
            Bug11148Test.assertEquals((int)2, (int)reloaded.getInterval());
            Bug11148Test.assertEquals((int)3, (int)reloaded.getRecurrenceType());
        }
        catch (OXException x) {
            x.printStackTrace();
            Bug11148Test.fail((String)x.toString());
        }
        catch (SQLException x) {
            x.printStackTrace();
            Bug11148Test.fail((String)x.toString());
        }
    }

    public void testShouldOnlyUpdateRecurrencePatternIfNeeded() throws SQLException, OXException {
        CalendarDataObject cdao = this.appointments.buildRecurringAppointment();
        this.appointments.save(cdao);
        this.clean.add(cdao);
        CalendarDataObject modified = new CalendarDataObject();
        modified.setObjectID(cdao.getObjectID());
        modified.setParentFolderID(cdao.getParentFolderID());
        modified.setContext(cdao.getContext());
        modified.setLocation("updated location");
        this.appointments.copyRecurringInformation(cdao, modified);
        try {
            this.appointments.save(modified);
            CalendarDataObject reloaded = this.appointments.reload(modified);
            Bug11148Test.assertEquals((int)cdao.getDays(), (int)reloaded.getDays());
            Bug11148Test.assertEquals((int)cdao.getDayInMonth(), (int)reloaded.getDayInMonth());
            Bug11148Test.assertEquals((int)cdao.getInterval(), (int)reloaded.getInterval());
            Bug11148Test.assertEquals((int)cdao.getRecurrenceType(), (int)reloaded.getRecurrenceType());
        }
        catch (OXException x) {
            x.printStackTrace();
            Bug11148Test.fail((String)x.toString());
        }
        catch (SQLException x) {
            x.printStackTrace();
            Bug11148Test.fail((String)x.toString());
        }
    }
}

